/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.datasense;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.dfl.ui.graphical.livedata.ITreeLiveDataProvider;
import org.mule.tooling.dfl.ui.output.JavaRecursionField;
import org.mule.tooling.dfl.ui.output.MetaDataModelSafeRecursionChildrenProvider;
import org.mule.tooling.dfl.ui.output.SafeRecursion;
import org.mule.tooling.dfl.ui.output.SafeRecursionField;
import org.mule.tooling.dfl.ui.output.SafeRecursionImpl;
import org.mule.tooling.dfl.ui.utils.WeaveGraphicalTreeNode;
import org.mule.tooling.ui.dfl.contribution.editor.script.input.OutputTreeLiveDataProvider;
import org.mule.tooling.ui.modules.core.metadata.MetadataTypeHelper;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;
import org.mule.tooling.ui.widgets.tree.model.IGraphicalChildrenProvider;

public class DFLMetadataPropertyGraphicalChildrenProvider
implements IGraphicalChildrenProvider<ObjectType> {
    private String propertyName;
    private OutputTreeLiveDataProvider outputTreeLiveDataProvider;

    public DFLMetadataPropertyGraphicalChildrenProvider(String propertyName, OutputTreeLiveDataProvider outputTreeLiveDataProvider) {
        this.propertyName = propertyName;
        this.outputTreeLiveDataProvider = outputTreeLiveDataProvider;
    }

    public List<GraphicalTreeNode<?>> getChildren(GraphicalTreeNode<ObjectType> parent) {
        ArrayList result = new ArrayList();
        ObjectType actualProperties = (ObjectType)parent.getModel();
        Optional root = actualProperties.getFieldByName(this.propertyName);
        if (root.isPresent()) {
            SafeRecursionImpl safeRecursion = new SafeRecursionImpl();
            MetadataType propertyModel = ((ObjectFieldType)root.get()).getValue();
            if (MetadataFormat.JAVA.equals((Object)propertyModel.getMetadataFormat())) {
                MetadataType defaultPojoMetaDataModel = propertyModel;
                String className = defaultPojoMetaDataModel.getAnnotation(TypeIdAnnotation.class).map(TypeIdAnnotation::getValue).orElse(Object.class.getCanonicalName());
                safeRecursion.push((SafeRecursionField)new JavaRecursionField(className));
            }
            WeaveGraphicalTreeNode rootNode = new WeaveGraphicalTreeNode(MetadataTypeHelper.getFieldLabel((ObjectFieldType)((ObjectFieldType)root.get())), "Expected Output", (Object)((ObjectFieldType)root.get()).getValue(), (IGraphicalChildrenProvider)new MetaDataModelSafeRecursionChildrenProvider((SafeRecursion)safeRecursion, (ITreeLiveDataProvider)this.outputTreeLiveDataProvider));
            return Arrays.asList(rootNode);
        }
        ObjectFieldTypeBuilder builder = new ObjectFieldTypeBuilder(actualProperties.getMetadataFormat());
        builder.key(this.propertyName);
        builder.value(MetadataFactory.undefined());
        ObjectFieldType newRoot = builder.build();
        result.add(new WeaveGraphicalTreeNode(parent, MetadataTypeHelper.getFieldLabel((ObjectFieldType)newRoot), MetadataTypeHelper.getFieldDescription((MetadataType)newRoot), (Object)newRoot.getValue(), (IGraphicalChildrenProvider)new MetaDataModelSafeRecursionChildrenProvider((SafeRecursion)new SafeRecursionImpl(), (ITreeLiveDataProvider)this.outputTreeLiveDataProvider)).id(this.propertyName));
        return result;
    }
}

