/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.datasense;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.core.classloader.ProjectClasspathUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLField;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLType;
import org.mule.tooling.dfl.ui.contentassist.model.types.DFLTypeFactory;
import org.mule.tooling.dfl.ui.contentassist.model.types.ExtendedType;
import org.mule.tooling.dfl.ui.module.IWeaveUIModule;
import org.mule.tooling.dfl.ui.module.WeaveUIModuleManager;
import org.mule.tooling.ui.dfl.contribution.editor.datasense.model.CustomMetadataBuilder;
import org.mule.tooling.ui.dfl.contribution.editor.datasense.model.IObjectBuilder;

public class DFLMetadataModelHelper {
    public static MetadataType buildMetadataType(IMuleProject project, IDFLType type, String mimeType) {
        IDFLField root;
        IDFLType rootType;
        List rootFields;
        IWeaveUIModule weaveUiModule = WeaveUIModuleManager.getModuleByContentType((String)mimeType);
        MetadataFormat metadataFormat = (MetadataFormat)weaveUiModule.getMetadataFormat().get(0);
        if (MetadataFormat.XML.equals((Object)metadataFormat) && type.isObject() && (rootFields = type.asObjectType().getFields()).size() == 1 && (rootType = (root = (IDFLField)rootFields.get(0)).getType()).isObject()) {
            root.getName();
            TypeBuilder<MetadataType> xmlMetaDataModel = DFLMetadataModelHelper.toMetadataType(project, metadataFormat, rootType, root.getAttributes());
            return xmlMetaDataModel.build();
        }
        return DFLMetadataModelHelper.toMetadataType(project, metadataFormat, type).build();
    }

    public static TypeBuilder<MetadataType> toMetadataType(IMuleProject project, MetadataFormat contentType, IDFLType type) {
        return DFLMetadataModelHelper.toMetadataType(project, contentType, type, Collections.emptyList());
    }

    public static TypeBuilder<MetadataType> toMetadataType(IMuleProject project, MetadataFormat contentType, IDFLType type, List<IDFLField> attributes) {
        CustomMetadataBuilder metadataBuilder = new CustomMetadataBuilder();
        if (type.isObject()) {
            IObjectBuilder dynamicObject;
            Optional classValue = type.getSchemaValue("class");
            if (classValue.isPresent()) {
                Class loadClass = ProjectClasspathUtils.loadClass((String)classValue.get().toString(), (IMuleProject)project);
                dynamicObject = metadataBuilder.createObject(contentType, loadClass);
            } else {
                dynamicObject = metadataBuilder.createObject(contentType);
            }
            List fields = type.asObjectType().getFields();
            for (IDFLField field : fields) {
                TypeBuilder<MetadataType> metaDataModel = DFLMetadataModelHelper.toMetadataType(project, contentType, field.getType(), field.getAttributes());
                TypeAnnotation[] propsArray = DFLMetadataModelHelper.getMetadataProperties(field);
                dynamicObject.addField(field.getName(), metaDataModel, propsArray);
            }
            for (IDFLField attribute : attributes) {
                dynamicObject.addField(attribute.getName(), DFLMetadataModelHelper.toMetadataType(project, contentType, attribute.getType()), new TypeAnnotation[]{new LabelAnnotation("@" + String.valueOf(attribute.getName()))});
            }
        } else if (type.isArray()) {
            metadataBuilder.createList().of(DFLMetadataModelHelper.toMetadataType(project, contentType, type.asArrayType().getType()));
        } else if (attributes.isEmpty()) {
            BaseTypeBuilder simpleType = BaseTypeBuilder.create((MetadataFormat)contentType);
            if (type.isAssignableFrom(DFLTypeFactory.STRING)) {
                metadataBuilder.createSimple(simpleType.stringType());
            } else if (type.isAssignableFrom(DFLTypeFactory.DATE)) {
                metadataBuilder.createSimple(simpleType.dateType());
            } else if (type.isAssignableFrom(DFLTypeFactory.BOOLEAN)) {
                metadataBuilder.createSimple(simpleType.booleanType());
            } else if (type.isAssignableFrom(DFLTypeFactory.NUMBER)) {
                metadataBuilder.createSimple(simpleType.numberType());
            } else if (type.isAssignableFrom(DFLTypeFactory.DATETIME)) {
                metadataBuilder.createSimple(simpleType.dateTimeType());
            } else {
                if (type instanceof ExtendedType) {
                    return DFLMetadataModelHelper.toMetadataType(project, contentType, ((ExtendedType)type).getExtendedType(), attributes);
                }
                metadataBuilder.createSimple(simpleType.stringType());
            }
        } else {
            IObjectBuilder dynamicObject = metadataBuilder.createObject(contentType);
            dynamicObject.addField(new QName("text()"), new CustomMetadataBuilder().createSimple(BaseTypeBuilder.create((MetadataFormat)contentType).stringType()), new TypeAnnotation[0]);
        }
        return metadataBuilder;
    }

    private static TypeAnnotation[] getMetadataProperties(IDFLField field) {
        Optional label = field.getLabel();
        if (label.isPresent()) {
            LabelAnnotation labelProperty = new LabelAnnotation((String)label.get());
            return new TypeAnnotation[]{labelProperty};
        }
        return new TypeAnnotation[0];
    }
}

