/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.action.errors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jface.text.Document;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.validation.Issue;
import org.mule.tooling.ui.dfl.contribution.editor.action.IEditorModelAware;
import org.mule.tooling.ui.dfl.contribution.editor.action.LabelUtils;
import org.mule.tooling.ui.dfl.contribution.editor.script.TransformerEditorModel;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.IMappingModel;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.ITransformationTarget;
import org.mule.tooling.ui.widgets.errors.ErrorItem;
import org.mule.tooling.ui.widgets.errors.ErrorManager;
import org.mule.tooling.ui.widgets.errors.ErrorType;
import org.mule.tooling.ui.widgets.errors.IErrorListProvider;

public class WeaveErrorListProvider
implements IErrorListProvider {
    private IMappingModel transformerModel;
    private IEditorModelAware editorModel;
    private ErrorManager<Document, Issue> errorManager;

    public WeaveErrorListProvider(IMappingModel transformerModel, IEditorModelAware editorModel, ErrorManager<Document, Issue> errorManager) {
        this.transformerModel = transformerModel;
        this.editorModel = editorModel;
        this.errorManager = errorManager;
    }

    public List<ErrorItem> getIssues() {
        ArrayList<ErrorItem> response = new ArrayList<ErrorItem>();
        List<ITransformationTarget> targets = this.transformerModel.getTargets();
        for (ITransformationTarget target : targets) {
            TransformerEditorModel editorInfo;
            XtextDocument document;
            List issues;
            Optional<TransformerEditorModel> editorInfoOptional = this.editorModel.getEditorModel(target);
            if (!editorInfoOptional.isPresent() || (issues = this.errorManager.getIssues((Object)(document = (editorInfo = editorInfoOptional.get()).getEditor().getDocument()))) == null || issues.isEmpty()) continue;
            for (Issue issue : issues) {
                String[] data = issue.getData();
                response.add(new ErrorItem.ErrorItemBuilder().withErrorType(WeaveErrorListProvider.getErrorType(issue.getSeverity())).withTitle(issue.getMessage()).withMessage(issue.getCode() == null ? this.buildLabel(target) : issue.getCode()).withDescription(data == null || data.length == 0 ? issue.getMessage() : Arrays.stream(data).collect(Collectors.joining("\n"))).build());
            }
        }
        return response;
    }

    public static ErrorType getErrorType(Severity severity) {
        if (Severity.WARNING.equals((Object)severity)) {
            return ErrorType.WARNING;
        }
        return ErrorType.ERROR;
    }

    private String buildLabel(ITransformationTarget target) {
        StringBuilder label = new StringBuilder();
        label.append(target.getLabel());
        if (!target.isPayload()) {
            LabelUtils.appendType(label, target);
        }
        return label.toString();
    }
}

