/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.action;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.ui.dfl.contribution.editor.action.SourceType;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.ITransformationTargetSource;

public class TargetUtils {
    public static void updateSourceTarget(SourceType sourceType, String selectedFileName, ITransformationTargetSource source, String content) {
        TargetUtils.updateSourceTarget(sourceType, selectedFileName, source, source, content);
    }

    public static void updateSourceTarget(SourceType sourceType, String selectedFileName, ITransformationTargetSource oldSource, ITransformationTargetSource source, String content) {
        if (sourceType.isInline()) {
            if (oldSource.isResource()) {
                source.asInline();
                TargetUtils.setSourceFileContents(source, content);
            }
        } else if (oldSource.isInline()) {
            source.asResource(TargetUtils.ensureWeaveExtension(selectedFileName));
            boolean result = TargetUtils.setSourceFileContents(source, content);
            if (!result) {
                source.asInline();
                TargetUtils.setSourceFileContents(source, content);
            }
        } else if (!source.isResource() || !source.getResource().equals(selectedFileName)) {
            source.setResource(TargetUtils.ensureWeaveExtension(selectedFileName));
            TargetUtils.setSourceFileContents(source, content);
            try {
                oldSource.getFile().delete(1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                MuleCorePlugin.logError((String)"Couldn't delete old dw script source", (Throwable)e);
            }
        }
    }

    private static String ensureWeaveExtension(String selectedFileName) {
        if (selectedFileName.endsWith(".dwl")) {
            return selectedFileName;
        }
        return selectedFileName + ".dwl";
    }

    private static boolean setSourceFileContents(ITransformationTargetSource source, String content) {
        try {
            source.getFile().setContents((InputStream)new ByteArrayInputStream(content.getBytes()), 1, (IProgressMonitor)new NullProgressMonitor());
            return true;
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

