/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.action;

import java.io.File;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.dfl.ui.utils.Messages;
import org.mule.tooling.ui.dfl.contribution.editor.action.SourceType;
import org.mule.tooling.ui.dfl.contribution.editor.action.TargetScope;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.IMappingModel;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.ITransformationTarget;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.ITransformationTargetSource;
import org.mule.tooling.ui.widgets.listener.IdleModifyEventListener;
import org.mule.tooling.utils.OsDetect;

public class TargetDefinitionDialog
extends TitleAreaDialog {
    private IMappingModel messageTransformer;
    private IMuleProject project;
    private Optional<ITransformationTarget> model;
    private TargetScope selectedScope = TargetScope.PAYLOAD;
    private String selectedVariableName = "";
    private SourceType selectedSourceType = SourceType.INLINE;
    private String selectedSourceName = "";
    private ComboViewer targetScopeCombo;
    private Label variableNameLabel;
    private Text variableNameField;
    private Button inlineRadio;
    private Button fileRadio;
    private Text fileNameTextField;
    private Button fileButton;
    private Consumer<TargetDefinitionDialog> onOk;
    private static final String SLASH = "/";

    public TargetDefinitionDialog(Shell parentShell, IMappingModel messageTransformer, IMuleProject project, Optional<ITransformationTarget> model, Consumer<TargetDefinitionDialog> onOk) {
        super(parentShell);
        this.messageTransformer = messageTransformer;
        this.project = project;
        this.model = model;
        this.onOk = onOk;
        this.setBlockOnOpen(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().applyTo(container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        Group scopeGroup = this.createScopeArea(container);
        this.createSourceArea(container);
        if (this.model.isPresent()) {
            this.loadContent(scopeGroup);
        } else {
            this.inlineRadio.setSelection(true);
            this.onInlineSelected();
        }
        return container;
    }

    private Group createScopeArea(Composite container) {
        final Group outputGroup = new Group(container, 4);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(5, 10).applyTo((Composite)outputGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)outputGroup);
        outputGroup.setText("Output");
        this.targetScopeCombo = new ComboViewer((Composite)outputGroup, 8);
        this.targetScopeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.targetScopeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof TargetScope) {
                    return ((TargetScope)((Object)element)).getLabel();
                }
                return super.getText(element);
            }
        });
        boolean includePayload = !this.messageTransformer.isPayloadTargetDeclared() || this.model.isPresent() && this.model.get().isPayload();
        boolean includeAttributes = !this.messageTransformer.isAttributesTargetDeclared() || this.model.isPresent() && !this.model.get().isPayload() && !this.model.get().isVariable();
        TargetScope[] values = this.findTargetScopes(includePayload, includeAttributes);
        this.targetScopeCombo.setInput((Object)values);
        this.targetScopeCombo.setSelection((ISelection)new StructuredSelection((Object)values[0]));
        this.variableNameLabel = new Label((Composite)outputGroup, 0);
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)this.variableNameLabel);
        this.variableNameLabel.setText("Variable name");
        this.variableNameField = new Text((Composite)outputGroup, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.variableNameField);
        this.variableNameField.setMessage("Please enter the variable name...");
        this.variableNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TargetDefinitionDialog.this.validate();
            }
        });
        boolean requiresName = this.currentTargetRequiresName();
        this.variableNameLabel.setVisible(requiresName);
        this.variableNameField.setVisible(requiresName);
        this.targetScopeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TargetDefinitionDialog.this.onChangeTargetType((Composite)outputGroup);
                TargetDefinitionDialog.this.validate();
            }
        });
        return outputGroup;
    }

    private TargetScope[] findTargetScopes(boolean includePayload, boolean includeAttributes) {
        return (TargetScope[])Arrays.stream(TargetScope.values()).filter(input -> (includePayload || !includePayload && !input.equals((Object)TargetScope.PAYLOAD)) && (includeAttributes || !includeAttributes && !input.equals((Object)TargetScope.ATTRIBUTES))).toArray(TargetScope[]::new);
    }

    private Group createSourceArea(Composite container) {
        Group sourceGroup = new Group(container, 4);
        GridLayoutFactory.fillDefaults().numColumns(4).margins(5, 10).applyTo((Composite)sourceGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)sourceGroup);
        sourceGroup.setText("Source Code");
        sourceGroup.setVisible(true);
        this.inlineRadio = new Button((Composite)sourceGroup, 16);
        GridDataFactory.swtDefaults().applyTo((Control)this.inlineRadio);
        this.inlineRadio.setText("Inline");
        this.inlineRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetDefinitionDialog.this.onInlineSelected();
                TargetDefinitionDialog.this.validate();
            }
        });
        this.fileRadio = new Button((Composite)sourceGroup, 16);
        GridDataFactory.swtDefaults().applyTo((Control)this.fileRadio);
        this.fileRadio.setText("File");
        this.fileRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetDefinitionDialog.this.onFileSelected();
                TargetDefinitionDialog.this.validate();
            }
        });
        this.fileNameTextField = new Text((Composite)sourceGroup, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.fileNameTextField);
        this.fileNameTextField.setMessage("file_name.dwl");
        this.fileNameTextField.addModifyListener((ModifyListener)new IdleModifyEventListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TargetDefinitionDialog.this.validate();
            }
        }, (Control)sourceGroup));
        this.fileButton = new Button((Composite)sourceGroup, 0x100000);
        GridDataFactory.swtDefaults().applyTo((Control)this.fileButton);
        this.fileButton.setText("...");
        this.fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
                String pathToResourceFolder = this.getPathToResourceFolder();
                dialog.setFilterExtensions(new String[]{"*.dwl"});
                dialog.setFilterPath(pathToResourceFolder);
                String result = dialog.open();
                if (StringUtils.isNotBlank((String)result)) {
                    if (!result.startsWith(pathToResourceFolder)) {
                        TargetDefinitionDialog.this.setMessage(Messages.error_not_in_classpath_question, 3);
                    } else {
                        boolean allow = true;
                        if (new File(result).exists()) {
                            allow = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)Messages.file_exist_title, (String)Messages.file_exist_question);
                        }
                        if (allow) {
                            this.saveResourcePath(result);
                        }
                    }
                }
            }

            private void saveResourcePath(String result) {
                try {
                    String abstolutePathToResourceFolder = this.getPathToResourceFolder();
                    if (result.startsWith(abstolutePathToResourceFolder)) {
                        String text = result.substring(abstolutePathToResourceFolder.length() + 1);
                        TargetDefinitionDialog.this.fileNameTextField.setText(text.replaceAll(Matcher.quoteReplacement(File.separator), TargetDefinitionDialog.SLASH));
                        return;
                    }
                    TargetDefinitionDialog.this.setMessage(Messages.error_not_in_classpath_question, 3);
                }
                catch (RuntimeException runtimeException) {
                    TargetDefinitionDialog.this.setMessage(Messages.error_not_in_classpath_question, 3);
                }
            }

            private String getPathToResourceFolder() {
                EditingScope editingScope = MuleCorePlugin.getDesignContext().getEditingScope();
                IFolder muleResourcesFolder = TargetDefinitionDialog.this.project.getMuleResourcesFolder(editingScope);
                String abstolutePathToResourceFolder = muleResourcesFolder.getLocation().toFile().toPath().toString();
                return abstolutePathToResourceFolder;
            }
        });
        return sourceGroup;
    }

    private void loadContent(Group outputGroup) {
        ITransformationTarget target = this.model.get();
        TargetScope targetScope = this.getTransformationType(target);
        this.targetScopeCombo.setSelection((ISelection)new StructuredSelection((Object)targetScope));
        if (targetScope.equals((Object)TargetScope.VARIABLES)) {
            this.variableNameField.setText(target.getVariableName());
        }
        this.onChangeTargetType((Composite)outputGroup);
        ITransformationTargetSource source = target.getSource();
        if (source.isInline()) {
            this.inlineRadio.setSelection(true);
            this.onInlineSelected();
        } else {
            this.fileRadio.setSelection(true);
            this.onFileSelected();
            this.fileNameTextField.setText(source.getFileName());
        }
    }

    private TargetScope getTransformationType(ITransformationTarget target) {
        if (target.isPayload()) {
            return TargetScope.PAYLOAD;
        }
        if (target.isVariable()) {
            return TargetScope.fromCategory(target.getCategory());
        }
        return TargetScope.ATTRIBUTES;
    }

    private void onChangeTargetType(Composite parent) {
        boolean requiresName = this.currentTargetRequiresName();
        this.variableNameLabel.setVisible(requiresName);
        this.variableNameField.setVisible(requiresName);
        parent.layout(true, true);
    }

    private boolean currentTargetRequiresName() {
        return !TargetScope.PAYLOAD.equals((Object)this.getTargetType()) && !TargetScope.ATTRIBUTES.equals((Object)this.getTargetType());
    }

    private void onFileSelected() {
        this.selectedSourceType = SourceType.FILE;
        this.fileNameTextField.setEnabled(true);
        this.fileButton.setEnabled(true);
    }

    private void onInlineSelected() {
        this.fileNameTextField.setEnabled(false);
        this.fileButton.setEnabled(false);
        this.selectedSourceType = SourceType.INLINE;
    }

    public void create() {
        super.create();
        this.setTitle("Selection dialog");
        this.setMessage("Please select your target");
    }

    protected void okPressed() {
        boolean shouldExit = this.save();
        if (shouldExit) {
            this.onOk.accept(this);
            super.okPressed();
        }
    }

    private boolean save() {
        if (this.validate()) {
            this.setSelectedScope(this.getTargetType());
            this.setSelectedVariableName(this.getVariableName());
            if (SourceType.FILE.equals((Object)this.selectedSourceType)) {
                this.setSelectedFileName(this.getSourceFileName());
            }
            return true;
        }
        return false;
    }

    private boolean validate() {
        TargetScope selectedType = this.getTargetType();
        if (!this.model.isPresent() && TargetScope.PAYLOAD.equals((Object)selectedType) && this.messageTransformer.isPayloadTargetDeclared()) {
            this.setMessage("Payload target is already defined", 3);
            return false;
        }
        String selectedName = this.getVariableName();
        if (!TargetScope.PAYLOAD.equals((Object)selectedType) && !TargetScope.ATTRIBUTES.equals((Object)selectedType) && StringUtils.isBlank((String)selectedName)) {
            this.setMessage("Variable name cannot be empty", 3);
            return false;
        }
        if (this.isSelectedTargetAlreadyDefined(selectedType, selectedName)) {
            this.setMessage("Selected target is already defined", 3);
            return false;
        }
        if (SourceType.FILE.equals((Object)this.selectedSourceType)) {
            String selectedFileName = this.fileNameTextField.getText();
            if (StringUtils.isBlank((String)selectedFileName)) {
                this.setMessage("Invalid file name", 3);
                return false;
            }
            Optional fullPath = CoreUtils.getFileFullPathFromSelectedResource((String)selectedFileName, (IMuleProject)this.project);
            if (fullPath.isPresent()) {
                String path = (String)fullPath.get();
                if (StringUtils.isBlank((String)path)) {
                    this.setMessage("Invalid file name", 3);
                    return false;
                }
                String projectPath = CoreUtils.getProjectRootFile((IMuleProject)this.project).getAbsolutePath();
                if (!path.startsWith(projectPath)) {
                    this.setMessage("File have to be part of the project", 3);
                    return false;
                }
                if (!this.model.isPresent()) {
                    this.setMessage("Selected file already exists, it will be overwritten", 2);
                } else {
                    this.setMessage("Please configure your target");
                }
                return true;
            }
        }
        this.setMessage("Please select your target");
        return true;
    }

    private boolean isSelectedTargetAlreadyDefined(TargetScope selectedType, String selectedName) {
        return this.isSelectedPayloadAlreadyDefined(selectedType) || this.isSelectedAttributeAlreadyDefined(selectedType) || this.isSelectedVariableAlreadyDefined(selectedType, selectedName);
    }

    private boolean isSelectedPayloadAlreadyDefined(TargetScope selectedType) {
        boolean targetDeclared = false;
        if (TargetScope.PAYLOAD.equals((Object)selectedType)) {
            targetDeclared = this.messageTransformer.isPayloadTargetDeclared();
            if (this.model.isPresent()) {
                targetDeclared &= !this.model.get().isPayload();
            }
        }
        return targetDeclared;
    }

    private boolean isSelectedAttributeAlreadyDefined(TargetScope selectedType) {
        boolean targetDeclared = false;
        if (TargetScope.ATTRIBUTES.equals((Object)selectedType)) {
            targetDeclared = this.messageTransformer.isAttributesTargetDeclared();
            if (this.model.isPresent()) {
                targetDeclared &= !this.model.get().isAttributes();
            }
        }
        return targetDeclared;
    }

    private boolean isSelectedVariableAlreadyDefined(TargetScope selectedType, String selectedName) {
        boolean targetDeclared = false;
        if (TargetScope.VARIABLES.equals((Object)selectedType)) {
            targetDeclared = this.messageTransformer.isTargetDeclared(selectedType.getCategory(), selectedName);
            if (this.model.isPresent()) {
                ITransformationTarget currentModel = this.model.get();
                targetDeclared &= !currentModel.isVariable() || !currentModel.getVariableName().equals(selectedName);
            }
        }
        return targetDeclared;
    }

    private String getVariableName() {
        return this.variableNameField.getText();
    }

    private String getSourceFileName() {
        return this.fileNameTextField.getText();
    }

    private TargetScope getTargetType() {
        StructuredSelection selection = (StructuredSelection)this.targetScopeCombo.getSelection();
        if (!selection.isEmpty()) {
            return (TargetScope)((Object)selection.getFirstElement());
        }
        return TargetScope.PAYLOAD;
    }

    protected Point getInitialSize() {
        if (OsDetect.getOperatingSystemType() == OsDetect.OsType.Windows) {
            return new Point(450, 500);
        }
        return new Point(450, 300);
    }

    protected boolean isResizable() {
        return true;
    }

    public void setSelectedSourceType(SourceType type) {
        this.selectedSourceType = type;
    }

    public SourceType getSelectedSourceType() {
        return this.selectedSourceType;
    }

    public void setSelectedFileName(String name) {
        this.selectedSourceName = name;
    }

    public String getSelectedFileName() {
        return this.selectedSourceName;
    }

    public TargetScope getSelectedScope() {
        return this.selectedScope;
    }

    public void setSelectedScope(TargetScope selectedType) {
        this.selectedScope = selectedType;
    }

    public String getSelectedName() {
        return this.selectedVariableName;
    }

    public void setSelectedVariableName(String selectedVariableName) {
        this.selectedVariableName = selectedVariableName;
    }
}

