/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.mule.tooling.dfl.ui.embedded.editor.DFLEmbeddedEditor;
import org.mule.tooling.dfl.ui.utils.ImagesHelper;
import org.mule.tooling.ui.dfl.contribution.editor.action.IEditorModelAware;
import org.mule.tooling.ui.dfl.contribution.editor.action.LabelUtils;
import org.mule.tooling.ui.dfl.contribution.editor.script.EditorContext;
import org.mule.tooling.ui.dfl.contribution.editor.script.event.TransformationTargetSelectedEvent;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.IMappingModel;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.ITransformationTarget;
import org.mule.tooling.ui.widgets.action.DisposableAction;
import org.mule.tooling.ui.widgets.action.DropdownAction;
import org.mule.tooling.utils.eventbus.IEvent;

public class SelectTransformTargetAction
extends DropdownAction {
    private static final int DEFAULT_LENGTH = 30;
    private Composite parent;
    private IMappingModel transformModel;
    private EditorContext context;
    private IEditorModelAware editorModel;

    public SelectTransformTargetAction(Composite parent, IMappingModel transformerModel, IEditorModelAware editorModel, EditorContext context, ITransformationTarget currentTarget) {
        super(SelectTransformTargetAction.buildLabel(currentTarget), (Control)parent);
        this.parent = parent;
        this.transformModel = transformerModel;
        this.editorModel = editorModel;
        this.context = context;
    }

    public void addAction(Action action) {
        this.getActions().add(action);
    }

    public void runWithEvent(Event event) {
        Menu oldMenu = this.getMenu();
        this.createMenu((Control)this.parent);
        this.createActions();
        ArrayList actions = this.getActions();
        for (Action action : actions) {
            ITransformationTarget actionTarget;
            MenuItem menuItem = this.createMenuItem(action, 32);
            if (!(action instanceof TargetAction) || (actionTarget = ((TargetAction)action).getTarget()) == null || !actionTarget.equals(this.editorModel.getCurrentTarget())) continue;
            menuItem.setSelection(true);
        }
        super.runWithEvent(event);
        this.deleteMenu(oldMenu);
    }

    private void createActions() {
        List<ITransformationTarget> targets = this.transformModel.getTargets();
        for (ITransformationTarget transformationTarget : targets) {
            this.addAction((Action)new TargetAction(transformationTarget, this.editorModel, this.context));
        }
    }

    public static String buildLabel(ITransformationTarget target) {
        String name = target.getLabel();
        int idLength = name.length();
        StringBuilder label = new StringBuilder();
        LabelUtils.appendType(label, target);
        if (idLength <= 30) {
            label.append(name);
        } else {
            label.append(StringUtils.abbreviate((String)name, (int)30));
        }
        return label.toString();
    }

    private void deleteMenu(Menu menu) {
        MenuItem[] items;
        if (menu == null || menu.isDisposed()) {
            return;
        }
        MenuItem[] menuItemArray = items = menu.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem menuItem = menuItemArray[n2];
            menuItem.dispose();
            ++n2;
        }
        this.getActions().clear();
        menu.dispose();
    }

    public static class TargetAction
    extends DisposableAction {
        private ITransformationTarget target;
        private IEditorModelAware editorModel;
        private EditorContext context;

        public TargetAction(ITransformationTarget target, IEditorModelAware editorModel, EditorContext context) {
            this.target = target;
            this.editorModel = editorModel;
            this.context = context;
            if (this.haveErrors()) {
                this.setImageDescriptor(ImagesHelper.getImageDescriptor((String)"icons/error.png"));
            }
            this.setText(LabelUtils.setActionLabel(target));
            this.setChecked(true);
        }

        private boolean haveErrors() {
            Optional<DFLEmbeddedEditor> editor = this.editorModel.getEditor(this.target);
            if (editor.isPresent()) {
                return editor.get().haveErrors();
            }
            return false;
        }

        public void run() {
            this.notifyTargetSelected();
        }

        private void notifyTargetSelected() {
            this.context.getEventBus().fireEvent((IEvent)new TransformationTargetSelectedEvent(this.target));
        }

        public ITransformationTarget getTarget() {
            return this.target;
        }

        public void setTarget(ITransformationTarget target) {
            this.target = target;
        }
    }
}

