/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.action;

import java.util.Optional;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.datasense.MetadataHelper;
import org.mule.tooling.dfl.ui.utils.ImagesHelper;
import org.mule.tooling.dfl.ui.utils.Messages;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.ui.dfl.contribution.editor.script.EditorContext;
import org.mule.tooling.ui.dfl.contribution.editor.script.event.ITransformationTargetAdded;
import org.mule.tooling.ui.dfl.contribution.editor.script.event.ITransformationTargetRemoved;
import org.mule.tooling.ui.dfl.contribution.editor.script.event.MessageTransformerEventTypes;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.IMappingModel;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.ITransformationTarget;
import org.mule.tooling.ui.modules.core.metadata.definition.MessageRowType;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataResult;
import org.mule.tooling.ui.widgets.action.DisposableAction;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class RemoveTargetAction
extends DisposableAction {
    private IMappingModel messageTransformer;
    private ITransformationTarget currentTarget;
    private EditorContext context;
    private Composite parent;
    private EventBusHelper helper;

    public RemoveTargetAction(Composite parent, IMappingModel messageTransformer, EditorContext context, ITransformationTarget currentTarget) {
        super("Remove current target", ImagesHelper.getImageDescriptor((String)"icons/remove_target.png"));
        this.parent = parent;
        this.context = context;
        this.currentTarget = currentTarget;
        this.messageTransformer = messageTransformer;
        this.helper = new EventBusHelper();
        this.updateState();
        this.addListeners();
    }

    private void addListeners() {
        this.helper.registerListener(this.context.getEventBus(), MessageTransformerEventTypes.ON_TRANSFORMATION_ADDED, (IEventHandler)new ITransformationTargetAdded(){

            @Override
            public void onTransformationTargetAdded(ITransformationTarget target) {
                RemoveTargetAction.this.updateState();
            }
        });
        this.helper.registerListener(this.context.getEventBus(), MessageTransformerEventTypes.ON_TRANSFORMATION_REMOVED, (IEventHandler)new ITransformationTargetRemoved(){

            @Override
            public void onTransformationTargetRemoved(ITransformationTarget target) {
                RemoveTargetAction.this.updateState();
            }
        });
        this.helper.unregisterWith((Widget)this.parent);
    }

    private void updateState() {
        this.setEnabled(this.messageTransformer.getTargets().size() > 1);
    }

    private void clearCustomMetadata() {
        MetadataHelper.getCurrentOutputMessageRowType((String)this.currentTarget.getCategory()).ifPresent(messageRowType -> {
            Optional<Object> variableName = Optional.ofNullable(this.currentTarget.isVariable() ? this.currentTarget.getVariableName() : null);
            MetadataHelper.updateMetadata((MessageRowType)messageRowType, (IMessageFlowNode)this.messageTransformer.getNode(), (IMuleProject)this.context.getProject(), variableName, (MetadataResult)MetadataResult.createEmpty());
        });
    }

    public void run() {
        boolean sure = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.remove_target_title, (String)Messages.remove_target_question);
        if (sure) {
            this.clearCustomMetadata();
            this.messageTransformer.removeTransformationTarget(this.currentTarget);
        }
    }
}

