/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.action;

import java.util.Optional;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.dfl.ui.embedded.editor.DFLEmbeddedEditor;
import org.mule.tooling.dfl.ui.utils.ImagesHelper;
import org.mule.tooling.ui.dfl.contribution.editor.action.IEditorModelAware;
import org.mule.tooling.ui.dfl.contribution.editor.action.TargetDefinitionDialog;
import org.mule.tooling.ui.dfl.contribution.editor.action.TargetScope;
import org.mule.tooling.ui.dfl.contribution.editor.action.TargetUtils;
import org.mule.tooling.ui.dfl.contribution.editor.script.EditorContext;
import org.mule.tooling.ui.dfl.contribution.editor.script.event.TransformationTargetModifiedEvent;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.IMappingModel;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.ITransformationTarget;
import org.mule.tooling.ui.widgets.action.DisposableAction;
import org.mule.tooling.utils.eventbus.IEvent;

public final class EditTargetAction
extends DisposableAction {
    private IMappingModel transformModel;
    private IEditorModelAware editorModel;
    private ITransformationTarget currentTransformationTarget;
    private EditorContext context;

    public EditTargetAction(IMappingModel transformModel, EditorContext context, IEditorModelAware editorModel, ITransformationTarget currentTarget) {
        super("Edit current target", ImagesHelper.getImageDescriptor((String)"icons/edit_target.png"));
        this.transformModel = transformModel;
        this.context = context;
        this.editorModel = editorModel;
        this.currentTransformationTarget = currentTarget;
    }

    public void run() {
        new TargetDefinitionDialog(this.getShell(), this.transformModel, this.context.getProject(), Optional.of(this.currentTransformationTarget), dialog -> {
            DFLEmbeddedEditor currentEditor = this.editorModel.getCurrentEditor();
            XtextDocument document = currentEditor.getDocument();
            String script = document.get();
            TargetScope selectedType = dialog.getSelectedScope();
            String selectedName = dialog.getSelectedName();
            this.currentTransformationTarget = this.transformModel.replaceTransformationTarget(this.currentTransformationTarget, selectedType, selectedName, MetadataFactory.undefined());
            this.editorModel.getCurrentEditor().getDocument().set(script);
            TargetUtils.updateSourceTarget(dialog.getSelectedSourceType(), dialog.getSelectedFileName(), this.currentTransformationTarget.getSource(), script);
            currentEditor.getDocument().set(script);
            this.notifyTargetChanged();
        }).open();
    }

    private void notifyTargetChanged() {
        this.context.getEventBus().fireEvent((IEvent)new TransformationTargetModifiedEvent(this.currentTransformationTarget));
    }

    private Shell getShell() {
        return Display.getCurrent().getActiveShell();
    }
}

