/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.action;

import java.util.Optional;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.utils.ImagesHelper;
import org.mule.tooling.ui.dfl.contribution.editor.action.TargetDefinitionDialog;
import org.mule.tooling.ui.dfl.contribution.editor.action.TargetUtils;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.IMappingModel;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.ITransformationTarget;
import org.mule.tooling.ui.widgets.action.DisposableAction;

public class CreateTargetAction
extends DisposableAction {
    private IMappingModel messageTransformer;
    private IMuleProject project;

    public CreateTargetAction(IMappingModel messageTransformer, IMuleProject project) {
        super("Add new target", ImagesHelper.getImageDescriptor((String)"icons/add_target.png"));
        this.messageTransformer = messageTransformer;
        this.project = project;
    }

    public void run() {
        Optional<ITransformationTarget> model = Optional.empty();
        new TargetDefinitionDialog(this.getShell(), this.messageTransformer, this.project, model, dialog -> {
            ITransformationTarget target = this.messageTransformer.createTransformationTarget(dialog.getSelectedScope(), dialog.getSelectedName(), MetadataFactory.undefined());
            TargetUtils.updateSourceTarget(dialog.getSelectedSourceType(), dialog.getSelectedFileName(), target.getSource(), "");
        }).open();
    }

    private Shell getShell() {
        return Display.getCurrent().getActiveShell();
    }
}

