/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.editor.action;

import java.util.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.TreeItem;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.dfl.ui.graphical.util.TreeViewerHelper;
import org.mule.tooling.dfl.ui.utils.GraphicalTreeNodeUtils;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.TwoWayHandler;
import org.mule.tooling.ui.modules.core.metadata.definition.MessageRowType;
import org.mule.tooling.ui.widgets.tree.model.GraphicalTreeNode;

public abstract class AbstractOutputMetadataAction
extends Action {
    protected TreeViewer treeViewer;
    protected TwoWayHandler twoWayHandler;

    public AbstractOutputMetadataAction(String id, TwoWayHandler twoWayHandler, TreeViewer treeViewer) {
        super(id);
        this.twoWayHandler = twoWayHandler;
        this.treeViewer = treeViewer;
    }

    public AbstractOutputMetadataAction(TwoWayHandler twoWayHandler, TreeViewer treeViewer) {
        this("Set Metadata", twoWayHandler, treeViewer);
    }

    public boolean isEnabled() {
        TreeItem[] selection = this.treeViewer.getTree().getSelection();
        Optional nodeOpt = TreeViewerHelper.getSelectedNode((ISelectionProvider)this.treeViewer);
        return nodeOpt.map(node -> !GraphicalTreeNodeUtils.isUnresolvedMetadataNodeId((GraphicalTreeNode)node) && this.isEnabledFor(selection, (GraphicalTreeNode)nodeOpt.get())).orElse(false);
    }

    protected abstract boolean isEnabledFor(TreeItem[] var1, GraphicalTreeNode<?> var2);

    protected void refreshHeaderScript(MetadataType metadataType) {
    }

    protected abstract MessageRowType getMessageRowType();
}

