/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.customeditor;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.client.metadata.enricher.InputParameterEnricher;
import org.mule.tooling.client.metadata.enricher.MetadataEnricher;
import org.mule.tooling.client.metadata.enricher.MetadataTypeRef;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.datasense.MetadataHelper;
import org.mule.tooling.model.messageflow.ComponentId;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.ui.dfl.contribution.customeditor.SingleTransformationTarget;
import org.mule.tooling.ui.dfl.contribution.editor.action.TargetScope;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.IMappingModel;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.ITransformationTarget;
import org.mule.tooling.ui.modules.core.metadata.IPropagationInfoProvider;
import org.mule.tooling.ui.modules.core.metadata.definition.MessageRowType;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataResult;

public class SingleTargetMappingModel
implements IMappingModel {
    private IMuleProject muleProject;
    private IMessageFlowNode node;
    private SingleTransformationTarget target;
    private String propertyName;

    public SingleTargetMappingModel(IMuleProject muleProject, IMessageFlowNode node, String content, String propertyName) {
        this.muleProject = muleProject;
        this.node = node;
        this.propertyName = propertyName;
        this.target = new SingleTransformationTarget(muleProject, content, propertyName);
    }

    @Override
    public IMuleProject getMuleProject() {
        return this.muleProject;
    }

    @Override
    public IMessageFlowNode getNode() {
        return this.node;
    }

    @Override
    public List<ITransformationTarget> getTargets() {
        return Arrays.asList(this.target);
    }

    @Override
    public ITransformationTarget newPayloadTransformation(MetadataType payloadType) {
        throw new RuntimeException("newPayloadTransformation is not supported");
    }

    @Override
    public void removeTransformationTarget(ITransformationTarget target) {
        throw new RuntimeException("removeTransformationTarget is not supported");
    }

    @Override
    public boolean isPayloadTargetDeclared() {
        return true;
    }

    @Override
    public boolean isAttributesTargetDeclared() {
        return false;
    }

    @Override
    public boolean isTargetDeclared(String category, String name) {
        return false;
    }

    @Override
    public ITransformationTarget replaceTransformationTarget(ITransformationTarget target, TargetScope selectedType, String selectedName, MetadataType model) {
        throw new RuntimeException("replaceTransformationTarget is not supported");
    }

    @Override
    public ITransformationTarget createTransformationTarget(TargetScope selectedType, String selectedName, MetadataType model) {
        throw new RuntimeException("createTransformationTarget is not supported");
    }

    @Override
    public boolean supportsMultipleTargets() {
        return false;
    }

    @Override
    public boolean supportsUpdateOutputHeader() {
        return false;
    }

    @Override
    public void setOuputMetadata(MessageRowType rowType, Optional<String> variableName, MetadataResult result, IPropagationInfoProvider provider) {
        MetadataTypeRef typeRef = MetadataTypeRef.builder().withKey(result.getKey()).withModule(result.getModule()).withCollection(result.isCollection()).build();
        ComponentId componentId = ComponentId.getOrCreate((IMessageFlowNode)this.getNode());
        ITypesManager typesManager = MetadataHelper.getTypesManager((IMuleProject)this.getMuleProject());
        MetadataEnricher metadataEnricher = typesManager.getEnricher(componentId).orElse(new MetadataEnricher(componentId));
        List inputs = metadataEnricher.getOrCreateOperationEnricher().getInputs();
        Optional<InputParameterEnricher> findFirst = inputs.stream().filter(inputParam -> inputParam.getName().equals(this.propertyName)).findFirst();
        if (findFirst.isPresent()) {
            findFirst.get().setTypeRef(typeRef);
        } else {
            inputs.add(new InputParameterEnricher(this.propertyName, typeRef));
        }
        typesManager.enrich(metadataEnricher);
        typesManager.persist();
        provider.reloadComponentDataSense();
    }

    @Override
    public void clearOutputMetadata(MessageRowType rowType, Optional<String> variableName, IPropagationInfoProvider provider) {
        ComponentId componentId = ComponentId.getOrCreate((IMessageFlowNode)this.getNode());
        ITypesManager typesManager = MetadataHelper.getTypesManager((IMuleProject)this.getMuleProject());
        Optional maybeEnricher = typesManager.getEnricher(componentId);
        maybeEnricher.ifPresent(metadataEnricher -> {
            List inputs = metadataEnricher.getOrCreateOperationEnricher().getInputs();
            OptionalInt findFirst = IntStream.range(0, inputs.size()).filter(index -> ((InputParameterEnricher)inputs.get(index)).getName().equals(this.propertyName)).findFirst();
            if (findFirst.isPresent()) {
                inputs.remove(findFirst.getAsInt());
            }
            typesManager.enrich(metadataEnricher);
            typesManager.persist();
            provider.reloadComponentDataSense();
        });
    }
}

