/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.customeditor;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.actions.ActionFactory;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.input.IMetaDataProvider;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.properties.views.IPropertiesViewDialog;
import org.mule.tooling.ui.dfl.contribution.customeditor.SingleTargetMappingModel;
import org.mule.tooling.ui.dfl.contribution.editor.graphical.TwoWayHandler;
import org.mule.tooling.ui.dfl.contribution.editor.script.DataWeaveEditor;
import org.mule.tooling.ui.dfl.contribution.editor.script.EditorContext;
import org.mule.tooling.ui.dfl.contribution.editor.script.UndoRedoListener;
import org.mule.tooling.ui.dfl.contribution.editor.script.model.IMappingModel;
import org.mule.tooling.ui.modules.core.metadata.IPropagationInfoProvider;
import org.mule.tooling.utils.eventbus.EventBus;

public class SingleTargetMappingEditor
implements IPropertiesViewDialog {
    private DataWeaveEditor editor;
    private IMappingModel messageTransformer;
    private EditorContext editorContext;
    private String title;

    public SingleTargetMappingEditor(String title, IMappingModel messageTransformer, EditorContext editorContext) {
        this.title = title;
        this.messageTransformer = messageTransformer;
        this.editorContext = editorContext;
    }

    public String getScriptContent() {
        return this.editor.getEditors().values().iterator().next().getEditor().getDocument().get();
    }

    public Control create(Composite parent, ToolBarManager toolbarManager, final IPropertiesViewDialog.ITitleManager titleManager) {
        titleManager.setTitle(this.title);
        this.editor = new DataWeaveEditor(parent, this.messageTransformer, this.editorContext);
        this.editor.setLayoutToolbar(toolbarManager);
        this.editor.setTargetToolBar(toolbarManager);
        this.editor.openEditor(this.messageTransformer.getTargets().get(0));
        this.editor.refresh();
        this.editor.refreshMetadataTrees();
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IAction)this.editor.getUndoAction());
        toolbarManager.add((IAction)this.editor.getRedoAction());
        IContributionItem undoItem = null;
        IContributionItem redoItem = null;
        IContributionItem[] iContributionItemArray = toolbarManager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem iContributionItem = iContributionItemArray[n2];
            if (ActionFactory.UNDO.getId().equals(iContributionItem.getId())) {
                undoItem = iContributionItem;
            } else if (ActionFactory.REDO.getId().equals(iContributionItem.getId())) {
                redoItem = iContributionItem;
            }
            ++n2;
        }
        if (undoItem != null && redoItem != null) {
            this.editor.getCurrentEditor().getDocument().addDocumentListener((IDocumentListener)new UndoRedoListener(undoItem, redoItem));
        }
        this.editor.getCurrentEditor().getDocument().addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                if (SingleTargetMappingEditor.this.editor.getCurrentEditor().getViewer().getUndoManager().undoable()) {
                    titleManager.setModified();
                } else {
                    titleManager.setUnModified();
                }
            }
        });
        return this.editor;
    }

    public void onOpen() {
        TwoWayHandler twoWayHandler = this.editor.getCurrentTwoWayHandler();
        twoWayHandler.refresh();
    }

    public void doClose() {
        this.editor.doClose(false);
        this.editor.dispose();
    }

    public static SingleTargetMappingEditor create(String title, String initialScript, IMessageFlowNode node, IMuleProject muleProject, MuleConfiguration muleConfiguration, IPropagationInfoProvider propagationInfoProvider, IMetaDataProvider inputMetadata, IMetaDataProvider outputMetadata, String propertyName, EventBus eventBus) {
        EditorContext editorContext = new EditorContext(muleProject, muleConfiguration, node, eventBus, propagationInfoProvider, inputMetadata, outputMetadata);
        return new SingleTargetMappingEditor(title, new SingleTargetMappingModel(muleProject, node, initialScript, propertyName), editorContext);
    }
}

