/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.customeditor;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.metadata.MetadataEvent;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.dfl.ui.input.IMetaDataProvider;
import org.mule.tooling.ui.dfl.contribution.editor.script.event.OutputMetadataUpdatedEvent;
import org.mule.tooling.ui.modules.core.metadata.IComponentDataSenseInfoProvider;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEvent;

class PayloadOnlyMetadataProvider
implements IMetaDataProvider {
    private EventBus eventBus;
    private MetadataType metadataType;
    private IComponentDataSenseInfoProvider componentDataSenseProvider;
    private String canonicalPath;
    private boolean allowRetyping;

    public PayloadOnlyMetadataProvider(IComponentDataSenseInfoProvider componentDataSenseProvider, MetadataType defaultMetadataType, EventBus eventBus, String canonicalPath) {
        this.eventBus = eventBus;
        this.metadataType = defaultMetadataType;
        this.componentDataSenseProvider = componentDataSenseProvider;
        this.canonicalPath = canonicalPath;
        componentDataSenseProvider.thenAccept(componentDataSenseResult -> {
            Map metadataTypes = componentDataSenseResult.getMetadataTypes();
            MetadataType expectedMetadataType = (MetadataType)metadataTypes.get(canonicalPath);
            this.updateMetadata(expectedMetadataType);
            this.allowRetyping = componentDataSenseResult.isAllowRetyping();
        });
    }

    private void updateMetadata(MetadataType result) {
        if (result != null) {
            this.metadataType = result;
            this.eventBus.fireEvent((IEvent)new OutputMetadataUpdatedEvent());
        }
    }

    public MetadataEvent getMetadata() {
        this.componentDataSenseProvider.thenAccept(componentDataSenseResult -> {
            Map metadataTypes = componentDataSenseResult.getMetadataTypes();
            MetadataType expectedMetadataType = (MetadataType)metadataTypes.get(this.canonicalPath);
            if (expectedMetadataType != null) {
                this.metadataType = expectedMetadataType;
                this.allowRetyping = componentDataSenseResult.isAllowRetyping();
            }
        });
        return MetadataFactory.newEventWithPayload((MetadataType)this.metadataType);
    }

    public Optional<MetadataType> getModel(String variableName) {
        return Optional.empty();
    }

    public Map<String, MetadataType> getGlobalBindings() {
        return Collections.emptyMap();
    }

    public Map<String, MetadataType> getFunctionBindings() {
        return Collections.emptyMap();
    }

    public boolean isMetadataAvailable() {
        return this.componentDataSenseProvider.isComponentDataSenseAvailable();
    }

    public boolean allowRetyping() {
        return this.allowRetyping;
    }
}

