/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution.customeditor;

import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.validation.Issue;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.event.LayoutPropertiesEditorRequest;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.ui.datasense.DefaultDataSenseProvider;
import org.mule.tooling.dfl.ui.datasense.DwMetadataProvider;
import org.mule.tooling.dfl.ui.datasense.IDataSenseProvider;
import org.mule.tooling.dfl.ui.datasense.UndefinedDataSenseProvider;
import org.mule.tooling.dfl.ui.embedded.editor.DFLEmbeddedEditor;
import org.mule.tooling.dfl.ui.input.DefaultMetaDataProvider;
import org.mule.tooling.dfl.ui.input.IMetaDataProvider;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.properties.views.IPropertiesViewDialog;
import org.mule.tooling.properties.views.MulePropertiesView;
import org.mule.tooling.ui.dfl.contribution.DflPlugin;
import org.mule.tooling.ui.dfl.contribution.customeditor.PayloadOnlyMetadataProvider;
import org.mule.tooling.ui.dfl.contribution.customeditor.SingleTargetMappingEditor;
import org.mule.tooling.ui.dfl.contribution.editor.script.DFLEditorHelper;
import org.mule.tooling.ui.modules.core.ModulesActivator;
import org.mule.tooling.ui.modules.core.metadata.DataSenseInfoProvider;
import org.mule.tooling.ui.modules.core.metadata.IComponentDataSenseInfoProvider;
import org.mule.tooling.ui.modules.core.metadata.IPropagationInfoProvider;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.IFieldEditorContextProvider;
import org.mule.tooling.ui.modules.core.widgets.utils.AttributeHelperUtils;
import org.mule.tooling.ui.widgets.errors.ErrorManager;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.ui.widgets.util.WidgetUtils;
import org.mule.tooling.utils.UtilsPlugin;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.utils.script.ScriptUtils;

public class DataWeaveExpressionEditor {
    private static final int TEXT_EDITOR_WIDTH_MIN = 1;
    private DFLEmbeddedEditor scriptEditor;
    private boolean oneLiner;
    private Composite xtextEditorContainer;
    private Text prefixTextWidget;
    private Text suffixTextWidget;

    public DataWeaveExpressionEditor(boolean oneLiner) {
        this.oneLiner = oneLiner;
    }

    public Control createControl(Composite parent, IFieldEditorContextProvider provider) {
        MulePropertiesView mulePropertiesView;
        Optional maybeComponentDataSenseInfoProvider;
        Composite scriptEditorContainer;
        Composite editorWrapper;
        AnyType defaultOutput = new BaseTypeBuilder(MetadataFactory.ANY_METADATA_FORMAT).anyType().id(provider.getAttributeHelper().getCaption()).build();
        Optional<IDataSenseProvider> maybeDataSenseProvider = MulePropertiesView.getViewIfPresent().flatMap(MulePropertiesView::getDataSenseInfoProvider).map(arg_0 -> DataWeaveExpressionEditor.lambda$1((MetadataType)defaultOutput, provider, arg_0));
        IDataSenseProvider dataSenseProvider = maybeDataSenseProvider.orElseGet(UndefinedDataSenseProvider::new);
        ToolBarManager toolBarManager = null;
        if (this.oneLiner) {
            editorWrapper = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(2).applyTo(editorWrapper);
            scriptEditorContainer = new Composite(editorWrapper, 2048);
            GridLayoutFactory.fillDefaults().numColumns(3).spacing(0, 0).margins(0, 0).applyTo(scriptEditorContainer);
            scriptEditorContainer.setBackground(Display.getDefault().getSystemColor(1));
            this.prefixTextWidget = this.createTextModifier(scriptEditorContainer, "#[", true);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)scriptEditorContainer);
        } else {
            editorWrapper = new Composite(parent, 2048);
            GridLayoutFactory.fillDefaults().numColumns(3).applyTo(editorWrapper);
            scriptEditorContainer = editorWrapper;
        }
        DFLEditorHelper.DFLEditorConfiguration dflEditorConfiguration = new DFLEditorHelper.DFLEditorConfiguration();
        dflEditorConfiguration.oneLiner(this.oneLiner);
        dflEditorConfiguration.withShowMarker(!this.oneLiner);
        this.xtextEditorContainer = new Composite(scriptEditorContainer, 0);
        this.xtextEditorContainer.setLayout((Layout)new FillLayout());
        int height = this.oneLiner ? -1 : WidgetUtils.getLinesHeightInPixels((Control)this.xtextEditorContainer, (int)this.getEditorsLineHeight());
        GridDataFactory.fillDefaults().grab(true, !this.oneLiner).hint(-1, height).applyTo((Control)this.xtextEditorContainer);
        ErrorManager errorManager = new ErrorManager();
        errorManager.addListener((ErrorManager.ErrorManagerListener)new CustomErrorManagerListener((ErrorManager<Document, Issue>)errorManager, provider));
        this.scriptEditor = DFLEditorHelper.createEditor(this.xtextEditorContainer, "", dataSenseProvider, (ErrorManager<Document, Issue>)errorManager, provider.getAttributeContext().getProject(), provider.getEventBus(), dflEditorConfiguration);
        WidgetUtils.addUndoAndRedoCapability((TextViewer)this.scriptEditor.getViewer(), (IUndoManager)this.scriptEditor.getViewer().getUndoManager());
        if (this.oneLiner) {
            this.scriptEditor.getViewer().getTextWidget().addVerifyListener((VerifyListener)new OneLinerPasteActionListener());
            this.scriptEditor.getViewer().getControl().addFocusListener((FocusListener)new OneLinerFocusListener());
            this.xtextEditorContainer.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    DataWeaveExpressionEditor.this.focusOnTextEditor(false);
                }
            });
            this.xtextEditorContainer.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    DataWeaveExpressionEditor.this.focusOnTextEditor(false);
                }
            });
            this.suffixTextWidget = this.createTextModifier(scriptEditorContainer, "]", false);
        }
        String parameterName = Optional.ofNullable(provider.getAttributeHelper().getCanonicalPath()).map(cannonicalPath -> {
            String[] pathElements = cannonicalPath.split("/");
            return pathElements[pathElements.length - 1];
        }).orElse(provider.getAttributeHelper().getId());
        Optional viewIfPresent = MulePropertiesView.getViewIfPresent();
        if (viewIfPresent.isPresent() && provider.shouldShowVisualMapper(parameterName) && (maybeComponentDataSenseInfoProvider = (mulePropertiesView = (MulePropertiesView)viewIfPresent.get()).getDataSenseInfoProvider()).isPresent()) {
            ToolBar toolBar = new ToolBar(editorWrapper, this.oneLiner ? 2048 : 131072);
            toolBarManager = new ToolBarManager(toolBar);
            GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)toolBar);
            toolBarManager.add((IAction)new ShowVisualMapperAction(provider, parameterName, maybeComponentDataSenseInfoProvider, (MetadataType)defaultOutput));
            toolBarManager.update(true);
        }
        return editorWrapper;
    }

    public String getValue() {
        String content = this.getContent();
        return !StringUtils.isEmpty((CharSequence)content) ? "#[" + content.trim() + "]" : "";
    }

    public void setValue(String value) {
        if (this.oneLiner) {
            boolean isSingleLineScript = ScriptUtils.isSingleLineScript((String)value);
            int height = WidgetUtils.getLinesHeightInPixels((Control)this.scriptEditor.getViewer().getControl(), (int)(isSingleLineScript ? 1 : 2));
            GridDataFactory.fillDefaults().grab(true, false).hint(1, height).applyTo((Control)this.xtextEditorContainer);
            if (isSingleLineScript) {
                GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)this.prefixTextWidget);
                GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)this.suffixTextWidget);
            } else {
                GridDataFactory.fillDefaults().grab(false, true).align(4, 1).applyTo((Control)this.prefixTextWidget);
                GridDataFactory.fillDefaults().grab(false, true).align(4, 0x1000008).applyTo((Control)this.suffixTextWidget);
            }
        }
        String scriptContent = ScriptUtils.getScriptContentOrText((String)value);
        IDocument document = this.scriptEditor.getViewer().getDocument();
        document.set(scriptContent);
    }

    private String getContent() {
        IDocument document = this.scriptEditor.getViewer().getDocument();
        return document.get();
    }

    private Text createTextModifier(Composite container, String text, final boolean prefix) {
        Text textWidget = new Text(container, 0);
        textWidget.setEditable(false);
        textWidget.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DataWeaveExpressionEditor.this.focusOnTextEditor(prefix);
            }
        });
        textWidget.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                DataWeaveExpressionEditor.this.focusOnTextEditor(prefix);
            }
        });
        textWidget.setText(text);
        return textWidget;
    }

    public Control getEventControl() {
        return this.xtextEditorContainer;
    }

    private int getEditorsLineHeight() {
        IPreferenceStore prefStore = ModulesActivator.getDefault().getPreferenceStore();
        return prefStore.getInt("text.field.editor.lines.height");
    }

    private void focusOnTextEditor(boolean start) {
        XtextSourceViewer xtextSourceViewer = this.scriptEditor.getViewer();
        Control control = xtextSourceViewer.getControl();
        if (!control.isFocusControl()) {
            control.forceFocus();
            xtextSourceViewer.setSelectedRange(start ? 0 : xtextSourceViewer.getDocument().getLength(), 0);
        }
    }

    private static /* synthetic */ IDataSenseProvider lambda$1(MetadataType metadataType, IFieldEditorContextProvider iFieldEditorContextProvider, DataSenseInfoProvider propagationInfoProvider) {
        MulePropertiesView mulePropertiesView = MulePropertiesView.get();
        MessageFlowEntity messageFlowEntity = mulePropertiesView.getCurrentMessageFlowEntity().orElseGet(() -> null);
        IMuleProject muleProject = mulePropertiesView.getMuleProject();
        DwMetadataProvider inputMetadata = DwMetadataProvider.createInputMetaDataProvider((IMuleProject)muleProject, (IMessageFlowEntity)messageFlowEntity, (IPropagationInfoProvider)propagationInfoProvider);
        Optional maybeComponentDataSenseInfoProvider = mulePropertiesView.getDataSenseInfoProvider();
        Optional<IMetaDataProvider> maybeExpectedMetadata = maybeComponentDataSenseInfoProvider.map(componentDataSenseProvider -> new PayloadOnlyMetadataProvider((IComponentDataSenseInfoProvider)componentDataSenseProvider, metadataType, iFieldEditorContextProvider.getEventBus(), iFieldEditorContextProvider.getAttributeHelper().getCanonicalPath()));
        IMetaDataProvider expectedOutput = maybeExpectedMetadata.orElseGet(() -> new DefaultMetaDataProvider(MetadataFactory.newEventWithPayload((MetadataType)metadataType)));
        return new DefaultDataSenseProvider((IMetaDataProvider)inputMetadata, expectedOutput);
    }

    private class CustomErrorManagerListener
    implements ErrorManager.ErrorManagerListener {
        private IFieldEditorContextProvider provider;
        private ErrorManager<Document, Issue> errorManager;

        public CustomErrorManagerListener(ErrorManager<Document, Issue> errorManager, IFieldEditorContextProvider provider) {
            this.errorManager = errorManager;
            this.provider = provider;
        }

        public void onManagerModifier() {
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                if (!this.provider.isDisposed()) {
                    this.provider.setError(null);
                    List issues = this.errorManager.getIssues((Object)DataWeaveExpressionEditor.this.scriptEditor.getDocument());
                    if (issues != null) {
                        for (Issue issue : issues) {
                            this.provider.setError(issue.getMessage());
                        }
                    }
                    this.provider.validateParent();
                    this.provider.validate();
                }
            });
        }
    }

    private final class OneLinerFocusListener
    extends FocusAdapter {
        private OneLinerFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            XtextSourceViewer viewer = DataWeaveExpressionEditor.this.scriptEditor.getViewer();
            IDocument document = viewer.getDocument();
            String script = document.get();
            if (!ScriptUtils.isSingleLineScript((String)script)) {
                int height = WidgetUtils.getLinesHeightInPixels((Control)viewer.getControl(), (int)DataWeaveExpressionEditor.this.getEditorsLineHeight());
                GridDataFactory.fillDefaults().grab(true, false).hint(-1, height).applyTo((Control)DataWeaveExpressionEditor.this.xtextEditorContainer);
                UtilsPlugin.getEventBus().fireEvent((IEvent)new LayoutPropertiesEditorRequest());
            }
        }

        public void focusLost(FocusEvent e) {
            XtextSourceViewer viewer = DataWeaveExpressionEditor.this.scriptEditor.getViewer();
            IDocument document = viewer.getDocument();
            String script = document.get();
            GridData layout = (GridData)DataWeaveExpressionEditor.this.xtextEditorContainer.getLayoutData();
            int currentHeight = layout.heightHint;
            int newHeight = WidgetUtils.getLinesHeightInPixels((Control)DataWeaveExpressionEditor.this.scriptEditor.getViewer().getControl(), (int)(ScriptUtils.isSingleLineScript((String)script) ? 1 : 2));
            if (currentHeight != newHeight && currentHeight != -1) {
                GridDataFactory.fillDefaults().grab(true, false).hint(-1, newHeight).applyTo((Control)DataWeaveExpressionEditor.this.xtextEditorContainer);
                UtilsPlugin.getEventBus().fireEvent((IEvent)new LayoutPropertiesEditorRequest());
            }
        }
    }

    private final class OneLinerPasteActionListener
    implements VerifyListener {
        private OneLinerPasteActionListener() {
        }

        public void verifyText(VerifyEvent event) {
            event.text = ScriptUtils.getScriptContentOrText((String)event.text);
            String pasted = event.text;
            if (pasted.length() > 1 && !ScriptUtils.isSingleLineScript((String)pasted)) {
                XtextSourceViewer viewer = DataWeaveExpressionEditor.this.scriptEditor.getViewer();
                int height = WidgetUtils.getLinesHeightInPixels((Control)viewer.getControl(), (int)DataWeaveExpressionEditor.this.getEditorsLineHeight());
                GridDataFactory.fillDefaults().grab(true, false).hint(-1, height).applyTo((Control)DataWeaveExpressionEditor.this.xtextEditorContainer);
                UtilsPlugin.getEventBus().fireEvent((IEvent)new LayoutPropertiesEditorRequest());
            }
        }
    }

    private class ShowVisualMapperAction
    extends Action {
        private final IFieldEditorContextProvider context;
        private final Optional<? extends IComponentDataSenseInfoProvider> maybeComponentDataSenseInfoProvider;
        private String parameterName;
        private MetadataType defaultOutput;

        private ShowVisualMapperAction(IFieldEditorContextProvider context, String parameterName, Optional<? extends IComponentDataSenseInfoProvider> maybeComponentDataSenseInfoProvider, MetadataType defaultOutput) {
            super("", DflPlugin.getDefault().getImages().getImageDescriptor(ThemeUtils.getCurrentTheme().getDflImgFolder() + "editor/graphical-mapper.png"));
            this.parameterName = parameterName;
            this.defaultOutput = defaultOutput;
            this.setToolTipText("Show Graphical View");
            this.context = context;
            this.maybeComponentDataSenseInfoProvider = maybeComponentDataSenseInfoProvider;
        }

        public void run() {
            AnalyticsRecordsFactory.single((String)Events.DW_EXPRESSION_VIEW).track();
            IMessageFlowNode node = this.context.getAttributesPropertyPage().getMessageFlowNode();
            IMuleProject muleProject = this.context.getAttributeContext().getProject();
            MuleConfiguration muleConfiguration = this.context.getAttributeContext().getMuleConfiguration();
            MulePropertiesView mulePropertiesView = MulePropertiesView.get();
            DataSenseInfoProvider propagationInfoProvider = (DataSenseInfoProvider)mulePropertiesView.getDataSenseInfoProvider().get();
            DwMetadataProvider inputMetadata = DwMetadataProvider.createInputMetaDataProvider((IMuleProject)muleProject, (IMessageFlowEntity)node, (IPropagationInfoProvider)propagationInfoProvider);
            EventBus eventBus = MuleCorePlugin.getEventBus();
            IComponentDataSenseInfoProvider componentDataSenseInfoProvider = this.maybeComponentDataSenseInfoProvider.get();
            PayloadOnlyMetadataProvider expectedType = new PayloadOnlyMetadataProvider(componentDataSenseInfoProvider, this.defaultOutput, eventBus, this.context.getAttributeHelper().getCanonicalPath());
            SingleTargetMappingEditor dialog = SingleTargetMappingEditor.create(this.getTitle(this.context), DataWeaveExpressionEditor.this.getContent(), node, muleProject, muleConfiguration, (IPropagationInfoProvider)propagationInfoProvider, (IMetaDataProvider)inputMetadata, expectedType, this.parameterName, eventBus);
            mulePropertiesView.showDialog((IPropertiesViewDialog)dialog, singleEditorDialog -> DataWeaveExpressionEditor.this.setValue(singleEditorDialog.getScriptContent()));
        }

        public String getTitle(IFieldEditorContextProvider context) {
            AttributeHelper attributeHelper = context.getAttributeHelper();
            AttributesPropertyPage attributesPropertyPage = context.getAttributesPropertyPage();
            return AttributeHelperUtils.getTitle((AttributeHelper)attributeHelper, (AttributesPropertyPage)attributesPropertyPage);
        }
    }
}

