/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ToolBar;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.ui.dfl.contribution.DflPlugin;
import org.mule.tooling.ui.dfl.contribution.editor.script.ToogleActionType;
import org.mule.tooling.ui.dfl.contribution.editor.script.ToogleControlManager;
import org.mule.tooling.ui.widgets.action.DisposableToolbarManager;

class ModeFieldEditor
extends FieldEditor {
    private static final ToogleActionType DEFAULT_MODE = ToogleActionType.MAPPING_VIEW;
    private ToogleActionType selectedType;
    List<SelectToogleAction> actions;

    ModeFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.getSelectedType().toString());
    }

    protected void doLoadDefault() {
        this.setSelectedType(DEFAULT_MODE);
        this.refresh();
    }

    protected void doLoad() {
        String selectedTypeString = this.getPreferenceStore().getString(this.getPreferenceName());
        this.setSelectedType(StringUtils.isNotBlank((String)selectedTypeString) ? ToogleActionType.valueOf(selectedTypeString) : DEFAULT_MODE);
        this.refresh();
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Composite wrapper = new Composite(parent, 4);
        GridDataFactory.fillDefaults().span(numColumns, 1).applyTo((Control)wrapper);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(wrapper);
        Label label = new Label(wrapper, 0);
        label.setText(this.getLabelText());
        ToolBar layoutItemsToolbar = new ToolBar(wrapper, 8519936);
        GridLayoutFactory.fillDefaults().applyTo((Composite)layoutItemsToolbar);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)layoutItemsToolbar);
        ToolBarManager layoutManager = new ToolBarManager(layoutItemsToolbar);
        DisposableToolbarManager layoutToolbarManager = new DisposableToolbarManager((IToolBarManager)layoutManager);
        this.actions = new ArrayList<SelectToogleAction>();
        SelectToogleAction showFullMapping = new SelectToogleAction(DEFAULT_MODE, this);
        layoutToolbarManager.add((IAction)showFullMapping);
        this.actions.add(showFullMapping);
        SelectToogleAction hideMappings = new SelectToogleAction(ToogleActionType.TWO_PANE_VIEW, this);
        layoutToolbarManager.add((IAction)hideMappings);
        this.actions.add(hideMappings);
        SelectToogleAction showOnlyCode = new SelectToogleAction(ToogleActionType.SOURCE_VIEW, this);
        ActionContributionItem item = new ActionContributionItem((IAction)showOnlyCode);
        layoutToolbarManager.add((IContributionItem)item);
        this.actions.add(showOnlyCode);
        new ToogleControlManager(wrapper, showOnlyCode, hideMappings, showFullMapping);
        layoutItemsToolbar.update();
        layoutManager.update(true);
    }

    private void refresh() {
        for (SelectToogleAction toogle : this.actions) {
            if (!toogle.getType().equals((Object)this.getSelectedType())) continue;
            toogle.setChecked(true);
            break;
        }
    }

    protected void adjustForNumColumns(int numColumns) {
    }

    public ToogleActionType getSelectedType() {
        return this.selectedType;
    }

    public void setSelectedType(ToogleActionType selectedType) {
        this.selectedType = selectedType;
    }

    public class SelectToogleAction
    extends Action {
        private ToogleActionType type;
        private ModeFieldEditor modeFieldEditor;

        public SelectToogleAction(ToogleActionType type, ModeFieldEditor modeFieldEditor2) {
            super("", 2);
            this.type = type;
            this.modeFieldEditor = modeFieldEditor2;
            this.setToolTipText(type.getTooltip());
            this.setImageDescriptor(DflPlugin.getDefault().getImages().getImageDescriptor(type.getImage()));
        }

        public void run() {
            AnalyticsRecordsFactory.single((String)(this.type.getAnalyticsEvent() + "_DEFAULT")).track();
            this.modeFieldEditor.setSelectedType(this.type);
        }

        public ToogleActionType getType() {
            return this.type;
        }
    }
}

