/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.mule.tooling.dfl.ui.DFLExtendedActivator;
import org.mule.tooling.ui.dfl.contribution.editor.script.ToogleActionType;
import org.mule.tooling.ui.widgets.image.PluginImageRegistry;
import org.osgi.framework.BundleContext;

public class DflPlugin
extends AbstractUIPlugin {
    private static BundleContext context;
    private static DflPlugin plugin;
    public static final String SOURCE_VIEW = "editor/source-view.png";
    public static final String TWO_PANE_VIEW = "editor/twopane-view.png";
    public static final String MAPPING_VIEW = "editor/mapping-view.png";
    public static final String GRAPHICAL_MAPPING = "editor/graphical-mapper.png";

    static BundleContext getContext() {
        return context;
    }

    public static DflPlugin getDefault() {
        return plugin;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        plugin = this;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
        plugin = null;
    }

    public PluginImageRegistry getImages() {
        return new PluginImageRegistry(this.getBundle());
    }

    private static IPreferenceStore getDWPreferenceStore() {
        return DFLExtendedActivator.getInstance().getPreferenceStore();
    }

    public static ToogleActionType getDefaultToogleMode() {
        IPreferenceStore preferenceStore = DflPlugin.getDWPreferenceStore();
        String selectedMode = preferenceStore.getString("dataweave.defaultMode");
        if (StringUtils.isNotBlank((String)selectedMode)) {
            return ToogleActionType.valueOf(selectedMode);
        }
        return ToogleActionType.MAPPING_VIEW;
    }

    public static Boolean reopenInLastEditorMode() {
        IPreferenceStore preferenceStore = DflPlugin.getDWPreferenceStore();
        return preferenceStore.getBoolean("dataweave.defaultMode.lastOpen");
    }

    public static Boolean hideInputOnSourceOnlyView() {
        IPreferenceStore preferenceStore = DflPlugin.getDWPreferenceStore();
        return preferenceStore.getBoolean("dataweave.hide_input_on_source_only_view");
    }

    public static void setDefaultToogleMode(ToogleActionType actionType) {
        IPreferenceStore preferenceStore = DflPlugin.getDWPreferenceStore();
        preferenceStore.setValue("dataweave.defaultMode", actionType.name());
    }
}

