/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.dfl.contribution;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.dfl.ui.DFLExtendedActivator;
import org.mule.tooling.messageflow.editpart.EntityDeleteEditPolicy;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.editpart.IEntityEditPartRequestHandler;
import org.mule.tooling.messageflow.editpart.PatternEditPart;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IPropertyCollectionReadCapability;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.ui.preferences.MuleStudioPreferencePage;

public class DFLEditPartRequestHandler
implements IEntityEditPartRequestHandler {
    public static final String DW_NAMESPACE = "http://www.mulesoft.org/schema/mule/ee/dw";

    public boolean handlesRequestFor(EntityEditPart<?> editPart) {
        return editPart instanceof PatternEditPart && ((PatternNode)((PatternEditPart)editPart).getEntity()).getType().equals("http://www.mulesoft.org/schema/mule/ee/core/transform");
    }

    public boolean handleReadAccessRequest(EntityEditPart<?> editPart, Request request) {
        return false;
    }

    public boolean handleWriteAccessRequest(EntityEditPart<?> editPart, Request request, CompoundCommand command) {
        PatternEditPart patternEditPart = (PatternEditPart)editPart;
        if (request.getType().equals("delete")) {
            new EntityDeleteEditPolicy().addDeleteCommandTo(editPart, command);
            PatternNode entity = (PatternNode)patternEditPart.getEntity();
            command.add((Command)new DeleteMappingsCommand((IMessageFlowNode)entity));
            return true;
        }
        return false;
    }

    private final class DeleteMappingsCommand
    extends Command {
        private final IMessageFlowNode entity;

        private DeleteMappingsCommand(IMessageFlowNode entity) {
            this.entity = entity;
        }

        public void execute() {
            boolean thereAreNoFilesToDelete;
            IMuleProject project = MuleCorePlugin.getDesignContext().getMuleProject();
            List<Optional<IFile>> mappings = this.getMappings(this.entity, project, "http://www.mulesoft.org/schema/mule/ee/core/set-payload", "http://www.mulesoft.org/schema/mule/ee/core/set-variable", "http://www.mulesoft.org/schema/mule/ee/core/set-attributes");
            List inputSamples = Collections.emptyList();
            ArrayList<Optional<Object>> toDelete = new ArrayList<Optional<Object>>();
            toDelete.addAll(mappings);
            toDelete.addAll(inputSamples);
            Iterable presentInstances = toDelete.stream().filter(Optional::isPresent).map(maybeFile -> (IFile)maybeFile.get()).collect(Collectors.toList());
            boolean bl = thereAreNoFilesToDelete = !presentInstances.iterator().hasNext();
            if (thereAreNoFilesToDelete || !this.shouldDelete()) {
                return;
            }
            for (IFile resource : presentInstances) {
                this.deleteQuietly(resource);
            }
        }

        private boolean shouldDelete() {
            IPreferenceStore preferenceStore = DFLExtendedActivator.getInstance().getPreferenceStore();
            MuleStudioPreferencePage.ActionDialogState deleteAssociatedValue = MuleStudioPreferencePage.ActionDialogState.fromPreference((IPreferenceStore)preferenceStore, (String)"dataweave.delete_associated_mapping");
            boolean doDelete = false;
            if (deleteAssociatedValue.prompt()) {
                MessageDialogWithToggle openWarning = MessageDialogWithToggle.openYesNoQuestion((Shell)Display.getCurrent().getActiveShell(), (String)"Delete associated mapping", (String)"Do you want to delete the associated files? ", (String)"Do not show this message again?", (boolean)false, null, null);
                boolean bl = doDelete = openWarning.getReturnCode() == 2;
                if (openWarning.getToggleState()) {
                    preferenceStore.setValue("dataweave.delete_associated_mapping", doDelete ? MuleStudioPreferencePage.ActionDialogState.ALWAYS.name() : MuleStudioPreferencePage.ActionDialogState.NEVER.name());
                } else {
                    preferenceStore.setValue("dataweave.delete_associated_mapping", MuleStudioPreferencePage.ActionDialogState.PROMPT.name());
                }
            } else {
                doDelete = deleteAssociatedValue == MuleStudioPreferencePage.ActionDialogState.ALWAYS;
            }
            return doDelete;
        }

        private List<Optional<IFile>> getMappings(IMessageFlowNode entity, IMuleProject project, String ... nestedElementIds) {
            ArrayList resources = Lists.newArrayList();
            List<String> attributeValues = this.getAttributeValues("resource", entity, nestedElementIds);
            for (String resourceStr : attributeValues) {
                Optional resource = CoreUtils.getResource((String)resourceStr, (IMuleProject)project);
                resources.add(resource);
            }
            return resources;
        }

        private List<String> getAttributeValues(String attributeName, IMessageFlowNode entity, String ... nestedElementIds) {
            ArrayList attrValues = Lists.newArrayList();
            List propCols = PropertiesUtils.getNestedElementProperties((IMessageFlowNode)entity, (String[])nestedElementIds);
            for (IReadOnlyPropertyCollection propertyCollection : propCols) {
                String resourceStr = PropertiesUtils.getPropertyValue((IPropertyCollectionReadCapability)propertyCollection, (String)attributeName);
                if (!StringUtils.isNotBlank((String)resourceStr)) continue;
                attrValues.add(resourceStr);
            }
            return attrValues;
        }

        private void deleteQuietly(IFile file) {
            try {
                file.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                MuleCorePlugin.logError((String)("Error whle trying to delete file: " + file.getName()), (Throwable)e);
            }
        }
    }
}

