/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.core.textplain;

import java.io.OutputStream;
import java.io.Serializable;
import org.mule.weave.v2.core.exception.WriterExecutionException;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.BufferedCharSequence;
import org.mule.weave.v2.model.types.NullType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.ConfigurableReaderWriter;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.module.core.textplain.TextPlainDataFormat;
import org.mule.weave.v2.module.core.textplain.TextPlainWriter$;
import org.mule.weave.v2.module.core.textplain.TextPlainWriterSettings;
import org.mule.weave.v2.module.writer.BufferedIOWriter;
import org.mule.weave.v2.module.writer.BufferedIOWriter$;
import org.mule.weave.v2.module.writer.TargetProvider;
import org.mule.weave.v2.module.writer.Writer;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.LocationCapable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001\u0002\t\u0012\u0001\u0001B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\tm\u0001\u0011)\u0019!C\u0001o!AA\b\u0001B\u0001B\u0003%\u0001\b\u0003\u0005>\u0001\t\u0005\t\u0015a\u0003?\u0011\u0015!\u0005\u0001\"\u0001F\u0011!Q\u0003\u0001#b\u0001\n\u0013Y\u0005\"B(\u0001\t\u0003\u0002\u0006\"B)\u0001\t#\u0012\u0006\"\u00027\u0001\t\u0003j\u0007\"\u00028\u0001\t\u0003j\u0007\"B8\u0001\t\u0003\u0002xAB@\u0012\u0011\u0003\t\tA\u0002\u0004\u0011#!\u0005\u00111\u0001\u0005\u0007\t6!\t!!\u0002\t\u000f\u0005\u001dQ\u0002\"\u0001\u0002\n\tyA+\u001a=u!2\f\u0017N\\,sSR,'O\u0003\u0002\u0013'\u0005IA/\u001a=ua2\f\u0017N\u001c\u0006\u0003)U\tAaY8sK*\u0011acF\u0001\u0007[>$W\u000f\\3\u000b\u0005aI\u0012A\u0001<3\u0015\tQ2$A\u0003xK\u00064XM\u0003\u0002\u001d;\u0005!Q.\u001e7f\u0015\u0005q\u0012aA8sO\u000e\u00011c\u0001\u0001\"OA\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t1\u0011I\\=SK\u001a\u0004\"\u0001K\u0016\u000e\u0003%R!AK\u000b\u0002\r]\u0014\u0018\u000e^3s\u0013\ta\u0013F\u0001\u0004Xe&$XM]\u0001\u0003_N\u0004\"a\f\u001b\u000e\u0003AR!!\r\u001a\u0002\u0005%|'\"A\u001a\u0002\t)\fg/Y\u0005\u0003kA\u0012AbT;uaV$8\u000b\u001e:fC6\f\u0001b]3ui&twm]\u000b\u0002qA\u0011\u0011HO\u0007\u0002#%\u00111(\u0005\u0002\u0018)\u0016DH\u000f\u00157bS:<&/\u001b;feN+G\u000f^5oON\f\u0011b]3ui&twm\u001d\u0011\u0002\u0007\r$\b\u0010\u0005\u0002@\u00056\t\u0001I\u0003\u0002B/\u0005)Qn\u001c3fY&\u00111\t\u0011\u0002\u0012\u000bZ\fG.^1uS>t7i\u001c8uKb$\u0018A\u0002\u001fj]&$h\bF\u0002G\u0013*#\"a\u0012%\u0011\u0005e\u0002\u0001\"B\u001f\u0006\u0001\bq\u0004\"B\u0017\u0006\u0001\u0004q\u0003\"\u0002\u001c\u0006\u0001\u0004AT#\u0001'\u0011\u0005!j\u0015B\u0001(*\u0005A\u0011UO\u001a4fe\u0016$\u0017jT,sSR,'/\u0001\u0004sKN,H\u000e^\u000b\u0002]\u0005aAm\\,sSR,g+\u00197vKR\u00111\u000b\u0017\u000b\u0003)^\u0003\"AI+\n\u0005Y\u001b#\u0001B+oSRDQ!\u0010\u0005A\u0004yBQ!\u0017\u0005A\u0002i\u000b\u0011A\u001e\u0019\u00037\u000e\u00042\u0001X0b\u001b\u0005i&B\u00010A\u0003\u00191\u0018\r\\;fg&\u0011\u0001-\u0018\u0002\u0006-\u0006dW/\u001a\t\u0003E\u000ed\u0001\u0001B\u0005e1\u0006\u0005\t\u0011!B\u0001K\n\u0019q\fJ\u0019\u0012\u0005\u0019L\u0007C\u0001\u0012h\u0013\tA7EA\u0004O_RD\u0017N\\4\u0011\u0005\tR\u0017BA6$\u0005\r\te._\u0001\u0006G2|7/\u001a\u000b\u0002)\u0006)a\r\\;tQ\u0006QA-\u0019;b\r>\u0014X.\u0019;\u0016\u0003E\u00042A\t:u\u0013\t\u00198E\u0001\u0004PaRLwN\u001c\u0019\u0004kjl\b\u0003\u0002<xsrl\u0011!F\u0005\u0003qV\u0011!\u0002R1uC\u001a{'/\\1u!\t\u0011'\u0010B\u0005|\u0017\u0005\u0005\t\u0011!B\u0001K\n\u0019q\f\n\u001a\u0011\u0005\tlH!\u0003@\f\u0003\u0003\u0005\tQ!\u0001f\u0005\ryFeM\u0001\u0010)\u0016DH\u000f\u00157bS:<&/\u001b;feB\u0011\u0011(D\n\u0003\u001b\u0005\"\"!!\u0001\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u0005-\u0011qBA\r)\r9\u0015Q\u0002\u0005\u0006{=\u0001\u001dA\u0010\u0005\b\u0003#y\u0001\u0019AA\n\u0003\t!\b\u000fE\u0002)\u0003+I1!a\u0006*\u00059!\u0016M]4fiB\u0013xN^5eKJDQAN\bA\u0002a\u0002")
public class TextPlainWriter
implements Writer {
    private BufferedIOWriter writer;
    private final OutputStream os;
    private final TextPlainWriterSettings settings;
    private EvaluationContext ctx;
    private volatile boolean bitmap$0;

    public static TextPlainWriter apply(TargetProvider targetProvider, TextPlainWriterSettings textPlainWriterSettings, EvaluationContext evaluationContext) {
        return TextPlainWriter$.MODULE$.apply(targetProvider, textPlainWriterSettings, evaluationContext);
    }

    public boolean supportsStreaming() {
        return Writer.supportsStreaming$((Writer)this);
    }

    public void startDocument(LocationCapable location) {
        Writer.startDocument$((Writer)this, (LocationCapable)location);
    }

    public void defineNamespace(LocationCapable location, String prefix, String uri) {
        Writer.defineNamespace$((Writer)this, (LocationCapable)location, (String)prefix, (String)uri);
    }

    public final void writeValue(Value<?> value, EvaluationContext ctx) {
        Writer.writeValue$((Writer)this, value, (EvaluationContext)ctx);
    }

    public String getName() {
        return Writer.getName$((Writer)this);
    }

    public final void endDocument(LocationCapable location) {
        Writer.endDocument$((Writer)this, (LocationCapable)location);
    }

    public void doEndDocument(LocationCapable location) {
        Writer.doEndDocument$((Writer)this, (LocationCapable)location);
    }

    public void setOption(Location location, String optionName, Object value, EvaluationContext ctx) {
        ConfigurableReaderWriter.setOption$((ConfigurableReaderWriter)this, (Location)location, (String)optionName, (Object)value, (EvaluationContext)ctx);
    }

    public TextPlainWriterSettings settings() {
        return this.settings;
    }

    private BufferedIOWriter writer$lzycompute() {
        TextPlainWriter textPlainWriter = this;
        synchronized (textPlainWriter) {
            if (!this.bitmap$0) {
                this.writer = BufferedIOWriter$.MODULE$.apply(this.os, this.settings().charset(this.ctx), this.settings().bufferSize());
                this.bitmap$0 = true;
            }
        }
        this.ctx = null;
        return this.writer;
    }

    private BufferedIOWriter writer() {
        if (!this.bitmap$0) {
            return this.writer$lzycompute();
        }
        return this.writer;
    }

    public OutputStream result() {
        return this.os;
    }

    public void doWriteValue(Value<?> v, EvaluationContext ctx) {
        Value<?> value = v;
        if (NullType$.MODULE$.accepts(v, ctx)) {
            return;
        }
        Try str = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (CharSequence)StringType$.MODULE$.withSchema(v.schema(ctx)).coerce(v, ctx).evaluate(ctx));
        Try try_ = str;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            throw new WriterExecutionException(v.location(), this.getName(), new StringBuilder(47).append("Text plain writer is unable to write ").append(v.valueType(ctx)).append(".\nReason:\n").append(exception.getMessage()).toString());
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            CharSequence value2 = (CharSequence)success.value();
            CharSequence charSequence = value2;
            if (charSequence instanceof String) {
                String string = (String)charSequence;
                this.writer().write(string);
            } else if (charSequence instanceof BufferedCharSequence) {
                BufferedCharSequence bufferedCharSequence = (BufferedCharSequence)charSequence;
                bufferedCharSequence.foreach((Function1 & Serializable & scala.Serializable)chars -> {
                    TextPlainWriter.$anonfun$doWriteValue$2(this, chars);
                    return BoxedUnit.UNIT;
                });
            } else {
                this.writer().write(((Object)value2).toString());
            }
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public void close() {
        this.writer().close();
    }

    public void flush() {
        this.writer().flush();
    }

    public Option<DataFormat<?, ?>> dataFormat() {
        return new Some((Object)new TextPlainDataFormat());
    }

    public static final /* synthetic */ void $anonfun$doWriteValue$2(TextPlainWriter $this, String chars) {
        $this.writer().write(chars);
    }

    public TextPlainWriter(OutputStream os, TextPlainWriterSettings settings, EvaluationContext ctx) {
        this.os = os;
        this.settings = settings;
        this.ctx = ctx;
        ConfigurableReaderWriter.$init$((ConfigurableReaderWriter)this);
        Writer.$init$((Writer)this);
    }
}

