/*
 * Decompiled with CFR 0.152.
 */
package com.github.snksoft.crc;

public class CRC {
    private Parameters crcParams;
    private long initValue;
    private long[] crctable;
    private long mask;

    private static long reflect(long in, int count) {
        long ret = in;
        for (int idx = 0; idx < count; ++idx) {
            long srcbit = 1L << idx;
            long dstbit = 1L << count - idx - 1;
            if ((in & srcbit) != 0L) {
                ret |= dstbit;
                continue;
            }
            ret &= dstbit ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return ret;
    }

    public static long calculateCRC(Parameters crcParams, byte[] data) {
        return CRC.calculateCRC(crcParams, data, 0, data.length);
    }

    public static long calculateCRC(Parameters crcParams, byte[] data, int offset, int length) {
        long curValue = crcParams.init;
        long topBit = 1L << crcParams.width - 1;
        long mask = (topBit << 1) - 1L;
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            long curByte = (long)data[i] & 0xFFL;
            if (crcParams.reflectIn) {
                curByte = CRC.reflect(curByte, 8);
            }
            for (int j = 128; j != 0; j >>= 1) {
                long bit = curValue & topBit;
                curValue <<= 1;
                if ((curByte & (long)j) != 0L) {
                    bit ^= topBit;
                }
                if (bit == 0L) continue;
                curValue ^= crcParams.polynomial;
            }
        }
        if (crcParams.reflectOut) {
            curValue = CRC.reflect(curValue, crcParams.width);
        }
        return (curValue ^= crcParams.finalXor) & mask;
    }

    public long init() {
        return this.initValue;
    }

    public long update(long curValue, byte[] chunk, int offset, int length) {
        if (this.crcParams.reflectIn) {
            for (int i = 0; i < length; ++i) {
                byte v = chunk[offset + i];
                curValue = this.crctable[((byte)curValue ^ v) & 0xFF] ^ curValue >>> 8;
            }
        } else if (this.crcParams.width < 8) {
            for (int i = 0; i < length; ++i) {
                byte v = chunk[offset + i];
                curValue = this.crctable[((byte)(curValue << 8 - this.crcParams.width) ^ v) & 0xFF] ^ curValue << 8;
            }
        } else {
            for (int i = 0; i < length; ++i) {
                byte v = chunk[offset + i];
                curValue = this.crctable[((byte)(curValue >>> this.crcParams.width - 8) ^ v) & 0xFF] ^ curValue << 8;
            }
        }
        return curValue;
    }

    public long update(long curValue, byte[] chunk) {
        return this.update(curValue, chunk, 0, chunk.length);
    }

    public long finalCRC(long curValue) {
        long ret = curValue;
        if (this.crcParams.reflectOut != this.crcParams.reflectIn) {
            ret = CRC.reflect(ret, this.crcParams.width);
        }
        return (ret ^ this.crcParams.finalXor) & this.mask;
    }

    public long calculateCRC(byte[] data) {
        return this.calculateCRC(data, 0, data.length);
    }

    public long calculateCRC(byte[] data, int offset, int length) {
        long crc = this.init();
        crc = this.update(crc, data, offset, length);
        return this.finalCRC(crc);
    }

    public CRC(Parameters crcParams) {
        this.crcParams = new Parameters(crcParams);
        this.initValue = crcParams.reflectIn ? CRC.reflect(crcParams.init, crcParams.width) : crcParams.init;
        this.mask = (crcParams.width >= 64 ? 0L : 1L << crcParams.width) - 1L;
        this.crctable = new long[256];
        byte[] tmp = new byte[1];
        Parameters tableParams = new Parameters(crcParams);
        tableParams.init = 0L;
        tableParams.reflectOut = tableParams.reflectIn;
        tableParams.finalXor = 0L;
        for (int i = 0; i < 256; ++i) {
            tmp[0] = (byte)i;
            this.crctable[i] = CRC.calculateCRC(tableParams, tmp);
        }
    }

    public byte finalCRC8(long curValue) {
        if (this.crcParams.width != 8) {
            throw new RuntimeException("CRC width mismatch");
        }
        return (byte)this.finalCRC(curValue);
    }

    public short finalCRC16(long curValue) {
        if (this.crcParams.width != 16) {
            throw new RuntimeException("CRC width mismatch");
        }
        return (short)this.finalCRC(curValue);
    }

    public int finalCRC32(long curValue) {
        if (this.crcParams.width != 32) {
            throw new RuntimeException("CRC width mismatch");
        }
        return (int)this.finalCRC(curValue);
    }

    public static class Parameters {
        private int width;
        private long polynomial;
        private boolean reflectIn;
        private boolean reflectOut;
        private long init;
        private long finalXor;
        public static final Parameters CCITT = new Parameters(16, 4129L, 65535L, false, false, 0L);
        public static final Parameters CRC16 = new Parameters(16, 32773L, 0L, true, true, 0L);
        public static final Parameters XMODEM = new Parameters(16, 4129L, 0L, false, false, 0L);
        public static final Parameters XMODEM2 = new Parameters(16, 33800L, 0L, true, true, 0L);
        public static final Parameters CRC32;
        public static final Parameters IEEE;
        public static final Parameters Castagnoli;
        public static final Parameters CRC32C;
        public static final Parameters Koopman;
        public static final Parameters CRC64ISO;
        public static final Parameters CRC64ECMA;

        public Parameters(int width, long polynomial, long init, boolean reflectIn, boolean reflectOut, long finalXor) {
            this.width = width;
            this.polynomial = polynomial;
            this.reflectIn = reflectIn;
            this.reflectOut = reflectOut;
            this.init = init;
            this.finalXor = finalXor;
        }

        public Parameters(Parameters orig) {
            this.width = orig.width;
            this.polynomial = orig.polynomial;
            this.reflectIn = orig.reflectIn;
            this.reflectOut = orig.reflectOut;
            this.init = orig.init;
            this.finalXor = orig.finalXor;
        }

        public int getWidth() {
            return this.width;
        }

        public long getPolynomial() {
            return this.polynomial;
        }

        public boolean isReflectIn() {
            return this.reflectIn;
        }

        public boolean isReflectOut() {
            return this.reflectOut;
        }

        public long getInit() {
            return this.init;
        }

        public long getFinalXor() {
            return this.finalXor;
        }

        static {
            IEEE = CRC32 = new Parameters(32, 79764919L, 0xFFFFFFFFL, true, true, 0xFFFFFFFFL);
            CRC32C = Castagnoli = new Parameters(32, 517762881L, 0xFFFFFFFFL, true, true, 0xFFFFFFFFL);
            Koopman = new Parameters(32, 1947962583L, 0xFFFFFFFFL, true, true, 0xFFFFFFFFL);
            CRC64ISO = new Parameters(64, 27L, -1L, true, true, -1L);
            CRC64ECMA = new Parameters(64, 4823603603198064275L, -1L, true, true, -1L);
        }
    }
}

