/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.radiogroup;

import org.eclipse.nebula.widgets.radiogroup.RadioItem;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public class RadioGroup
extends Composite {
    private final int cardinality;
    private final int buttonStyle;
    private RadioItem[] items = new RadioItem[0];
    private RadioItem selection = null;

    public RadioGroup(Composite parent, int style) {
        super(parent, RadioGroup.checkCompositeStyle(style));
        this.cardinality = this.checkCardinality(style);
        this.buttonStyle = RadioGroup.checkButtonStyle(style);
        super.setLayout((Layout)new RowLayout(this.cardinality));
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                RadioGroup.this.handleDispose(event);
            }
        });
    }

    private static int checkCompositeStyle(int style) {
        int result = style & 0x800;
        if ((style & 0x2000000) != 0) {
            result |= 0x2000000;
        } else if ((style & 0x4000000) != 0) {
            result |= 0x4000000;
        }
        return result;
    }

    private int checkCardinality(int style) {
        if ((style & 0x200) != 0) {
            return 512;
        }
        return 256;
    }

    private static int checkButtonStyle(int style) {
        int result = 0;
        if ((style & 0x800000) != 0) {
            result |= 0x800000;
        }
        result = (style & 0x4000) != 0 ? (result |= 0x4000) : ((style & 0x1000000) != 0 ? (result |= 0x1000000) : ((style & 0x20000) != 0 ? (result |= 0x20000) : (result |= 0x4000)));
        return result;
    }

    private void handleDispose(Event event) {
        RadioItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
    }

    public int getStyle() {
        return super.getStyle() | this.buttonStyle | this.cardinality;
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void clear(int position) {
        this.checkWidget();
        this.checkExistingPosition(position);
        this.items[position].clear();
    }

    private void checkExistingPosition(int position) {
        if (position < 0 || position >= this.getItemCount()) {
            SWT.error((int)5);
        }
    }

    public void remove(RadioItem item) {
        this.checkWidget();
        if (item.isDisposed() || item.getParent() != this) {
            SWT.error((int)5);
        }
        item.dispose();
    }

    public void remove(int position) {
        this.checkWidget();
        this.checkExistingPosition(position);
        this.items[position].dispose();
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if (start < 0 || end >= this.items.length) {
            SWT.error((int)6);
        }
        this.setLayoutDeferred(true);
        try {
            Item[] items = (Item[])this.items.clone();
            int i = start;
            while (i <= end) {
                items[i].dispose();
                ++i;
            }
        }
        finally {
            this.setLayoutDeferred(false);
        }
    }

    public void removeAll() {
        this.checkWidget();
        this.remove(0, this.items.length - 1);
    }

    public int getItemCount() {
        this.checkWidget();
        if (this.items == null) {
            return 0;
        }
        return this.items.length;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    public RadioItem[] getItems() {
        this.checkWidget();
        if (this.items == null) {
            return new RadioItem[0];
        }
        RadioItem[] result = new RadioItem[this.items.length];
        System.arraycopy(this.items, 0, result, 0, this.items.length);
        return result;
    }

    public int indexOf(RadioItem item) {
        this.checkWidget();
        if (this.items == null) {
            return -1;
        }
        if (item == null) {
            return -1;
        }
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public RadioItem getSelection() {
        this.checkWidget();
        return this.selection;
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return this.indexOf(this.selection);
    }

    public void setSelection(RadioItem item) {
        this.checkWidget();
        if (this.selection == item) {
            return;
        }
        if (this.selection != null) {
            this.selection.deselect();
        }
        if (item != null) {
            if (item.getParent() != this) {
                SWT.error((int)5);
            }
            item.select();
        }
    }

    public void select(int index) {
        this.checkWidget();
        this.checkExistingPosition(index);
        this.setSelection(this.items[index]);
    }

    public void deselectAll() {
        this.checkWidget();
        this.setSelection(null);
    }

    Button createButton(int itemStyle, int position) {
        position = this.checkAddPosition(position);
        Button button = new Button((Composite)this, this.computeButtonStyle(itemStyle));
        if (position < this.items.length) {
            button.moveAbove((Control)this.items[position].getButton());
        }
        this.layout(new Control[]{button});
        return button;
    }

    private int computeButtonStyle(int itemStyle) {
        int buttonStyle = 0x10 | this.buttonStyle;
        int itemStyleMask = 16924672;
        if ((itemStyle & itemStyleMask) != 0) {
            buttonStyle &= ~itemStyleMask;
            buttonStyle |= itemStyle;
        }
        return buttonStyle;
    }

    void addItem(RadioItem item, int position) {
        position = this.checkAddPosition(position);
        RadioItem[] newItems = new RadioItem[this.items == null ? 1 : this.items.length + 1];
        if (this.items == null) {
            this.items = new RadioItem[]{item};
        } else {
            System.arraycopy(this.items, 0, newItems, 0, position);
            newItems[position] = item;
            System.arraycopy(this.items, position, newItems, position + 1, this.items.length - position);
            this.items = newItems;
        }
    }

    private int checkAddPosition(int position) {
        if (position == -1) {
            position = this.getItemCount();
        } else if (position < 0 || position > this.getItemCount()) {
            SWT.error((int)5);
        }
        return position;
    }

    void removeItem(RadioItem item) {
        this.checkWidget();
        int position = this.indexOf(item);
        if (position != -1) {
            RadioItem[] newItems = new RadioItem[this.items.length - 1];
            System.arraycopy(this.items, 0, newItems, 0, position);
            System.arraycopy(this.items, position + 1, newItems, position, newItems.length - position);
            this.items = newItems;
        }
        if (this.selection == item) {
            this.selection = null;
        }
    }

    void itemSelected(RadioItem item) {
        RadioItem newSelection;
        RadioItem oldSelection = this.selection;
        RadioItem radioItem = newSelection = item.isSelected() ? item : null;
        if (oldSelection == newSelection) {
            return;
        }
        this.selection = newSelection;
        Event event = new Event();
        event.item = this.selection;
        event.index = this.indexOf(this.selection);
        this.notifyListeners(13, event);
    }
}

