/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.ide.ui;

import com.onpositive.ide.ui.TypeCompletionProposal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jdt.internal.core.search.JavaSearchScope;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;

public abstract class TypePackageCompletionProcessor
implements IContentAssistProcessor {
    private String fErrorMessage;
    private final SearchEngine fSearchEngine = new SearchEngine();
    private Comparator fComparator;

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    protected void generateTypePackageProposals(String currentContent, IProject project, Collection c, int startOffset, int typeScope) {
        this.generateTypePackageProposals(currentContent, project, c, startOffset, typeScope, false);
    }

    protected void generateTypePackageProposals(String currentContent, IProject project, Collection c, int startOffset, int typeScope, boolean replaceEntireContents) {
        currentContent = this.removeLeadingSpaces(currentContent);
        if (c == null || currentContent.length() == 0) {
            return;
        }
        int length = replaceEntireContents ? -1 : currentContent.length();
        this.generateProposals(currentContent, project, c, startOffset, length, typeScope);
    }

    private void generateProposals(String currentContent, IProject project, Collection c, int startOffset, int length, int typeScope) {
        try {
            ICompilationUnit unit = this.getWorkingCopy(project);
            if (unit == null) {
                this.generateTypeProposals(currentContent, project, c, startOffset, length, 1);
                return;
            }
            IBuffer buff = unit.getBuffer();
            buff.setContents("class Dummy2 { " + currentContent);
            class TypePackageCompletionRequestor
            extends CompletionRequestor {
                private final /* synthetic */ Collection val$c;
                private final /* synthetic */ int val$startOffset;
                private final /* synthetic */ int val$length;
                private final /* synthetic */ int val$typeScope;
                private final /* synthetic */ IProject val$project;

                public TypePackageCompletionRequestor(Collection collection, int n, int n2, int n3, IProject iProject) {
                    this.val$c = collection;
                    this.val$startOffset = n;
                    this.val$length = n2;
                    this.val$typeScope = n3;
                    this.val$project = iProject;
                    this.setIgnored(8, false);
                    this.setIgnored(9, false);
                }

                public void accept(CompletionProposal proposal) {
                    if (proposal.getKind() == 8) {
                        String pkgName = new String(proposal.getCompletion());
                        TypePackageCompletionProcessor.this.addProposalToCollection(this.val$c, this.val$startOffset, this.val$length, pkgName, pkgName, JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif"));
                    } else {
                        Image image;
                        boolean isInterface = Flags.isInterface((int)proposal.getFlags());
                        String completion = new String(proposal.getCompletion());
                        if (isInterface && this.val$typeScope == 5 || !isInterface && this.val$typeScope == 6 || completion.equals("Dummy2")) {
                            return;
                        }
                        int period = completion.lastIndexOf(46);
                        String cName = null;
                        String pName = null;
                        if (period == -1) {
                            int waitingPolicy = 1;
                            final HashSet tt = new HashSet();
                            TypeNameRequestor ss = new TypeNameRequestor(){

                                public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                                    tt.add(new String(packageName) + "." + new String(simpleTypeName));
                                }
                            };
                            try {
                                JavaSearchScope scope = new JavaSearchScope(false);
                                scope.add((IJavaElement)JavaCore.create((IProject)this.val$project));
                                TypePackageCompletionProcessor.this.fSearchEngine.searchAllTypeNames(null, 1, completion.toCharArray(), 0, 0, (IJavaSearchScope)scope, ss, waitingPolicy, null);
                            }
                            catch (JavaModelException e) {
                                e.printStackTrace();
                            }
                            if (!tt.isEmpty()) {
                                Iterator iterator = tt.iterator();
                                while (iterator.hasNext()) {
                                    String s;
                                    completion = cName = (s = (String)iterator.next());
                                    Image image2 = isInterface ? JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.int_obj.gif") : JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_obj.gif");
                                    TypePackageCompletionProcessor.this.addProposalToCollection(this.val$c, this.val$startOffset, this.val$length, cName + " - " + pName, completion, image2);
                                }
                                return;
                            }
                            cName = completion;
                        } else {
                            cName = completion.substring(period + 1);
                            pName = completion.substring(0, period);
                        }
                        Image image3 = image = isInterface ? JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.int_obj.gif") : JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_obj.gif");
                        if (pName != null) {
                            TypePackageCompletionProcessor.this.addProposalToCollection(this.val$c, this.val$startOffset, this.val$length, cName + " - " + pName, completion, image);
                        }
                    }
                }
            }
            TypePackageCompletionRequestor req = new TypePackageCompletionRequestor(c, startOffset, length, typeScope, project);
            unit.codeComplete(15 + currentContent.length(), (CompletionRequestor)req);
            unit.discardWorkingCopy();
        }
        catch (JavaModelException javaModelException) {}
    }

    private ICompilationUnit getWorkingCopy(IProject project) throws JavaModelException {
        IPackageFragmentRoot[] roots = JavaCore.create((IProject)project).getPackageFragmentRoots();
        if (roots.length > 0) {
            IPackageFragment frag = null;
            int i = 0;
            while (i < roots.length) {
                IJavaElement[] elems;
                if ((roots[i].getKind() == 1 || project.equals((Object)roots[i].getCorrespondingResource()) || roots[i].isArchive() && !roots[i].isExternal()) && (elems = roots[i].getChildren()).length > 0 && elems[0] instanceof IPackageFragment) {
                    frag = (IPackageFragment)elems[0];
                    break;
                }
                ++i;
            }
            if (frag != null) {
                return frag.getCompilationUnit("Dummy2.java").getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            }
        }
        return null;
    }

    protected void generateTypeProposals(String currentContent, IProject project, final Collection c, final int startOffset, final int length, int typeScope) {
        JavaSearchScope javaSearchScope = new JavaSearchScope(false);
        try {
            javaSearchScope.add((IJavaElement)JavaCore.create((IProject)project));
        }
        catch (JavaModelException javaModelException) {}
        JavaSearchScope scope = javaSearchScope;
        char[] packageName = null;
        char[] typeName = null;
        int index = currentContent.lastIndexOf(46);
        if (index == -1) {
            typeName = currentContent.toCharArray();
        } else if (index + 1 == currentContent.length()) {
            typeName = "".toCharArray();
            packageName = currentContent.substring(0, index).toCharArray();
        } else {
            typeName = currentContent.substring(index + 1).toCharArray();
            packageName = currentContent.substring(0, index).toCharArray();
        }
        try {
            TypeNameRequestor req = new TypeNameRequestor(){

                public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                    String cName = new String(simpleTypeName);
                    String pName = new String(packageName);
                    String label = cName + " - " + pName;
                    String content = pName + "." + cName;
                    Image image = Flags.isInterface((int)modifiers) ? JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_obj.gif") : JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.int_obj.gif");
                    TypePackageCompletionProcessor.this.addProposalToCollection(c, startOffset, length, label, content, image);
                }
            };
            this.fSearchEngine.searchAllTypeNames(packageName, 0, typeName, 1, typeScope, (IJavaSearchScope)scope, req, 3, null);
        }
        catch (CoreException e) {
            this.fErrorMessage = e.getMessage();
        }
    }

    public void sortCompletions(ICompletionProposal[] proposals) {
        Arrays.sort(proposals, this.getComparator());
    }

    private Comparator getComparator() {
        if (this.fComparator == null) {
            this.fComparator = new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    ICompletionProposal p1 = (ICompletionProposal)arg0;
                    ICompletionProposal p2 = (ICompletionProposal)arg1;
                    return this.getSortKey(p1).compareToIgnoreCase(this.getSortKey(p2));
                }

                protected String getSortKey(ICompletionProposal p) {
                    return p.getDisplayString();
                }
            };
        }
        return this.fComparator;
    }

    protected final String removeLeadingSpaces(String value) {
        char[] valueArray = value.toCharArray();
        int i = 0;
        while (i < valueArray.length) {
            if (!Character.isWhitespace(valueArray[i])) break;
            ++i;
        }
        return i == valueArray.length ? "" : new String(valueArray, i, valueArray.length - i);
    }

    protected void addProposalToCollection(Collection c, int startOffset, int length, String label, String content, Image image) {
        TypeCompletionProposal proposal = new TypeCompletionProposal(content, image, label, startOffset, length);
        c.add(proposal);
    }

    abstract class ProposalGenerator {
        ProposalGenerator() {
        }

        protected abstract ICompletionProposal generateClassCompletion(String var1, String var2, boolean var3);

        protected abstract ICompletionProposal generatePackageCompletion(String var1);
    }
}

