/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.ide.ui;

import com.onpositive.commons.namespace.ide.ui.editors.xml.model.AttributeModel;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainEditingModel;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainEditingModelObject;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.ElementModel;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.ISelfProvidingElement;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.IDocumentElementNode;
import com.onpositive.ide.ui.CompletionProposal;
import com.onpositive.ide.ui.ICompletionProposalComputer;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;

public abstract class ElementNameProposalComputer
implements ICompletionProposalComputer {
    boolean isInside;
    protected String addAtBeginningStr = "";
    protected boolean needToCloseTag = true;

    public ElementNameProposalComputer(boolean isInside) {
        this.isInside = isInside;
    }

    @Override
    public ICompletionProposal[] computeProposals(DomainEditingModel model, DomainEditingModelObject object, ITextViewer viewer, int offset, String startString, String fullString) {
        DomainEditingModelObject parentNode = object != null ? (DomainEditingModelObject)object.getParentNode() : null;
        return this.computeProposals(model, object, viewer, offset, startString, parentNode, fullString, null);
    }

    private static String simplifyDisplayString(String s) {
        return s != null && s.startsWith("ee:") ? s.substring(3) : s;
    }

    @Override
    public final ICompletionProposal[] computeProposals(DomainEditingModel model, DomainEditingModelObject object, ITextViewer viewer, int offset, String startString, DomainEditingModelObject parentNode, String fullString, Map<String, String> renamed) {
        String resolvePrefix;
        String parentElementName;
        if (startString.length() > 0 && startString.charAt(0) == '<') {
            startString = startString.substring(1);
        }
        int replacementLength = fullString != null && fullString.length() > 0 ? fullString.length() : startString.length();
        ArrayList<QCompletionProposal> list = new ArrayList<QCompletionProposal>();
        ArrayList<ElementModel> candidates = new ArrayList<ElementModel>();
        ArrayList<ElementModel> members = this.getAllElements();
        ElementModel parentElement = null;
        if (parentNode == null) {
            return new ICompletionProposal[0];
        }
        parentElement = this.resolveElement(parentNode.getLocalName(), parentNode.getNamespace(), parentNode.isGlobal(), parentNode.getParentNode());
        if (parentElement != null && "poll".equals(parentElementName = parentElement.getName())) {
            parentElement = this.resolveElement("flow", "http://www.mulesoft.org/schema/mule/core", false, parentNode.getParentNode());
        }
        if (parentElement instanceof ISelfProvidingElement) {
            ISelfProvidingElement q = (ISelfProvidingElement)((Object)parentElement);
            members = new ArrayList<ElementModel>(members);
            members.addAll(Arrays.asList(q.getChildren()));
        }
        if (parentElement != null && parentElement.getAllProperties() != null) {
            HashSet<AttributeModel> parentProperties = parentElement.getAllProperties();
            for (AttributeModel m : parentProperties) {
                if (!m.isComplex()) continue;
                members = new ArrayList<ElementModel>(members);
                ElementModel asElement = m.asElement(parentElement);
                if (asElement == null) continue;
                members.add(asElement);
            }
        }
        Iterator<ElementModel> iterator = members.iterator();
        while (iterator.hasNext()) {
            Object dn;
            ElementModel e;
            ElementModel el = e = iterator.next();
            String url = el.getUrl();
            Object name = this.getDisplayString(el, renamed);
            if (object != null) {
                resolvePrefix = ElementNameProposalComputer.resolvePrefix(object, url);
                if (resolvePrefix != null && resolvePrefix.length() > 0) {
                    name = resolvePrefix + ":" + (String)name;
                }
            } else {
                name = (String)name + " xmlns=\"" + url + "\"";
            }
            if (((String)(dn = name)).startsWith("core:")) {
                dn = ((String)dn).substring(5);
            }
            if (!((String)dn).startsWith(startString) || el.isAbstract() && !el.isShownInXML() || parentElement != null && !parentElement.isAllowedCompletionChild(el)) continue;
            candidates.add(el);
        }
        for (ElementModel m : candidates) {
            QCompletionProposal proposal;
            String url = m.getUrl();
            HashSet<AttributeModel> allProperties = m.getAllProperties();
            ArrayList<AttributeModel> requiredAttributes = new ArrayList<AttributeModel>();
            if (allProperties != null) {
                for (AttributeModel ma : allProperties) {
                    if (!ma.isRequired() && !ma.isAppearsAsRequired()) continue;
                    requiredAttributes.add(ma);
                }
            }
            if (object != null && !url.equals(object.getNamespace())) {
                String replacementString;
                String name;
                resolvePrefix = object.resolvePrefix(url);
                if (resolvePrefix != null) {
                    replacementString = name = this.getDisplayString(m, renamed);
                    replacementString = this.update(replacementString, requiredAttributes, m);
                    proposal = new QCompletionProposal(replacementString, offset - startString.length(), replacementLength, replacementString.length(), m.getIconImage(), name, null, this.getDescription(m), false, null, null);
                    list.add(proposal);
                    continue;
                }
                replacementString = name = this.getDisplayString(m, renamed);
                replacementString = this.update(replacementString, requiredAttributes, m);
                proposal = new QCompletionProposal(replacementString, offset - startString.length(), replacementLength, replacementString.length(), m.getIconImage(), name, null, this.getDescription(m), true, m.getPrefix(), m.getUrl());
                list.add(proposal);
                continue;
            }
            String name = this.getDisplayString(m, renamed);
            if (object == null) {
                String replacementString = name;
                replacementString = this.update(replacementString, requiredAttributes, m);
                QCompletionProposal proposal2 = new QCompletionProposal(replacementString, offset - startString.length(), replacementLength, replacementString.length(), m.getIconImage(), name, null, this.getDescription(m), true, m.getPrefix(), m.getUrl());
                list.add(proposal2);
                continue;
            }
            String elementName = name;
            String updated = this.update(elementName, requiredAttributes, m);
            proposal = new QCompletionProposal(updated, offset - startString.length(), replacementLength, updated.length(), m.getIconImage(), name, null, this.getDescription(m), false, null, null);
            list.add(proposal);
        }
        ICompletionProposal[] ls = new ICompletionProposal[list.size()];
        list.toArray(ls);
        return ls;
    }

    protected abstract String getLocation(String var1);

    protected abstract ElementModel resolveElement(String var1, String var2, boolean var3, IDocumentElementNode var4);

    protected abstract ArrayList<ElementModel> getAllElements();

    private String update(String replacementString, ArrayList<AttributeModel> requiredAttributes, ElementModel m) {
        String docName;
        replacementString = this.addAtBeginningStr + (String)replacementString;
        if (!requiredAttributes.isEmpty()) {
            boolean hasPriorities = this.hasPriorities(requiredAttributes);
            if (hasPriorities) {
                this.sortByPriority(requiredAttributes);
            }
            StringBuilder bld = new StringBuilder((String)replacementString);
            for (AttributeModel ma : requiredAttributes) {
                bld.append(' ');
                bld.append(ma.getName());
                bld.append('=');
                bld.append('\"');
                bld.append('\"');
            }
            replacementString = bld.toString();
        }
        if ((docName = m.getCompletionProposalDocName()) != null) {
            replacementString = (String)replacementString + " doc:name=\"" + docName + "\"";
        }
        if (!Character.isWhitespace(((String)replacementString).charAt(((String)replacementString).length() - 1))) {
            replacementString = (String)replacementString + " ";
        }
        if (this.needToCloseTag) {
            if (m.mayHaveChilds()) {
                replacementString = (String)replacementString + ">";
                replacementString = (String)replacementString + "</" + m.getName() + ">";
            } else {
                replacementString = (String)replacementString + "/>";
            }
        }
        return replacementString;
    }

    private void sortByPriority(ArrayList<AttributeModel> requiredAttributes) {
        Collections.sort(requiredAttributes, new Comparator<AttributeModel>(){

            @Override
            public int compare(AttributeModel o1, AttributeModel o2) {
                return o1.priority() - o2.priority();
            }
        });
    }

    private boolean hasPriorities(ArrayList<AttributeModel> requiredAttributes) {
        for (AttributeModel attributeModel : requiredAttributes) {
            if (attributeModel.priority() == 0) continue;
            return true;
        }
        return false;
    }

    private String getDescription(ElementModel m) {
        StringBuilder result = new StringBuilder();
        result.append("<b>");
        result.append("Element:</b>");
        result.append(m.getName());
        result.append("<br><b> Declared in: </b>" + m.getUrl());
        result.append("<br/>");
        String description = m.getDescription();
        if (description != null && description.length() > 0) {
            result.append("<b>Description:</b><br/>" + description);
            result.append("<br/>");
        }
        return result.toString();
    }

    private String getDisplayString(ElementModel m, Map<String, String> renamed) {
        String name = m.getName();
        String[] splitted = name.split(":");
        if (splitted.length == 2 && renamed != null) {
            String prefix = splitted[0];
            String local = splitted[1];
            if (renamed.containsKey(prefix)) {
                return renamed.get(prefix) + ":" + local;
            }
        }
        return name;
    }

    private static String resolvePrefix(DomainEditingModelObject object, String url) {
        return object.resolvePrefix(url);
    }

    public String getAddAtBeginningStr() {
        return this.addAtBeginningStr;
    }

    public void setAddAtBeginningStr(String addAtBeginningStr) {
        this.addAtBeginningStr = addAtBeginningStr;
    }

    public boolean isNeedToCloseTag() {
        return this.needToCloseTag;
    }

    public void setNeedToCloseTag(boolean needToCloseTag) {
        this.needToCloseTag = needToCloseTag;
    }

    public class QCompletionProposal
    extends CompletionProposal
    implements ICompletionProposalExtension2 {
        boolean needNamespace;
        String namespace;
        String prefix;

        protected QCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, boolean needNamspace, String pref, String namespace) {
            super(replacementString, replacementOffset, replacementLength, cursorPosition, image, ElementNameProposalComputer.simplifyDisplayString(displayString), contextInformation, additionalProposalInfo);
            this.needNamespace = needNamspace;
            this.prefix = pref;
            this.namespace = namespace;
        }

        @Override
        public void apply(IDocument document) {
            AnalyticsRecordsFactory.single((String)Events.ELEMENT_ADDED_IN_XML_AUTOCOMPLETE, (String[])new String[]{"element", this.getDisplayString()}).track();
            String text = "xmlns:" + this.prefix + "=\"" + this.namespace + "\" ";
            if (this.needNamespace) {
                this.fCursorPosition += text.length();
                super.apply(document);
                DomainEditingModel d = new DomainEditingModel(document, true);
                d.load(new ByteArrayInputStream(document.get().getBytes()), true);
                int offset = d.getRoot().getOffset();
                try {
                    String location;
                    document.replace(offset + d.getRoot().getXMLTagName().length() + 2, 0, text);
                    String contents = document.get();
                    String string = "xsi:schemaLocation=\"";
                    int indexOf = contents.indexOf(string);
                    if (indexOf != -1 && (location = ElementNameProposalComputer.this.getLocation(this.prefix + "/" + this.namespace)) != null && contents.indexOf(location) == -1) {
                        document.replace(indexOf + string.length(), 0, location);
                        this.fCursorPosition += location.length();
                    }
                }
                catch (BadLocationException badLocationException) {}
            } else {
                super.apply(document);
            }
        }

        public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
            this.apply(viewer.getDocument());
        }

        public void selected(ITextViewer viewer, boolean smartToggle) {
        }

        public void unselected(ITextViewer viewer) {
        }

        public boolean validate(IDocument document, int offset, DocumentEvent event) {
            StringBuilder bld = new StringBuilder();
            int a = offset - 1;
            while (a >= 0) {
                try {
                    char char1 = document.getChar(a);
                    if (Character.isWhitespace(char1) || char1 == '<') break;
                    bld.append(char1);
                }
                catch (BadLocationException badLocationException) {
                    break;
                }
                --a;
            }
            bld.reverse();
            String string = bld.toString();
            if (this.getDisplayString().startsWith(string)) {
                ++this.fReplacementLength;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.getDisplayString();
        }
    }
}

