/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.ide.ui;

import com.onpositive.commons.namespace.ide.ui.editors.xml.model.AttributeModel;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainAttributeNode;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainEditingModel;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainEditingModelObject;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.ElementModel;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.ITypeHyperlinkProvider;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.ModelVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;

public abstract class CustomizableHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, final IRegion region, boolean canShowMultipleHyperlinks) {
        final ArrayList values = new ArrayList();
        DomainEditingModel dm = new DomainEditingModel(textViewer.getDocument(), true);
        try {
            dm.load();
        }
        catch (CoreException coreException) {}
        if (dm.isValid()) {
            dm.getRoot().traverse(new ModelVisitor(){

                @Override
                public void visitAttribute(DomainAttributeNode na) {
                    int start = na.getValueOffset();
                    int length = na.getValueLength();
                    if (region.getOffset() >= start && region.getOffset() + region.getLength() <= start + length) {
                        HashSet<AttributeModel> allProperties;
                        DomainEditingModelObject parentNode = (DomainEditingModelObject)na.getEnclosingElement();
                        ElementModel parentElement = null;
                        parentElement = CustomizableHyperlinkDetector.this.resolveElement(parentNode.getLocalName(), parentNode.getNamespace(), parentNode.isGlobal());
                        if (parentElement != null && (allProperties = parentElement.getAllProperties()) != null) {
                            for (AttributeModel m : allProperties) {
                                IHyperlink[] calculateHyperlinks;
                                ITypeHyperlinkProvider completionProvider;
                                if (!m.getName().equals(na.getAttributeName()) || (completionProvider = m.getHyperlinkProvider()) == null || (calculateHyperlinks = completionProvider.calculateHyperlinks(na.getAttributeName(), parentNode, null, start, na.getAttributeValue(), length, na.getAttributeValue(), m.getTypeSpecialization())) == null) continue;
                                values.addAll(Arrays.asList(calculateHyperlinks));
                            }
                        }
                    }
                }

                @Override
                public void exitNode(DomainEditingModelObject domainEditingModelObject) {
                }

                @Override
                public void enterNode(DomainEditingModelObject domainEditingModelObject) {
                }
            });
        }
        if (!values.isEmpty()) {
            return values.toArray(new IHyperlink[values.size()]);
        }
        return null;
    }

    protected abstract ElementModel resolveElement(String var1, String var2, boolean var3);
}

