/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.ide.ui;

import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainEditingModel;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainEditingModelObject;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.ElementModel;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.IDocumentElementNode;
import com.onpositive.ide.ui.AttributeProposalComputer;
import com.onpositive.ide.ui.AttributeValueComputer;
import com.onpositive.ide.ui.ElementNameProposalComputer;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.parser.XMLTokenizer;

public abstract class CustomContentAssistProcessor
implements IContentAssistProcessor {
    static final int COMPLETE_TAG_NAME = 0;
    static final int COMPLETE_ATTR_NAME = 1;
    static final int COMPLETE_ATTR_VALUE = 2;
    static final int COMPLETE_CHILD_NAME = 3;
    private IDocument document;
    private DomainEditingModel model;

    protected CustomContentAssistProcessor() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        this.document = viewer.getDocument();
        this.loadModel(viewer.getSelectedRange());
        if (this.model.getRoot() == null) {
            this.loadModel(viewer.getSelectedRange());
            if (this.model.getRoot() == null) {
                try {
                    String text = viewer.getDocument().get(0, offset);
                    CompletionInfo determineCompletionType = this.determineCompletionType(text, offset);
                    if (determineCompletionType == null) return null;
                    ITextRegion region = determineCompletionType.region;
                    if (region == null && determineCompletionType.previousRegions.size() > 0) {
                        region = determineCompletionType.previousRegions.peek();
                    }
                    if (region == null) return this.computeIncorrect(null, viewer, offset, determineCompletionType);
                    String type = region.getType();
                    if (type.equals("XML_TAG_OPEN")) return new MElementNameProposalComputer(determineCompletionType.isInTagDeclaration).computeProposals(null, null, viewer, offset, text.substring(region.getStart(), Math.min(region.getTextEnd(), offset)), "");
                    if (type.equals("XML_TAG_NAME")) {
                        return new MElementNameProposalComputer(determineCompletionType.isInTagDeclaration).computeProposals(null, null, viewer, offset, text.substring(region.getStart(), Math.min(region.getTextEnd(), offset)), "");
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.model.getRoot() == null) {
            return null;
        }
        DomainEditingModelObject findElement = this.model.getRoot().findElement(offset);
        try {
            int elementOffset = findElement.getOffset();
            String text = viewer.getDocument().get(elementOffset, findElement.getLength());
            CompletionInfo determineCompletionType = this.determineCompletionType(text, offset - elementOffset);
            if (determineCompletionType.isInTagDeclaration) {
                ITextRegion region = determineCompletionType.region;
                if (region != null) {
                    String type = region.getType();
                    if (type.equals("XML_TAG_NAME")) {
                        String tagName = text.substring(region.getStart(), region.getTextEnd());
                        MElementNameProposalComputer computer = new MElementNameProposalComputer(determineCompletionType.isInTagDeclaration);
                        computer.setNeedToCloseTag(false);
                        return computer.computeProposals(this.model, findElement, viewer, offset, text.substring(region.getStart(), Math.min(region.getTextEnd(), offset - elementOffset)), tagName);
                    }
                    if (type.equals("XML_TAG_OPEN")) {
                        return this.computeIncorrect(this.model, viewer, offset, determineCompletionType);
                    }
                    if (type.equals("XML_CONTENT") && determineCompletionType.previousRegions.peek().getType().equals("XML_TAG_OPEN")) {
                        return new MElementNameProposalComputer(determineCompletionType.isInTagDeclaration).computeProposals(this.model, findElement, viewer, offset, "", findElement, "", this.renamedPrefixes());
                    }
                    if (type.equals("XML_TAG_ATTRIBUTE_NAME")) {
                        String fullString = "";
                        if (offset - elementOffset <= region.getStart()) return this.computeStandartAttributeName(findElement, viewer, offset, text, text.substring(region.getStart(), Math.min(region.getTextEnd(), offset - elementOffset)), fullString);
                        fullString = this.computeFullString(region.getStart(), region.getTextEnd(), text);
                        return this.computeStandartAttributeName(findElement, viewer, offset, text, text.substring(region.getStart(), Math.min(region.getTextEnd(), offset - elementOffset)), fullString);
                    }
                    if (type.equals("XML_TAG_ATTRIBUTE_EQUALS") && determineCompletionType.previousRegions.size() > 0) {
                        ITextRegion prevRegion = determineCompletionType.previousRegions.peek();
                        if (prevRegion.getType().equals("XML_TAG_ATTRIBUTE_NAME")) return this.computeStandartAttributeName(findElement, viewer, offset, text, text.substring(prevRegion.getStart(), prevRegion.getTextEnd()), text.substring(prevRegion.getStart(), prevRegion.getTextEnd()));
                        return null;
                    }
                    if (type.equals("XML_TAG_ATTRIBUTE_VALUE")) {
                        return this.computeCompletionProposalForAttribute(viewer, offset, findElement, elementOffset, text, determineCompletionType, region);
                    }
                    if (type.equals("XML_TAG_CLOSE") || type.equals("XML_EMPTY_TAG_CLOSE")) {
                        if (offset - elementOffset > region.getStart()) {
                            return null;
                        }
                        ITextRegion prevRegion = determineCompletionType.previousRegions.peek();
                        if (elementOffset + prevRegion.getStart() + prevRegion.getTextEnd() - 1 == offset && prevRegion.getType().equals("XML_TAG_NAME")) {
                            String startStr = text.substring(prevRegion.getStart(), prevRegion.getTextEnd());
                            return new MElementNameProposalComputer(determineCompletionType.isInTagDeclaration).computeProposals(this.model, findElement, viewer, offset, startStr, findElement, startStr, this.renamedPrefixes());
                        }
                        String startStr = "";
                        String fullStr = "";
                        MAttributeProposalComputer pr = new MAttributeProposalComputer(false);
                        if (!prevRegion.getType().equals("XML_TAG_ATTRIBUTE_NAME")) return pr.computeProposals(this.model, findElement, viewer, offset, startStr, fullStr);
                        fullStr = text.substring(prevRegion.getStart(), prevRegion.getTextEnd());
                        startStr = text.substring(prevRegion.getStart(), Math.min(prevRegion.getTextEnd(), offset - elementOffset));
                        return pr.computeProposals(this.model, findElement, viewer, offset, startStr, fullStr);
                    }
                } else {
                    if (!determineCompletionType.previousRegions.isEmpty()) {
                        ITextRegion peek = determineCompletionType.previousRegions.peek();
                        if (!peek.getType().equals("XML_TAG_ATTRIBUTE_EQUALS") && peek.getType().equals("XML_TAG_NAME") && offset > 0 && !Character.isWhitespace(this.document.get(offset - 1, 1).charAt(0))) {
                            MElementNameProposalComputer computer = new MElementNameProposalComputer(determineCompletionType.isInTagDeclaration);
                            computer.setNeedToCloseTag(!this.checkForTagClosePresence(this.document, offset));
                            return computer.computeProposals(this.model, findElement, viewer, offset, text.substring(peek.getStart(), Math.min(peek.getTextEnd(), offset - elementOffset)), findElement, text.substring(peek.getStart(), peek.getTextEnd()), this.renamedPrefixes());
                        }
                        if (peek.getType().equals("XML_TAG_ATTRIBUTE_NAME")) {
                            MAttributeProposalComputer pr = new MAttributeProposalComputer(false);
                            return pr.computeProposals(this.model, findElement, viewer, offset, text.substring(peek.getStart(), Math.min(peek.getTextEnd(), offset - elementOffset)), findElement, text.substring(peek.getStart(), peek.getTextEnd()), this.renamedPrefixes());
                        }
                    }
                    MAttributeProposalComputer pr = new MAttributeProposalComputer(false);
                    return pr.computeProposals(this.model, findElement, viewer, offset, "", "");
                }
            }
            if (determineCompletionType == null) return null;
            String type = determineCompletionType.getType();
            String peekType = "";
            if (determineCompletionType.previousRegions.size() > 1) {
                determineCompletionType.previousRegions.peek().getType();
            }
            if (type != null) {
                if (type.equals("XML_CONTENT")) {
                    this.doTagCompletion();
                } else if (type.equals("XML_TAG_ATTRIBUTE_VALUE")) {
                    System.out.println("Attribute value");
                } else if (type.equals("XML_TAG_ATTRIBUTE_NAME")) {
                    System.out.println("Attribute name");
                } else {
                    if (type.equals("XML_TAG_ATTRIBUTE_EQUALS")) return null;
                    if (type.equals("XML_END_TAG_OPEN")) return null;
                    if (type.equals("XML_TAG_CLOSE")) return null;
                    if (type.equals("XML_TAG_NAME") && peekType.equals("XML_END_TAG_OPEN")) {
                        return null;
                    }
                }
            }
            MElementNameProposalComputer computer = new MElementNameProposalComputer(determineCompletionType.isInTagDeclaration);
            computer.setAddAtBeginningStr("<");
            return computer.computeProposals(this.model, findElement, viewer, offset, "", findElement, "", this.renamedPrefixes());
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    protected ICompletionProposal[] computeCompletionProposalForAttribute(ITextViewer viewer, int offset, DomainEditingModelObject findElement, int elementOffset, String text, CompletionInfo determineCompletionType, ITextRegion region) throws BadLocationException {
        ITextRegion pop = determineCompletionType.previousRegions.pop();
        pop = determineCompletionType.previousRegions.pop();
        String name = viewer.getDocument().get(pop.getStart() + elementOffset, pop.getLength());
        FieldAttributeValueComputer pr = new FieldAttributeValueComputer(name, findElement);
        String prefixText = text.substring(region.getStart(), Math.min(region.getTextEnd(), offset - elementOffset));
        String sufixText = text.substring(region.getStart(), region.getTextEnd());
        return pr.computeProposals(this.model, findElement, viewer, offset, prefixText, region.getLength(), sufixText);
    }

    protected void addCustomProposals(ITextViewer viewer, ArrayList<ICompletionProposal> result, int offset, DomainEditingModelObject findElement, String startString, int lengthCompletion, String fullString) {
    }

    protected abstract ArrayList<ElementModel> resolveAll();

    protected abstract ElementModel resolve(String var1, String var2, boolean var3, IDocumentElementNode var4);

    protected abstract Map<String, String> renamedPrefixes();

    private String computeFullString(int regionStart, int regionEnd, String text) {
        String baseStr = text.substring(regionStart, regionEnd);
        String rest = text.substring(regionEnd);
        int i = 0;
        while (Character.isWhitespace(rest.charAt(i))) {
            ++i;
        }
        if (rest.charAt(i) != '=') {
            return baseStr;
        }
        ++i;
        while (Character.isWhitespace(rest.charAt(i))) {
            ++i;
        }
        if (rest.charAt(i) != '\"') {
            return baseStr;
        }
        int j = ++i;
        while (j < rest.length()) {
            if (rest.charAt(j) == '\"' && rest.charAt(j - 1) != '\\') {
                return baseStr + rest.substring(0, j + 1);
            }
            ++j;
        }
        return baseStr;
    }

    private ICompletionProposal[] computeStandartAttributeName(DomainEditingModelObject findElement, ITextViewer viewer, int offset, String text, String startString, String fullString) {
        MAttributeProposalComputer pr = new MAttributeProposalComputer(false);
        return pr.computeProposals(this.model, findElement, viewer, offset, startString, fullString);
    }

    private ICompletionProposal[] computeIncorrect(DomainEditingModel model2, ITextViewer viewer, int offset, CompletionInfo determineCompletionType) throws BadLocationException {
        IDocument document = viewer.getDocument();
        MElementNameProposalComputer computer = new MElementNameProposalComputer(determineCompletionType.isInTagDeclaration);
        String[] res = this.tokenizeString(document.get(0, offset));
        String startStr = "";
        String fullStr = "";
        if (res.length > 0) {
            if (!res[res.length - 1].equals("<")) {
                startStr = fullStr = res[res.length - 1];
                if (res.length < 2 || !res[res.length - 2].equals("<")) {
                    computer.setAddAtBeginningStr("<");
                }
            }
        } else {
            computer.setAddAtBeginningStr("<");
        }
        return computer.computeProposals(this.model, null, viewer, offset, startStr, fullStr);
    }

    private String[] tokenizeString(String str) {
        StringTokenizer tokenizer = new StringTokenizer(str, "<>/", true);
        String[] res = new String[tokenizer.countTokens()];
        int i = 0;
        while (i < res.length) {
            res[i] = tokenizer.nextToken();
            ++i;
        }
        return res;
    }

    private boolean checkForTagClosePresence(IDocument document, int offset) {
        int i = offset;
        while (i < document.getLength() - 1) {
            block5: {
                try {
                    if (!document.get(i, 1).equals(">")) break block5;
                    return true;
                }
                catch (BadLocationException badLocationException) {}
            }
            if (document.get(i, 1).equals("<")) {
                return false;
            }
            ++i;
        }
        return false;
    }

    private void doTagCompletion() {
    }

    private CompletionInfo determineCompletionType(String text, int offset) {
        if (offset < 0) {
            offset = 0;
        }
        XMLTokenizer tk = new XMLTokenizer();
        tk.reset((Reader)new StringReader(text));
        CompletionInfo info = new CompletionInfo();
        try {
            ITextRegion nextToken;
            while ((nextToken = tk.getNextToken()) != null) {
                String type = nextToken.getType();
                if (type.equals("XML_TAG_OPEN")) {
                    info.isInTagDeclaration = true;
                } else if ((type.equals("XML_TAG_CLOSE") || type.equals("XML_EMPTY_TAG_CLOSE")) && nextToken.getEnd() <= offset) {
                    info.isInTagDeclaration = false;
                }
                if (nextToken.getStart() <= offset && nextToken.getTextEnd() > offset) {
                    info.region = nextToken;
                    return info;
                }
                if (nextToken.getStart() > offset) {
                    return info;
                }
                info.previousRegions.add(nextToken);
            }
        }
        catch (IOException iOException) {}
        return info;
    }

    public abstract String getNamespaceLocationString(String var1);

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    private void loadModel(Point point) {
        if (this.document == null) {
            return;
        }
        DomainEditingModel dm = new DomainEditingModel(this.document, true);
        try {
            dm.load();
            if (dm.isValid()) {
                this.model = dm;
            } else {
                String initialContent = this.document.get();
                StringBuffer bs = new StringBuffer(initialContent);
                try {
                    Document da;
                    if (point.y == 0 && point.x > 0) {
                        int a = point.x - 1;
                        while (a >= 0) {
                            char charAt = bs.charAt(a);
                            if (Character.isWhitespace(charAt)) break;
                            bs.setCharAt(a, ' ');
                            --a;
                        }
                        da = new Document(bs.toString());
                        dm = new DomainEditingModel((IDocument)da, true);
                        dm.load();
                        if (dm.isValid()) {
                            this.model = dm;
                            return;
                        }
                        bs = new StringBuffer(initialContent);
                        IRegion lineInformationOfOffset = this.document.getLineInformationOfOffset(point.x);
                        int end = lineInformationOfOffset.getOffset() + lineInformationOfOffset.getLength();
                        int a2 = lineInformationOfOffset.getOffset();
                        while (a2 < end) {
                            bs.setCharAt(a2, ' ');
                            ++a2;
                        }
                    }
                    da = new Document(bs.toString());
                    dm = new DomainEditingModel((IDocument)da, true);
                    dm.load();
                    this.model = dm;
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        catch (CoreException coreException) {
            throw new RuntimeException();
        }
    }

    static class CompletionInfo {
        Stack<ITextRegion> previousRegions = new Stack();
        boolean isInTagDeclaration;
        ITextRegion region;

        CompletionInfo() {
        }

        public String getType() {
            if (this.region != null) {
                return this.region.getType();
            }
            return null;
        }
    }

    private final class FieldAttributeValueComputer
    extends AttributeValueComputer {
        private final DomainEditingModelObject findElement;

        private FieldAttributeValueComputer(String name, DomainEditingModelObject findElement) {
            super(name);
            this.findElement = findElement;
        }

        @Override
        protected ElementModel resolveElement(String localName, String namespace) {
            return CustomContentAssistProcessor.this.resolve(localName, namespace, this.findElement.isGlobal(), this.findElement.getParentNode());
        }

        @Override
        protected void addCustomProposals(ITextViewer viewer, ArrayList<ICompletionProposal> result, int offset, DomainEditingModelObject findElement, String startString, int lengthCompletion, String fullString) {
            CustomContentAssistProcessor.this.addCustomProposals(viewer, result, offset, findElement, startString, lengthCompletion, fullString);
        }
    }

    private final class MAttributeProposalComputer
    extends AttributeProposalComputer {
        private MAttributeProposalComputer(boolean isInside) {
            super(isInside);
        }

        @Override
        protected ElementModel resolveElement(String localName, String namespace, boolean isGlobal, IDocumentElementNode parent) {
            return CustomContentAssistProcessor.this.resolve(localName, namespace, isGlobal, parent);
        }
    }

    private final class MElementNameProposalComputer
    extends ElementNameProposalComputer {
        private MElementNameProposalComputer(boolean isInside) {
            super(isInside);
        }

        @Override
        protected ElementModel resolveElement(String localName, String namespace, boolean isGlobal, IDocumentElementNode parent) {
            return CustomContentAssistProcessor.this.resolve(localName, namespace, isGlobal, parent);
        }

        @Override
        protected ArrayList<ElementModel> getAllElements() {
            return CustomContentAssistProcessor.this.resolveAll();
        }

        @Override
        protected String getLocation(String namespace) {
            return CustomContentAssistProcessor.this.getNamespaceLocationString(namespace);
        }
    }
}

