/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.ide.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class CompletionProposal
implements ICompletionProposal {
    private static final int IMAGE_WIDTH = 18;
    private static final int IMAGE_HEIGHT = 12;
    private static final Object lock = new Object();
    private static volatile ImageRegistry imageRegistry;
    private String fDisplayString;
    private String fReplacementString;
    protected int fReplacementOffset;
    protected int fReplacementLength;
    int fCursorPosition;
    private Image fImage;
    private IContextInformation fContextInformation;
    private String fAdditionalProposalInfo;

    protected CompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition) {
        this(replacementString, replacementOffset, replacementLength, cursorPosition, null, null, null, null);
    }

    protected CompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        Assert.isNotNull((Object)replacementString);
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
        this.fReplacementString = replacementString;
        this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fCursorPosition = cursorPosition;
        this.fImage = image;
        this.fDisplayString = displayString;
        this.fContextInformation = contextInformation;
        this.fAdditionalProposalInfo = additionalProposalInfo;
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
        }
        catch (BadLocationException badLocationException) {}
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public Image getImage() {
        Image image = this.getImageRegistry().get(this.getDisplayString());
        if (image == null) {
            ImageData scaledData = this.fImage.getImageData().scaledTo(18, 12);
            Image scaled = new Image((Device)Display.getCurrent(), scaledData);
            this.getImageRegistry().put(this.getDisplayString(), scaled);
        }
        return this.getImageRegistry().get(this.getDisplayString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageRegistry getImageRegistry() {
        ImageRegistry result = imageRegistry;
        if (result == null) {
            Object object = lock;
            synchronized (object) {
                result = imageRegistry;
                if (result == null) {
                    imageRegistry = result = new ImageRegistry();
                }
            }
        }
        return result;
    }

    public String getReplacementString() {
        return this.fReplacementString;
    }

    public String getDisplayString() {
        if (this.fDisplayString != null) {
            return this.fDisplayString;
        }
        return this.fReplacementString;
    }

    public String getAdditionalProposalInfo() {
        return this.fAdditionalProposalInfo;
    }
}

