/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.ide.ui;

import com.onpositive.commons.namespace.ide.ui.editors.xml.model.AttributeModel;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainEditingModel;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainEditingModelObject;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.ElementModel;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.ITypeCompletionProvider;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public abstract class AttributeValueComputer {
    private final String attributeName;

    public AttributeValueComputer(String name) {
        this.attributeName = name;
    }

    public ICompletionProposal[] computeProposals(DomainEditingModel model, DomainEditingModelObject findElement, ITextViewer viewer, int offset, String startString, int lengthCompletion, String fullString) {
        boolean needToAddBraces = true;
        String trim = startString.trim();
        if (startString.startsWith("\"")) {
            fullString = this.dequoteString(fullString);
            trim = startString.trim().substring(1);
            needToAddBraces = false;
        }
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        if (!this.attributeName.startsWith("xmlns") && findElement != null) {
            HashSet<AttributeModel> allProperties;
            DomainEditingModelObject parentNode = findElement;
            ElementModel parentElement = null;
            parentElement = this.resolveElement(parentNode.getLocalName(), parentNode.getNamespace());
            if (parentElement != null && (allProperties = parentElement.getAllProperties()) != null) {
                for (AttributeModel m : allProperties) {
                    String type;
                    ITypeCompletionProvider completionProvider;
                    if (!m.getName().equals(this.attributeName) || (completionProvider = m.getCompletionProvider(type = m.getType())) == null) continue;
                    completionProvider.fillProposals(this.attributeName, findElement, viewer, offset, trim, lengthCompletion, result, fullString, needToAddBraces, m.getTypeSpecialization());
                }
            }
        }
        this.addCustomProposals(viewer, result, offset, findElement, startString, lengthCompletion, fullString);
        ICompletionProposal[] ps = new ICompletionProposal[result.size()];
        result.toArray(ps);
        return ps;
    }

    protected void addCustomProposals(ITextViewer viewer, ArrayList<ICompletionProposal> result, int offset, DomainEditingModelObject findElement, String startString, int lengthCompletion, String fullString) {
    }

    protected abstract ElementModel resolveElement(String var1, String var2);

    private String dequoteString(String str) {
        if (str == null) {
            return str;
        }
        if (str.length() > 0 && str.charAt(0) == '\"') {
            str = str.substring(1);
        }
        if (str.length() > 0 && str.charAt(str.length() - 1) == '\"') {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }
}

