/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.ide.ui;

import com.onpositive.commons.namespace.ide.ui.editors.xml.model.AttributeModel;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainEditingModel;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainEditingModelObject;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.ElementModel;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.IDocumentAttributeNode;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.IDocumentElementNode;
import com.onpositive.ide.ui.ICompletionProposalComputer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public abstract class AttributeProposalComputer
implements ICompletionProposalComputer {
    boolean isInside;

    public AttributeProposalComputer(boolean isInside) {
        this.isInside = isInside;
    }

    @Override
    public ICompletionProposal[] computeProposals(DomainEditingModel model, DomainEditingModelObject object, ITextViewer viewer, int offset, String startString, String fullString) {
        int repalcamentLength = startString.length();
        if (fullString != null && !fullString.equals("")) {
            repalcamentLength = fullString.length();
        }
        ArrayList<CompletionProposal> list = new ArrayList<CompletionProposal>();
        IDocumentAttributeNode[] nodeAttributes = object.getNodeAttributes();
        HashSet<String> existingAttributes = new HashSet<String>();
        IDocumentAttributeNode[] iDocumentAttributeNodeArray = nodeAttributes;
        int n = nodeAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentAttributeNode n3 = iDocumentAttributeNodeArray[n2];
            existingAttributes.add(n3.getAttributeName());
            ++n2;
        }
        ElementModel parentElement = null;
        parentElement = this.resolveElement(object.getLocalName(), object.getNamespace(), object.isGlobal(), object.getParentNode());
        if (parentElement == null) {
            return new ICompletionProposal[0];
        }
        HashSet<AttributeModel> allProperties = parentElement.getAllProperties();
        if (allProperties != null) {
            for (AttributeModel m : allProperties) {
                String name = m.getName();
                if (existingAttributes.contains(name) || m.isComplex() || !name.startsWith(startString.trim())) continue;
                String replace = name + "=\"\"";
                int length = replace.length();
                CompletionProposal proposal = new CompletionProposal(replace, offset - startString.length(), repalcamentLength, length - 1, m.getIcon(), name, null, this.getDescription(m));
                list.add(proposal);
            }
        }
        ICompletionProposal[] ls = new ICompletionProposal[list.size()];
        list.toArray(ls);
        return ls;
    }

    protected abstract ElementModel resolveElement(String var1, String var2, boolean var3, IDocumentElementNode var4);

    private String getDescription(AttributeModel m) {
        StringBuilder result = new StringBuilder();
        result.append("<b>");
        result.append("Attribute:");
        result.append(m.getName());
        if (m.isRequired()) {
            result.append('(');
            if (m.isRequired()) {
                result.append("required");
            }
            result.append(')');
        }
        result.append("<br/>Type: ");
        result.append(m.getType());
        result.append("<br/>");
        result.append("</b>");
        result.append("<br/>");
        String description = m.getDescription();
        if (description != null && description.length() > 0) {
            result.append("<b>Description:</b>" + description);
        }
        return result.toString();
    }

    @Override
    public ICompletionProposal[] computeProposals(DomainEditingModel model, DomainEditingModelObject object, ITextViewer viewer, int offset, String startString, DomainEditingModelObject parentNode, String fullString, Map<String, String> renamed) {
        return this.computeProposals(model, object, viewer, offset, startString, fullString);
    }
}

