/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.commons.namespace.ide.ui.internal.core.text;

import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainEditingModelObject;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.AbstractEditingModel;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.SAXParserWrapper;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMLEditingModel
extends AbstractEditingModel {
    public XMLEditingModel(IDocument document, boolean isReconciling) {
        super(document, isReconciling);
    }

    @Override
    public void load(InputStream source, boolean outOfSync) {
        try {
            this.fLoaded = true;
            SAXParserWrapper parser = new SAXParserWrapper();
            parser.parse(source, this.createDocumentHandler(this, true));
        }
        catch (SAXException sAXException) {
            this.fLoaded = false;
        }
        catch (IOException iOException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (FactoryConfigurationError factoryConfigurationError) {}
    }

    protected abstract DefaultHandler createDocumentHandler(AbstractEditingModel var1, boolean var2);

    @Override
    public void adjustOffsets(IDocument document) {
        try {
            SAXParserWrapper parser = new SAXParserWrapper();
            parser.parse(this.getInputStream(document), this.createDocumentHandler(this, false));
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException iOException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (FactoryConfigurationError factoryConfigurationError) {}
    }

    private boolean isResourceFile() {
        if (this.getUnderlyingResource() == null) {
            return false;
        }
        return this.getUnderlyingResource() instanceof IFile;
    }

    public void save() {
        if (!this.isResourceFile()) {
            return;
        }
        try {
            IFile file = (IFile)this.getUnderlyingResource();
            String contents = this.getContents();
            ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes("UTF8"));
            if (file.exists()) {
                file.setContents((InputStream)stream, false, false, null);
            } else {
                file.create((InputStream)stream, false, null);
            }
            stream.close();
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {}
    }

    public void reload() {
        if (!this.isResourceFile()) {
            return;
        }
        IFile file = (IFile)this.getUnderlyingResource();
        if (file.exists()) {
            BufferedInputStream stream = null;
            try {
                stream = new BufferedInputStream(file.getContents(true));
                this.reload(stream, false);
                this.setDirty(false);
            }
            catch (CoreException coreException) {}
        }
    }

    public void reload(IDocument document) {
        String text = document.get();
        ByteArrayInputStream stream = null;
        try {
            stream = new ByteArrayInputStream(text.getBytes("UTF8"));
            this.reload(stream, false);
            this.setDirty(false);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (CoreException coreException) {}
    }

    public String getContents() {
        String string;
        PrintWriter writer;
        block9: {
            StringWriter swriter = null;
            writer = null;
            try {
                swriter = new StringWriter();
                writer = new PrintWriter(swriter);
                this.setLoaded(true);
                this.save(writer);
                writer.flush();
                string = swriter.toString();
                if (swriter == null) break block9;
            }
            catch (Throwable throwable) {
                if (swriter != null) {
                    try {
                        swriter.close();
                    }
                    catch (IOException iOException) {}
                }
                if (writer != null) {
                    writer.close();
                }
                throw throwable;
            }
            try {
                swriter.close();
            }
            catch (IOException iOException) {}
        }
        if (writer != null) {
            writer.close();
        }
        return string;
    }

    @Override
    public void save(PrintWriter writer) {
        if (this.isLoaded()) {
            this.getRoot().write("", writer);
        }
        this.setDirty(false);
    }

    protected abstract DomainEditingModelObject getRoot();
}

