/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.commons.namespace.ide.ui.internal.core.text;

import com.onpositive.commons.namespace.ide.ui.internal.core.text.IDocumentAttributeNode;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.IDocumentElementNode;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.IDocumentTextNode;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.StringEscapeUtils;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Stack;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class DocumentHandler
extends DefaultHandler {
    protected FindReplaceDocumentAdapter fFindReplaceAdapter;
    protected Stack<Object> fDocumentNodeStack = new Stack();
    protected int fHighestOffset = 0;
    private Locator fLocator;
    private IDocumentElementNode fLastError;
    private final boolean fReconciling;

    public DocumentHandler(boolean reconciling) {
        this.fReconciling = reconciling;
    }

    @Override
    public void startDocument() throws SAXException {
        this.fDocumentNodeStack.clear();
        this.fHighestOffset = 0;
        this.fLastError = null;
        this.fFindReplaceAdapter = new FindReplaceDocumentAdapter(this.getDocument());
    }

    protected IDocumentElementNode getLastParsedDocumentNode() {
        if (this.fDocumentNodeStack.isEmpty()) {
            return null;
        }
        return (IDocumentElementNode)this.fDocumentNodeStack.peek();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        IDocumentElementNode parent = this.getLastParsedDocumentNode();
        IDocumentElementNode node = this.getDocumentNode(qName, parent);
        try {
            int nodeOffset = this.getStartOffset(qName);
            node.setOffset(nodeOffset);
            IDocument doc = this.getDocument();
            int line = doc.getLineOfOffset(nodeOffset);
            node.setLineIndent(node.getOffset() - doc.getLineOffset(line));
            Object fAttributes = DocumentHandler.getFieldValue(attributes, "fAttributes");
            Object[] fAttributes2 = (Object[])(fAttributes == null ? null : DocumentHandler.getFieldValue(fAttributes, "fAttributes"));
            int i = 0;
            while (i < attributes.getLength()) {
                IDocumentAttributeNode attribute;
                Object origAttribute;
                String origAttributeValue;
                String attName = attributes.getQName(i);
                String attValue = attributes.getValue(i);
                if (fAttributes2 != null && (origAttributeValue = (String)DocumentHandler.getFieldValue(origAttribute = fAttributes2[i], "nonNormalizedValue")) != null) {
                    attValue = origAttributeValue;
                    attValue = StringEscapeUtils.unescapeXml(attValue);
                }
                if ((attribute = this.getDocumentAttribute(attName, attValue, node)) != null) {
                    IRegion region = this.getAttributeRegion(attName, attValue, nodeOffset);
                    if (region == null) {
                        region = this.getAttributeRegion(attName, attValue, nodeOffset);
                    }
                    if (region != null) {
                        attribute.setNameOffset(region.getOffset());
                        attribute.setNameLength(attName.length());
                        attribute.setValueOffset(region.getOffset() + region.getLength() - 1 - attValue.length());
                        attribute.setValueLength(attValue.length());
                    }
                    node.setXMLAttribute(attribute);
                }
                ++i;
            }
            this.removeOrphanAttributes(node);
        }
        catch (BadLocationException badLocationException) {}
        if (parent != null && node != null && node.getParentNode() == null) {
            if (this.fReconciling) {
                int position = 0;
                IDocumentElementNode[] children = parent.getChildNodes();
                while (position < children.length) {
                    if (children[position].getOffset() == -1) break;
                    ++position;
                }
                parent.addChildNode(node, position);
            } else {
                parent.addChildNode(node);
            }
        }
        this.fDocumentNodeStack.push(node);
    }

    private static Object getFieldValue(Object obj, String fieldName) {
        Class<?> klass = obj.getClass();
        try {
            Field field = klass.getDeclaredField(fieldName);
            boolean oldAccessible = field.isAccessible();
            field.setAccessible(true);
            Object result = field.get(obj);
            field.setAccessible(oldAccessible);
            return result;
        }
        catch (SecurityException securityException) {
            return null;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    protected abstract IDocumentElementNode getDocumentNode(String var1, IDocumentElementNode var2);

    protected abstract IDocumentAttributeNode getDocumentAttribute(String var1, String var2, IDocumentElementNode var3);

    protected abstract IDocumentTextNode getDocumentTextNode(String var1, IDocumentElementNode var2);

    private int getStartOffset(String elementName) throws BadLocationException {
        int line = this.fLocator.getLineNumber();
        int col = this.fLocator.getColumnNumber();
        IDocument doc = this.getDocument();
        if (col < 0) {
            col = doc.getLineLength(line);
        }
        String text = doc.get(this.fHighestOffset + 1, doc.getLineOffset(line) - this.fHighestOffset - 1);
        ArrayList<Position> commentPositions = new ArrayList<Position>();
        int idx = 0;
        while (idx < text.length()) {
            int end;
            if ((idx = text.indexOf("<!--", idx)) == -1 || (end = text.indexOf("-->", idx)) == -1) break;
            commentPositions.add(new Position(idx, end - idx));
            idx = end + 1;
        }
        idx = 0;
        while (idx < text.length()) {
            idx = text.indexOf("<" + elementName, idx);
            if (idx == -1) break;
            boolean valid = true;
            int i = 0;
            while (i < commentPositions.size()) {
                Position pos = (Position)commentPositions.get(i);
                if (pos.includes(idx)) {
                    valid = false;
                    break;
                }
                ++i;
            }
            if (valid) break;
            ++idx;
        }
        if (idx > -1) {
            this.fHighestOffset += idx + 1;
        }
        return this.fHighestOffset;
    }

    private int getElementLength(IDocumentElementNode node, int line, int column) throws BadLocationException {
        int start;
        int endIndex = node.getOffset();
        IDocument doc = this.getDocument();
        String lineText = doc.get(start = Math.max(doc.getLineOffset(line), node.getOffset()), (column = doc.getLineLength(line)) - start + doc.getLineOffset(line));
        int index = lineText.indexOf("</" + node.getXMLTagName() + ">");
        endIndex = index == -1 ? ((index = lineText.indexOf(">")) == -1 ? column : index + 1) : index + node.getXMLTagName().length() + 3;
        return start + endIndex - node.getOffset();
    }

    private IRegion getAttributeRegion(String name, String inValue, int offset) throws BadLocationException {
        String value = DocumentHandler.escape(inValue);
        IRegion nameRegion = this.fFindReplaceAdapter.find(offset, "\\s" + name + "\\s*=\\s*(\"|')", true, true, false, true);
        if (nameRegion != null) {
            return new Region(nameRegion.getOffset(), nameRegion.getLength() + value.length() + 1);
        }
        return null;
    }

    public static String escape(String orig) {
        return StringEscapeUtils.escapeXml(orig).replaceAll("&apos;", "'").replaceAll("&quot;", "\"");
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.fDocumentNodeStack.isEmpty()) {
            return;
        }
        IDocumentElementNode node = (IDocumentElementNode)this.fDocumentNodeStack.pop();
        try {
            node.setLength(this.getElementLength(node, this.fLocator.getLineNumber() - 1, this.fLocator.getColumnNumber()));
            this.setTextNodeOffset(node);
        }
        catch (BadLocationException badLocationException) {}
        this.removeOrphanElements(node);
    }

    /*
     * Unable to fully structure code
     */
    protected void setTextNodeOffset(IDocumentElementNode node) throws BadLocationException {
        block4: {
            textNode = node.getTextNode();
            if (textNode == null || textNode.getText() == null) break block4;
            if (textNode.getText().trim().length() == 0) {
                node.removeTextNode();
                return;
            }
            doc = this.getDocument();
            text = doc.get(node.getOffset(), node.getLength());
            relativeStartOffset = text.indexOf(62) + 1;
            relativeEndOffset = text.lastIndexOf(60) - 1;
            if (relativeStartOffset < 0 || relativeStartOffset >= text.length()) {
                return;
            }
            if (relativeEndOffset >= 0 && relativeEndOffset < text.length()) ** GOTO lbl15
            return;
lbl-1000:
            // 1 sources

            {
                ++relativeStartOffset;
lbl15:
                // 2 sources

                ** while (Character.isWhitespace((char)text.charAt((int)relativeStartOffset)))
            }
lbl16:
            // 2 sources

            while (Character.isWhitespace(text.charAt(relativeEndOffset))) {
                --relativeEndOffset;
            }
            textNode.setOffset(node.getOffset() + relativeStartOffset);
            textNode.setLength(relativeEndOffset - relativeStartOffset + 1);
            textNode.setText(textNode.getText().trim());
        }
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.generateErrorElementHierarchy();
    }

    private void generateErrorElementHierarchy() {
        while (!this.fDocumentNodeStack.isEmpty()) {
            IDocumentElementNode node = (IDocumentElementNode)this.fDocumentNodeStack.pop();
            node.setIsErrorNode(true);
            this.removeOrphanAttributes(node);
            this.removeOrphanElements(node);
            if (this.fLastError != null) continue;
            this.fLastError = node;
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.generateErrorElementHierarchy();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.fLocator = locator;
    }

    protected abstract IDocument getDocument();

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return new InputSource(new StringReader(""));
    }

    public IDocumentElementNode getLastErrorNode() {
        return this.fLastError;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.fReconciling || this.fDocumentNodeStack.isEmpty()) {
            return;
        }
        IDocumentElementNode parent = (IDocumentElementNode)this.fDocumentNodeStack.peek();
        StringBuffer buffer = new StringBuffer();
        buffer.append(ch, start, length);
        this.getDocumentTextNode(buffer.toString(), parent);
    }

    private void removeOrphanAttributes(IDocumentElementNode node) {
        if (this.fReconciling) {
            IDocumentAttributeNode[] attrs = node.getNodeAttributes();
            int i = 0;
            while (i < attrs.length) {
                if (attrs[i].getNameOffset() == -1) {
                    node.removeDocumentAttribute(attrs[i]);
                }
                ++i;
            }
        }
    }

    private void removeOrphanElements(IDocumentElementNode node) {
        if (this.fReconciling) {
            IDocumentElementNode[] children = node.getChildNodes();
            int i = 0;
            while (i < children.length) {
                if (children[i].getOffset() == -1) {
                    node.removeChildNode(children[i]);
                }
                ++i;
            }
        }
    }

    protected boolean isReconciling() {
        return this.fReconciling;
    }
}

