/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.commons.namespace.ide.ui.internal.core.text;

import com.onpositive.commons.namespace.ide.ui.internal.core.text.DocumentXMLNode;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.IDocumentAttributeNode;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.IDocumentElementNode;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.PDEXMLHelper;

public class DocumentAttributeNode
extends DocumentXMLNode
implements IDocumentAttributeNode {
    private static final long serialVersionUID = 1L;
    private transient IDocumentElementNode fEnclosingElement = null;
    private transient int fNameOffset = -1;
    private transient int fNameLength = -1;
    private transient int fValueOffset = -1;
    private transient int fValueLength = -1;
    private String fValue = null;
    private String fName = null;

    @Override
    public String getAttributeName() {
        return this.fName;
    }

    @Override
    public String getAttributeValue() {
        return this.fValue;
    }

    @Override
    public IDocumentElementNode getEnclosingElement() {
        return this.fEnclosingElement;
    }

    @Override
    public int getNameLength() {
        return this.fNameLength;
    }

    @Override
    public int getNameOffset() {
        return this.fNameOffset;
    }

    @Override
    public int getValueLength() {
        return this.fValueLength;
    }

    @Override
    public int getValueOffset() {
        return this.fValueOffset;
    }

    @Override
    public void setAttributeName(String name) {
        this.fName = name;
    }

    @Override
    public void setAttributeValue(String value) {
        this.fValue = value;
    }

    @Override
    public void setEnclosingElement(IDocumentElementNode node) {
        this.fEnclosingElement = node;
    }

    @Override
    public void setNameLength(int length) {
        this.fNameLength = length;
    }

    @Override
    public void setNameOffset(int offset) {
        this.fNameOffset = offset;
    }

    @Override
    public void setValueLength(int length) {
        this.fValueLength = length;
    }

    @Override
    public void setValueOffset(int offset) {
        this.fValueOffset = offset;
    }

    @Override
    public String write() {
        return this.fName + "=\"" + PDEXMLHelper.getWritableAttributeString(this.fValue) + "\"";
    }

    @Override
    public void reconnect(IDocumentElementNode parent) {
        this.fEnclosingElement = parent;
        this.fNameLength = -1;
        this.fNameOffset = -1;
        this.fValueLength = -1;
        this.fValueOffset = -1;
    }

    @Override
    public int getLength() {
        int len1 = this.getValueOffset() - this.getNameOffset();
        int len2 = this.getValueLength();
        int length = len1 + len2 + 1;
        return length;
    }

    @Override
    public int getOffset() {
        return this.getNameOffset();
    }

    @Override
    public int getXMLType() {
        return 1;
    }
}

