/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.commons.namespace.ide.ui.internal.core.text;

import com.onpositive.commons.namespace.ide.ui.internal.core.text.IEditingModel;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.IModelTextChangeListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.text.IDocument;

public abstract class AbstractEditingModel
extends PlatformObject
implements IEditingModel {
    private final ArrayList fListeners = new ArrayList();
    protected boolean fReconciling;
    protected boolean fInSync = true;
    protected boolean fLoaded = false;
    protected boolean fDisposed;
    protected long fTimestamp;
    private final IDocument fDocument;
    private boolean fDirty;
    private String fCharset;
    private IResource fUnderlyingResource;
    private String fInstallLocation;
    private boolean fStale;

    public AbstractEditingModel(IDocument document, boolean isReconciling) {
        this.fDocument = document;
        this.fReconciling = isReconciling;
    }

    public void dispose() {
        this.fDisposed = true;
        this.fListeners.clear();
    }

    public String getResourceString(String key) {
        if (key == null || key.length() == 0) {
            return "";
        }
        return key;
    }

    public boolean isDisposed() {
        return this.fDisposed;
    }

    public boolean isEditable() {
        return this.fReconciling;
    }

    public boolean isLoaded() {
        return this.fLoaded;
    }

    public void setLoaded(boolean loaded) {
        this.fLoaded = loaded;
    }

    public boolean isInSync() {
        return this.fInSync;
    }

    public boolean isValid() {
        return this.isLoaded();
    }

    public abstract void load(InputStream var1, boolean var2);

    public final long getTimeStamp() {
        return this.fTimestamp;
    }

    public final void load() throws CoreException {
        try {
            IDocument document = this.getDocument();
            if (document != null) {
                this.load(this.getInputStream(document), false);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    public final void reload(InputStream source, boolean outOfSync) throws CoreException {
        this.load(source, outOfSync);
    }

    public boolean isReconcilingModel() {
        return this.fReconciling;
    }

    @Override
    public IDocument getDocument() {
        return this.fDocument;
    }

    @Override
    public final void reconciled(IDocument document) {
        if (this.isReconcilingModel()) {
            try {
                if (this.isStale()) {
                    this.adjustOffsets(document);
                    this.setStale(false);
                } else {
                    this.reload(this.getInputStream(document), false);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (CoreException coreException) {}
            if (this.isDirty()) {
                this.setDirty(false);
            }
        }
    }

    public abstract void adjustOffsets(IDocument var1) throws CoreException;

    protected InputStream getInputStream(IDocument document) throws UnsupportedEncodingException {
        return new BufferedInputStream(new ByteArrayInputStream(document.get().getBytes(this.getCharset())));
    }

    @Override
    public String getCharset() {
        return this.fCharset != null ? this.fCharset : "UTF-8";
    }

    @Override
    public void setCharset(String charset) {
        this.fCharset = charset;
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    public void save(PrintWriter writer) {
    }

    public void setDirty(boolean dirty) {
        this.fDirty = dirty;
    }

    @Override
    public boolean isStale() {
        return this.fStale;
    }

    @Override
    public void setStale(boolean stale) {
        this.fStale = stale;
    }

    public IResource getUnderlyingResource() {
        return this.fUnderlyingResource;
    }

    public void setUnderlyingResource(IResource resource) {
        this.fUnderlyingResource = resource;
    }

    public String getInstallLocation() {
        if (this.fInstallLocation == null && this.fUnderlyingResource != null) {
            IPath path = this.fUnderlyingResource.getProject().getLocation();
            return path != null ? path.addTrailingSeparator().toString() : null;
        }
        return this.fInstallLocation;
    }

    public void setInstallLocation(String location) {
        this.fInstallLocation = location;
    }

    public IModelTextChangeListener getLastTextChangeListener() {
        int i = this.fListeners.size() - 1;
        while (i >= 0) {
            Object obj = this.fListeners.get(i);
            if (obj instanceof IModelTextChangeListener) {
                return (IModelTextChangeListener)obj;
            }
            --i;
        }
        return null;
    }
}

