/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.commons.namespace.ide.ui.editors.xml.model;

import com.onpositive.commons.namespace.ide.ui.editors.xml.model.AttributeModel;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainAttributeNode;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainEditingModelObject;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.ElementModel;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.IProblemReporter;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.ITypeValidator;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.ModelVisitor;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.IDocumentAttributeNode;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.IDocumentElementNode;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.IDocumentRange;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.IDocumentTextNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Stack;
import org.eclipse.core.resources.IProject;

public abstract class DomainValidatorVisitor
implements ModelVisitor {
    private final IProblemReporter reporter;
    private IProject project;
    private Stack<ElementNumberPair> elementStack = new Stack();
    private int number;

    public DomainValidatorVisitor(IProblemReporter reporter, IProject project) {
        this.reporter = reporter;
        this.project = project;
    }

    private void incNumber() {
        ++this.number;
    }

    private int getNumber() {
        return this.number;
    }

    @Override
    public void enterNode(DomainEditingModelObject domainEditingModelObject) {
        String name;
        DomainEditingModelObject parentNode = (DomainEditingModelObject)domainEditingModelObject.getParentNode();
        ElementModel ma = this.elementStack.size() > 0 ? this.elementStack.peek().getElementModel() : null;
        String namespace = domainEditingModelObject.getNamespace();
        String tag = domainEditingModelObject.getLocalName();
        boolean global = domainEditingModelObject.isGlobal();
        ElementModel resolveElement = this.resolveElement(namespace, tag, global, ma, parentNode);
        if (parentNode != null && resolveElement != null && (name = resolveElement.getName()).equals("when")) {
            ElementModel whenDefinition;
            ElementModel flowDefinition = this.resolveElement("http://www.mulesoft.org/schema/mule/core", "flow", false, null, parentNode);
            resolveElement = whenDefinition = this.resolveElement("http://www.mulesoft.org/schema/mule/core", "when", false, flowDefinition, parentNode);
        }
        if (resolveElement == null) {
            if (ma != null && !ma.skipUnknownChildren() && !tag.equals("description") || this.isGlobalUnknown(parentNode, resolveElement == null)) {
                this.incNumber();
            }
        } else {
            this.validateInnerText(domainEditingModelObject, resolveElement);
            if (resolveElement.shouldIncNumber()) {
                this.incNumber();
            }
            LinkedHashMap<IDocumentElementNode, ElementModel> childMap = this.collectChildNodes(domainEditingModelObject, resolveElement);
            resolveElement.validate(domainEditingModelObject, childMap, this.reporter, this.getNumber());
            resolveElement.validateChildren(domainEditingModelObject, childMap, this.reporter, this.getNumber());
            IDocumentAttributeNode[] nodeAttributes = domainEditingModelObject.getNodeAttributes();
            HashSet<AttributeModel> allProperties = resolveElement.getAllProperties();
            if (allProperties == null) {
                return;
            }
            this.validateNodeAttributes(domainEditingModelObject, ma, namespace, tag, resolveElement, nodeAttributes, allProperties);
        }
        this.elementStack.push(new ElementNumberPair(resolveElement, this.getNumber()));
    }

    protected void validateInnerText(DomainEditingModelObject domainEditingModelObject, ElementModel resolveElement) {
        ElementModel.InnerTextValidator textValidator = resolveElement.getTextValidator();
        if (textValidator != null) {
            String text;
            String errorMessage;
            ITypeValidator validator = textValidator.getTypeValidator();
            String nestedTagName = textValidator.getNestedTagName();
            IDocumentTextNode textNode = this.selectTextNode(domainEditingModelObject, nestedTagName);
            if (textNode != null && (errorMessage = validator.validate(this.project, text = textNode.getText(), domainEditingModelObject, null, null)) != null) {
                this.report(4, textNode, errorMessage, this.getNumber());
            }
        }
    }

    protected void validateNodeAttributes(DomainEditingModelObject domainEditingModelObject, ElementModel ma, String namespace, String tag, ElementModel resolveElement, IDocumentAttributeNode[] nodeAttributes, HashSet<AttributeModel> allProperties) {
        HashSet restrictedAttributes = new HashSet();
        String parentShortName = ma != null ? ma.getShortName() : null;
        boolean parentIsInbound = "inbound-endpoint".equals(parentShortName);
        boolean parentIsOutbound = "outbound-endpoint".equals(parentShortName);
        HashMap<String, AttributeModel> required = new HashMap<String, AttributeModel>();
        for (AttributeModel attributeModel : allProperties) {
            if (!attributeModel.isRequired() || !parentIsOutbound && attributeModel.onlyInOutbound() || !parentIsInbound && attributeModel.onlyInInbound()) continue;
            required.put(attributeModel.getName(), attributeModel);
        }
        IDocumentAttributeNode[] iDocumentAttributeNodeArray = nodeAttributes;
        int n = nodeAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentAttributeNode currentAttribute = iDocumentAttributeNodeArray[n2];
            DomainAttributeNode md = (DomainAttributeNode)currentAttribute;
            String attributeName = md.getAttributeName();
            AttributeModel attributeModel = (AttributeModel)required.get(attributeName);
            if (attributeModel != null && (attributeModel.isAcceptsEmptyValue() || md.getAttributeValue() != null && md.getAttributeValue().trim().length() > 0)) {
                required.remove(attributeName);
            }
            String localName = md.getLocalName();
            if (!(attributeName.equals("xmlns") || attributeName.startsWith("xmlns:") || attributeName.startsWith("doc:") || localName.equals("key") && tag.equals("object"))) {
                String name;
                AttributeModel attribute = null;
                if (attributeName.equals("tracking:enable-default-events")) {
                    for (AttributeModel m : allProperties) {
                        name = m.getName();
                        if (!name.equals(attributeName)) continue;
                        attribute = m;
                        break;
                    }
                }
                for (AttributeModel m : allProperties) {
                    name = m.getName();
                    if (name.contains(":") && name.equals(attributeName)) {
                        attribute = m;
                        break;
                    }
                    if (!name.equals(localName)) continue;
                    attribute = m;
                    break;
                }
                if (restrictedAttributes.contains(attribute)) {
                    this.reportUnknown(currentAttribute, "Usage of attribute " + localName + " is restricted for " + tag, this.calculateNumber(resolveElement, ma));
                }
                if (attribute != null) {
                    String errorMessage = null;
                    ITypeValidator validator = attribute.getValidator();
                    if (validator != null) {
                        errorMessage = validator.validate(this.project, currentAttribute.getAttributeValue(), domainEditingModelObject, attribute.getTypeSpecialization(), currentAttribute.getAttributeName());
                    }
                    if (errorMessage != null) {
                        this.reportUnknown(validator.getSeverity(), currentAttribute, errorMessage, this.getNumber());
                    }
                    this.customValudate(currentAttribute, this.project, currentAttribute.getAttributeValue(), domainEditingModelObject, this.calculateNumber(resolveElement, ma));
                }
            }
            ++n2;
        }
        if (!required.isEmpty()) {
            ArrayList missedRequired = new ArrayList(required.keySet());
            Collections.sort(missedRequired);
            for (String attribute : missedRequired) {
                String elementName = this.getElementNameForValidaionMessage(tag, namespace);
                if (!this.checkElementAttributeToRequiredValidation(tag, namespace, attribute)) continue;
                this.report(4, domainEditingModelObject, "Required attribute " + attribute + " is not defined in " + elementName, this.calculateNumber(resolveElement, ma));
            }
        }
    }

    private boolean isGlobalUnknown(DomainEditingModelObject parentNode, boolean unknown) {
        return parentNode == null || "mule".equals(parentNode.getLocalName()) && unknown;
    }

    private int calculateNumber(ElementModel resolveElement, ElementModel parentElement) {
        if (resolveElement.reportOnParent() && parentElement != null) {
            int i = 0;
            while (i < this.elementStack.size()) {
                ElementNumberPair elementNumberPair = (ElementNumberPair)this.elementStack.elementAt(i);
                ElementModel elementAt = elementNumberPair.getElementModel();
                if (parentElement.equals(elementAt)) {
                    return elementNumberPair.getNumber();
                }
                ++i;
            }
        }
        return this.getNumber();
    }

    private LinkedHashMap<IDocumentElementNode, ElementModel> collectChildNodes(DomainEditingModelObject parentNode, ElementModel ma) {
        IDocumentElementNode[] childNodes = parentNode.getChildNodes();
        LinkedHashMap<IDocumentElementNode, ElementModel> childMap = new LinkedHashMap<IDocumentElementNode, ElementModel>();
        IDocumentElementNode[] iDocumentElementNodeArray = childNodes;
        int n = childNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentElementNode m = iDocumentElementNodeArray[n2];
            DomainEditingModelObject mo = (DomainEditingModelObject)m;
            ElementModel mq = this.resolveElement(mo.getNamespace(), mo.getLocalName(), mo.isGlobal(), ma, parentNode);
            childMap.put(m, mq);
            ++n2;
        }
        return childMap;
    }

    private IDocumentTextNode selectTextNode(DomainEditingModelObject domObject, String nestedTagName) {
        if (nestedTagName == null) {
            return domObject.getTextNode();
        }
        IDocumentElementNode[] childNodes = domObject.getChildNodes();
        return this.findChildNode(nestedTagName, childNodes);
    }

    private IDocumentTextNode findChildNode(String nestedTagName, IDocumentElementNode[] childNodes) {
        String suffix = ":" + nestedTagName;
        IDocumentElementNode[] iDocumentElementNodeArray = childNodes;
        int n = childNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentElementNode childNode = iDocumentElementNodeArray[n2];
            if (childNode.getXMLTagName().endsWith(suffix)) {
                return childNode.getTextNode();
            }
            ++n2;
        }
        return null;
    }

    protected String getElementNameForValidaionMessage(String tag, String namespace) {
        return tag;
    }

    protected boolean checkElementAttributeToRequiredValidation(String tag, String namespace, String attributeName) {
        return true;
    }

    protected void customValudate(IDocumentAttributeNode currentAttribute, IProject project2, String attributeValue, DomainEditingModelObject domainEditingModelObject, int number) {
    }

    protected abstract ElementModel resolveElement(String var1, String var2, boolean var3, ElementModel var4, DomainEditingModelObject var5);

    protected abstract String validateElementInnerText(DomainEditingModelObject var1, String var2);

    private void reportUnknown(IDocumentRange range, String name, int number) {
        this.reporter.accept(2, range.getOffset(), range.getOffset() + range.getLength(), name, number);
    }

    private void reportUnknown(int severity, IDocumentRange range, String name, int number) {
        this.reporter.accept(severity, range.getOffset(), range.getOffset() + range.getLength(), name, number);
    }

    @Override
    public void exitNode(DomainEditingModelObject domainEditingModelObject) {
        if (this.elementStack.size() > 0) {
            this.elementStack.pop();
        }
    }

    @Override
    public void visitAttribute(DomainAttributeNode na) {
    }

    void report(int severity, IDocumentRange range, String message, int number) {
        String string = range.toString();
        int indexOfNewLine = string.indexOf(10);
        int start = range.getOffset();
        int end = start + (string.startsWith("<") && indexOfNewLine != -1 ? indexOfNewLine : range.getLength());
        this.reporter.accept(severity, start, end, message, number);
    }

    private static class ElementNumberPair {
        private int number;
        private ElementModel elementModel;

        public ElementNumberPair(ElementModel model, int number) {
            this.elementModel = model;
            this.number = number;
        }

        public ElementModel getElementModel() {
            return this.elementModel;
        }

        public int getNumber() {
            return this.number;
        }
    }
}

