/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.transaction;

import java.util.Objects;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.runtime.transaction.ExtensionTransactionKey;
import org.mule.runtime.module.extension.internal.runtime.transaction.ExtensionTransactionalResource;
import org.mule.runtime.module.extension.internal.runtime.transaction.TransactionalConnectionHandler;
import org.mule.runtime.module.extension.internal.runtime.transaction.XAExtensionTransactionalResource;
import org.mule.runtime.module.extension.internal.util.ReconnectionUtils;
import org.mule.sdk.api.connectivity.TransactionalConnection;
import org.mule.sdk.api.connectivity.XATransactionalConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionBindingDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionBindingDelegate.class);
    private final ExtensionModel extensionModel;
    private final ComponentModel componentModel;

    public TransactionBindingDelegate(ExtensionModel extensionModel, ComponentModel componentModel) {
        this.extensionModel = extensionModel;
        this.componentModel = componentModel;
    }

    public <T extends TransactionalConnection> ConnectionHandler<T> getBoundResource(boolean lazyConnections, final ExtensionTransactionKey txKey, final ConnectionSupplier<ConnectionHandler<T>> connectionHandlerSupplier) throws ConnectionException, TransactionException {
        final Transaction currentTx = TransactionCoordination.getInstance().getTransaction();
        if (currentTx == null) {
            return connectionHandlerSupplier.get();
        }
        if (currentTx.hasResource((Object)txKey)) {
            return new TransactionalConnectionHandler((ExtensionTransactionalResource)currentTx.getResource((Object)txKey));
        }
        if (lazyConnections) {
            return new ConnectionHandler<T>(){
                private final LazyValue<ConnectionHandler<T>> boundResource = new LazyValue(() -> {
                    try {
                        return TransactionBindingDelegate.this.bindResource(txKey, connectionHandlerSupplier, currentTx);
                    }
                    catch (ConnectionException e) {
                        throw new MuleRuntimeException((Throwable)new TransactionException(I18nMessageFactory.createStaticMessage((String)("Cannot establish connection for the transaction: " + e.getMessage())), (Throwable)e));
                    }
                    catch (TransactionException e) {
                        throw new MuleRuntimeException((Throwable)e);
                    }
                });

                public T getConnection() throws ConnectionException {
                    return (TransactionalConnection)((ConnectionHandler)this.boundResource.get()).getConnection();
                }

                public void release() {
                    this.boundResource.ifComputed(ConnectionHandler::release);
                }

                public void invalidate() {
                    this.boundResource.ifComputed(ConnectionHandler::invalidate);
                }
            };
        }
        return this.bindResource(txKey, connectionHandlerSupplier, currentTx);
    }

    private <T extends TransactionalConnection> ConnectionHandler<T> bindResource(ExtensionTransactionKey txKey, ConnectionSupplier<ConnectionHandler<T>> connectionHandlerSupplier, Transaction currentTx) throws ConnectionException, TransactionException {
        ConnectionHandler connectionHandler = connectionHandlerSupplier.get();
        TransactionalConnection connection = Objects.requireNonNull((TransactionalConnection)connectionHandler.getConnection(), () -> String.format("connection from '%s' (%s '%s' of extension '%s') is null", connectionHandler, NameUtils.getComponentModelTypeName((ParameterizedModel)this.componentModel), this.componentModel.getName(), this.extensionModel.getName()));
        ExtensionTransactionalResource<T> txResource = this.createTransactionalResource(currentTx, connectionHandler, connection);
        boolean bound = false;
        try {
            if (currentTx.supports((Object)txKey, txResource)) {
                currentTx.bindResource((Object)txKey, txResource);
                bound = true;
                TransactionalConnectionHandler<T> transactionalConnectionHandler = new TransactionalConnectionHandler<T>(txResource);
                return transactionalConnectionHandler;
            }
            try {
                throw new TransactionException(I18nMessageFactory.createStaticMessage((String)String.format("%s '%s' of extension '%s' uses a transactional connection '%s', but the current transaction doesn't support it and could not be bound", NameUtils.getComponentModelTypeName((ParameterizedModel)this.componentModel), this.componentModel.getName(), this.extensionModel.getName(), connection.getClass().getName())));
            }
            catch (Exception e) {
                if (ReconnectionUtils.extractConnectionException(e).isPresent()) {
                    connectionHandler.invalidate();
                }
                throw e;
            }
        }
        finally {
            if (!bound) {
                try {
                    connectionHandler.release();
                }
                catch (Exception e) {
                    String msg = "Ignored '" + e.getClass().getName() + ": " + e.getMessage() + "' during connection release";
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.warn(msg, (Throwable)e);
                    }
                    LOGGER.warn(msg);
                }
            }
        }
    }

    private <T extends TransactionalConnection> ExtensionTransactionalResource<T> createTransactionalResource(Transaction currentTx, ConnectionHandler<T> connectionHandler, Object connection) {
        ExtensionTransactionalResource<TransactionalConnection> extensionTransactionalResource;
        if (connection instanceof XATransactionalConnection) {
            XATransactionalConnection xaConn = (XATransactionalConnection)connection;
            extensionTransactionalResource = new XAExtensionTransactionalResource<XATransactionalConnection>(xaConn, connectionHandler, currentTx);
        } else {
            extensionTransactionalResource = new ExtensionTransactionalResource<TransactionalConnection>((TransactionalConnection)connection, connectionHandler, currentTx);
        }
        return extensionTransactionalResource;
    }

    @FunctionalInterface
    public static interface ConnectionSupplier<T> {
        public T get() throws ConnectionException;
    }
}

