/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.util.message.stream.UnclosableCursorStream;
import org.mule.runtime.extension.api.declaration.type.annotation.LiteralTypeAnnotation;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.loader.java.property.stackabletypes.StackedTypesModelProperty;
import org.mule.runtime.module.extension.internal.runtime.parameter.PropagateAllDistributedTraceContextManager;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionBasedParameterResolverValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionTypedValueValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticLiteralValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeValueResolverWrapper;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.tracer.api.EventTracer;
import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;

public class ResolverUtils {
    private ResolverUtils() {
    }

    static <T> ValueResolver<T> getFieldDefaultValueValueResolver(ObjectFieldType field, Injector injector, ExtendedExpressionManager expressionManager, TransformationService transformationService) {
        Optional defaultValue = MetadataTypeUtils.getDefaultValue((MetadataType)field);
        Preconditions.checkArgument((boolean)defaultValue.isPresent(), (String)("No default value available for field :" + String.valueOf(field.getKey().getName())));
        return ResolverUtils.getExpressionBasedValueResolver((String)defaultValue.orElseThrow(), field.getValue(), injector, expressionManager, transformationService);
    }

    static <T> ValueResolver<T> getFieldDefaultValueValueResolver(MetadataType fieldType, String defaultValue, Injector injector, ExtendedExpressionManager expressionManager, TransformationService transformationService) {
        return ResolverUtils.getExpressionBasedValueResolver(defaultValue, fieldType, injector, expressionManager, transformationService);
    }

    public static <T> ValueResolver<T> getExpressionBasedValueResolver(String expression, MetadataType metadataType, Injector injector, ExtendedExpressionManager expressionManager, TransformationService transformationService) {
        return ResolverUtils.getExpressionBasedValueResolver(expression, () -> IntrospectionUtils.isTypedValue(metadataType), () -> IntrospectionUtils.isParameterResolver(metadataType), Optional.empty(), metadataType, injector, expressionManager, transformationService);
    }

    static ValueResolver<?> getExpressionBasedValueResolver(String expression, ParameterModel operationModel, Injector injector, ExtendedExpressionManager expressionManager, TransformationService transformationService) {
        MetadataType metadataType = operationModel.getType();
        return ResolverUtils.getExpressionBasedValueResolver(expression, () -> IntrospectionUtils.isTypedValue(metadataType), () -> IntrospectionUtils.isParameterResolver(metadataType), StackedTypesModelProperty.getStackedTypesModelProperty(operationModel.getModelProperties()), metadataType, injector, expressionManager, transformationService);
    }

    static ValueResolver<?> getDefaultValueResolver(ParameterModel parameter, Injector injector, ExtendedExpressionManager expressionManager, TransformationService transformationService) {
        Object defaultValue = parameter.getDefaultValue();
        if (defaultValue instanceof String) {
            String stringDefaultValue = (String)defaultValue;
            return ResolverUtils.getExpressionBasedValueResolver(stringDefaultValue, parameter, injector, expressionManager, transformationService);
        }
        if (defaultValue != null) {
            return new StaticValueResolver<Object>(defaultValue);
        }
        return null;
    }

    public static <T> T resolveRecursively(ValueResolver<T> valueResolver, ValueResolvingContext resolvingContext) throws MuleException {
        T resolve = valueResolver.resolve(resolvingContext);
        if (resolve instanceof ValueResolver) {
            resolve = ResolverUtils.resolveRecursively((ValueResolver)resolve, resolvingContext);
        }
        return resolve;
    }

    public static <T> T resolveValue(ValueResolver<T> resolver, ValueResolvingContext context) throws MuleException {
        T value = ResolverUtils.resolveRecursively(resolver, context);
        if (context == null || context.resolveCursors()) {
            return (T)ResolverUtils.resolveCursor(value);
        }
        return value;
    }

    public static Object resolveCursor(Object value) {
        if (value instanceof CursorProvider) {
            return ((CursorProvider)value).openCursor();
        }
        if (value instanceof TypedValue) {
            return ResolverUtils.resolveCursor((TypedValue)value);
        }
        return value;
    }

    public static TypedValue<?> resolveCursor(TypedValue<?> typedValue) {
        Object objectValue = typedValue.getValue();
        if (objectValue instanceof CursorProvider) {
            Cursor cursor = ((CursorProvider)objectValue).openCursor();
            return ResolverUtils.typedValue(typedValue, cursor);
        }
        return typedValue;
    }

    public static Object resolveCursorAsUnclosable(Object value) {
        if (value instanceof CursorProvider) {
            return ResolverUtils.resolveCursorProviderAsUnclosable((CursorProvider)value);
        }
        if (value instanceof TypedValue) {
            return ResolverUtils.resolveCursorAsUnclosable((TypedValue)value);
        }
        if (value instanceof CursorStream) {
            return new UnclosableCursorStream((CursorStream)value);
        }
        return value;
    }

    public static TypedValue<?> resolveCursorAsUnclosable(TypedValue<?> typedValue) {
        Object objectValue = typedValue.getValue();
        if (objectValue instanceof CursorProvider) {
            Cursor cursor = ResolverUtils.resolveCursorProviderAsUnclosable((CursorProvider)objectValue);
            return ResolverUtils.typedValue(typedValue, cursor);
        }
        if (objectValue instanceof CursorStream) {
            return new TypedValue((Object)new UnclosableCursorStream((CursorStream)objectValue), typedValue.getDataType(), typedValue.getByteLength());
        }
        return typedValue;
    }

    public static Object typedValueAsUnclosable(Object value) {
        if (value instanceof TypedValue) {
            return ResolverUtils.typedValueAsUnclosable((TypedValue)value);
        }
        if (value instanceof CursorStream) {
            return new UnclosableCursorStream((CursorStream)value);
        }
        return value;
    }

    public static TypedValue<?> typedValueAsUnclosable(TypedValue<?> typedValue) {
        Object objectValue = typedValue.getValue();
        if (objectValue instanceof CursorStream) {
            return new TypedValue((Object)new UnclosableCursorStream((CursorStream)objectValue), typedValue.getDataType(), typedValue.getByteLength());
        }
        return typedValue;
    }

    public static DistributedTraceContextManager resolveDistributedTraceContextManager(CoreEvent coreEvent, EventTracer<CoreEvent> coreEventTracer) {
        return new PropagateAllDistributedTraceContextManager(coreEvent, coreEventTracer);
    }

    public static Map<String, String> resolveDistributedTraceContext(CoreEvent event, EventTracer<CoreEvent> coreEventTracer) {
        return coreEventTracer.getDistributedTraceContextMap((Event)event);
    }

    private static Cursor resolveCursorProviderAsUnclosable(CursorProvider<?> cursorProvider) {
        Cursor cursor = cursorProvider.openCursor();
        if (cursor instanceof CursorStream) {
            return new UnclosableCursorStream((CursorStream)cursor);
        }
        return cursor;
    }

    private static TypedValue<?> typedValue(TypedValue<?> typedValue, Object value) {
        return new TypedValue(value, DataType.builder().type(value != null ? value.getClass() : Object.class).mediaType(typedValue.getDataType().getMediaType()).build(), typedValue.getByteLength());
    }

    private static <T> ValueResolver<T> getExpressionBasedValueResolver(String expression, BooleanSupplier isTypedValue, BooleanSupplier isParameterResolver, Optional<StackedTypesModelProperty> stackedTypesModelProperty, MetadataType type, Injector injector, ExtendedExpressionManager expressionManager, TransformationService transformationService) {
        try {
            ValueResolver resolver;
            Class<Object> cls = ExtensionMetadataTypeUtils.getType((MetadataType)type).orElse(Object.class);
            if (stackedTypesModelProperty.isPresent()) {
                resolver = stackedTypesModelProperty.get().getValueResolverFactory().getExpressionBasedValueResolver(expression, cls);
            } else if (isTypedValue.getAsBoolean()) {
                ExpressionTypedValueValueResolver<Object> valueResolver = new ExpressionTypedValueValueResolver<Object>(expression, cls);
                valueResolver.setTransformationService(transformationService);
                valueResolver.setExtendedExpressionManager(expressionManager);
                resolver = valueResolver;
            } else if (isParameterResolver.getAsBoolean()) {
                ExpressionBasedParameterResolverValueResolver<Object> valueResolver = new ExpressionBasedParameterResolverValueResolver<Object>(expression, cls, IntrospectionUtils.toDataType(type));
                valueResolver.setTransformationService(transformationService);
                valueResolver.setExtendedExpressionManager(expressionManager);
                resolver = valueResolver;
            } else if (expressionManager.isExpression(expression)) {
                if (type.getAnnotation(LiteralTypeAnnotation.class).isPresent()) {
                    resolver = new StaticLiteralValueResolver<Object>(expression, cls);
                } else {
                    TypeSafeExpressionValueResolver<Object> valueResolver = new TypeSafeExpressionValueResolver<Object>(expression, cls, IntrospectionUtils.toDataType(type));
                    valueResolver.setTransformationService(transformationService);
                    valueResolver.setExtendedExpressionManager(expressionManager);
                    resolver = valueResolver;
                }
            } else {
                TypeSafeValueResolverWrapper<Object> typeSafeValueResolverWrapper = new TypeSafeValueResolverWrapper<Object>(new StaticValueResolver<String>(expression), cls);
                typeSafeValueResolverWrapper.setTransformationService(transformationService);
                resolver = typeSafeValueResolverWrapper;
            }
            LifecycleUtils.initialiseIfNeeded((Object)resolver, (Injector)injector);
            return resolver;
        }
        catch (InitialisationException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }
}

