/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.util.function.Consumer;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ExtensionsOAuthUtils;
import org.mule.runtime.module.extension.internal.runtime.streaming.CursorResetHandler;

public class RefreshOAuthTokenExecutorCallbackDecorator
implements CompletableComponentExecutor.ExecutorCallback {
    private final CompletableComponentExecutor.ExecutorCallback delegate;
    private final ExecutionContextAdapter operationContext;
    private final Consumer<CompletableComponentExecutor.ExecutorCallback> retryCommand;
    private int attempts;

    public RefreshOAuthTokenExecutorCallbackDecorator(CompletableComponentExecutor.ExecutorCallback delegate, ExecutionContextAdapter operationContext, Consumer<CompletableComponentExecutor.ExecutorCallback> retryCommand) {
        this.delegate = delegate;
        this.operationContext = operationContext;
        this.retryCommand = retryCommand;
        this.attempts = 0;
    }

    public void complete(Object value) {
        this.delegate.complete(value);
    }

    public void error(Throwable e) {
        try {
            if (++this.attempts <= 2 && ExtensionsOAuthUtils.refreshTokenIfNecessary(this.operationContext, e)) {
                this.resetCursors(this.operationContext);
                this.retryCommand.accept(this);
            } else {
                this.delegate.error(e);
            }
        }
        catch (Exception refreshException) {
            this.delegate.error((Throwable)refreshException);
        }
    }

    private void resetCursors(ExecutionContextAdapter<OperationModel> operationContext) {
        CursorResetHandler cursorResetHandler = (CursorResetHandler)operationContext.getVariable("CURSOR_RESET_HANDLER");
        if (cursorResetHandler != null) {
            cursorResetHandler.resetCursors();
        }
    }
}

