/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ocs;

import jakarta.inject.Inject;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.mule.oauth.client.api.state.ResourceOwnerOAuthContext;
import org.mule.runtime.api.config.ArtifactEncoding;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.connection.PoolingConnectionProvider;
import org.mule.runtime.api.connection.PoolingListener;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.retry.ReconnectionConfig;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.internal.connection.ConnectionUtils;
import org.mule.runtime.core.internal.event.NullEventFactory;
import org.mule.runtime.core.internal.util.ClassUtils;
import org.mule.runtime.core.internal.util.FunctionalUtils;
import org.mule.runtime.core.internal.util.InjectionUtils;
import org.mule.runtime.core.internal.util.func.Once;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantTypeVisitor;
import org.mule.runtime.extension.api.connectivity.oauth.PlatformManagedOAuthGrantType;
import org.mule.runtime.extension.api.exception.IllegalConnectionProviderModelDefinitionException;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.runtime.config.DefaultConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ExtensionsOAuthUtils;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthConnectionProviderWrapper;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ocs.PlatformAuthorizationCodeStateAdapter;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ocs.PlatformClientCredentialsOAuthStateAdapter;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ocs.PlatformManagedOAuthConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ocs.PlatformManagedOAuthHandler;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetUtils;
import org.mule.runtime.module.extension.internal.util.FieldSetter;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.oauth.api.PlatformManagedConnectionDescriptor;
import org.mule.runtime.oauth.api.PlatformManagedOAuthDancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformManagedOAuthConnectionProvider<C>
implements OAuthConnectionProviderWrapper<C>,
PoolingConnectionProvider<C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlatformManagedOAuthConnectionProvider.class);
    private final PlatformManagedOAuthConfig oauthConfig;
    private final PlatformManagedOAuthHandler oauthHandler;
    private final PoolingProfile poolingProfile;
    private final ReconnectionConfig reconnectionConfig;
    private final Map<Field, String> callbackValues;
    private final Once.RunOnce dance = Once.of(this::updateOAuthState);
    @Inject
    private MuleContext muleContext;
    @Inject
    private ExtendedExpressionManager expressionManager;
    @Inject
    private ArtifactEncoding artifactEncoding;
    private PlatformManagedOAuthDancer dancer;
    private ConnectionProvider<C> delegate;
    private ConnectionProvider<C> unwrappedDelegate;
    private Object delegateForInjection;
    private FieldSetter<Object, Object> oauthStateFieldSetter;
    private PlatformManagedConnectionDescriptor descriptor;
    private PoolingListener<C> delegatePoolingListener;

    public PlatformManagedOAuthConnectionProvider(PlatformManagedOAuthConfig oauthConfig, PlatformManagedOAuthHandler oauthHandler, ReconnectionConfig reconnectionConfig, PoolingProfile poolingProfile) {
        this.oauthConfig = oauthConfig;
        this.oauthHandler = oauthHandler;
        this.reconnectionConfig = reconnectionConfig;
        this.poolingProfile = poolingProfile;
        this.callbackValues = ExtensionsOAuthUtils.getCallbackValuesExtractors(oauthConfig.getDelegateConnectionProviderModel());
    }

    public C connect() throws ConnectionException {
        this.dance.runOnce();
        return (C)ConnectionUtils.connect(this.getDelegate());
    }

    public ConnectionValidationResult validate(C connection) {
        return ExtensionsOAuthUtils.validateOAuthConnection(this, connection, this.getContext());
    }

    public void disconnect(C connection) {
        this.getDelegate().disconnect(connection);
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.getRetryPolicyTemplate(), (Injector)this.muleContext.getInjector());
    }

    public void start() throws MuleException {
        this.dancer = this.oauthHandler.register(this.oauthConfig);
        try {
            this.descriptor = this.fetchConnectionDescriptor();
            this.delegate = this.createDelegate(this.descriptor);
            this.unwrappedDelegate = ConnectionUtils.unwrap(this.delegate);
            this.delegateForInjection = InjectionUtils.getInjectionTarget(this.unwrappedDelegate);
            this.delegatePoolingListener = this.getDelegatePoolingListener();
            this.initialiseDelegate();
            LifecycleUtils.startIfNeeded((Object)this.getRetryPolicyTemplate());
        }
        catch (MuleException e) {
            LifecycleUtils.stopIfNeeded((Object)this.dancer);
            LifecycleUtils.disposeIfNeeded((Object)this.dancer, (Logger)LOGGER);
            throw e;
        }
    }

    public void stop() throws MuleException {
        try {
            LifecycleUtils.stopIfNeeded((Object)this.dancer);
        }
        finally {
            FunctionalUtils.safely(() -> LifecycleUtils.stopIfNeeded((Object)this.getRetryPolicyTemplate()), e -> LOGGER.error(String.format("Error stopping %s for Platform Connection %s", RetryPolicyTemplate.class.getName(), this.descriptor.getDisplayName()), (Throwable)e));
        }
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.dancer, (Logger)LOGGER);
        LifecycleUtils.disposeIfNeeded((Object)this.getRetryPolicyTemplate(), (Logger)LOGGER);
    }

    protected void initialiseDelegate() throws MuleException {
        LifecycleUtils.initialiseIfNeeded(this.delegate, (boolean)true, (MuleContext)this.muleContext);
        try {
            LifecycleUtils.startIfNeeded(this.delegate);
        }
        catch (MuleException e) {
            LifecycleUtils.disposeIfNeeded(this.delegate, (Logger)LOGGER);
            throw e;
        }
        this.oauthStateFieldSetter = this.getOAuthStateSetter(this.delegateForInjection);
    }

    protected ConnectionProvider<C> createDelegate(PlatformManagedConnectionDescriptor descriptor) throws MuleException {
        Class connectionProviderDelegateClass = MuleExtensionUtils.getImplementingType((EnrichableModel)this.oauthConfig.getDelegateConnectionProviderModel()).orElseThrow(() -> new IllegalStateException("Delegate connection provider must have an implementing type."));
        return (ConnectionProvider)ClassUtils.withContextClassLoader((ClassLoader)MuleExtensionUtils.getClassLoader(this.oauthConfig.getExtensionModel()), () -> {
            ResolverSet delegateResolverSet = this.getResolverSetFromParameterValues(descriptor.getParameters());
            DefaultConnectionProviderObjectBuilder builder = new DefaultConnectionProviderObjectBuilder(connectionProviderDelegateClass, this.oauthConfig.getDelegateConnectionProviderModel(), delegateResolverSet, this.poolingProfile, this.reconnectionConfig, this.oauthConfig.getExtensionModel(), (ExpressionManager)this.expressionManager, this.muleContext.getErrorTypeRepository(), this.artifactEncoding, this.muleContext.getInjector(), this.muleContext.getExecutionClassLoader());
            builder.setOwnerConfigName(this.oauthConfig.getOwnerConfigName());
            CoreEvent event = NullEventFactory.getNullEvent();
            ValueResolvingContext ctx = null;
            try {
                ctx = ValueResolvingContext.builder(event, (ExpressionManager)this.expressionManager).build();
                Object object = ((Pair)builder.build(ctx)).getFirst();
                return object;
            }
            finally {
                ((BaseEventContext)event.getContext()).success();
                if (ctx != null) {
                    ctx.close();
                }
            }
        }, MuleException.class, e -> e);
    }

    private ResolverSet getResolverSetFromParameterValues(Map<String, Object> parameters) throws MuleException {
        return this.getResolverSetForParameterizedModel((ParameterizedModel)this.oauthConfig.getDelegateConnectionProviderModel(), parameters);
    }

    private ResolverSet getResolverSetForParameterizedModel(ParameterizedModel parameterizedModel, Map<String, Object> parameters) throws MuleException {
        return ResolverSetUtils.getResolverSetFromStaticValues(parameterizedModel, parameters, this.muleContext, false, new ReflectionCache(), this.expressionManager, this.toString(), this.artifactEncoding);
    }

    private PlatformManagedConnectionDescriptor fetchConnectionDescriptor() throws MuleException {
        try {
            return (PlatformManagedConnectionDescriptor)this.dancer.getConnectionDescriptor().get();
        }
        catch (ExecutionException e) {
            throw this.newConnectionDescriptorException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.newConnectionDescriptorException(e);
        }
    }

    private MuleException newConnectionDescriptorException(Throwable e) {
        return new DefaultMuleException("Could not obtain descriptor for Platform Managed OAuth Connection " + this.oauthConfig.getConnectionUri(), e);
    }

    private FieldSetter<Object, Object> getOAuthStateSetter(final Object target) {
        final Reference setter = new Reference();
        this.oauthConfig.getDelegateGrantType().accept(new OAuthGrantTypeVisitor(){

            public void visit(AuthorizationCodeGrantType grantType) {
                setter.set(ExtensionsOAuthUtils.getOAuthStateSetter(target, ExtensionsOAuthUtils.AUTHORIZATION_CODE_STATE_INTERFACES, (OAuthGrantType)PlatformManagedOAuthConnectionProvider.this.oauthConfig.getGrantType()));
            }

            public void visit(ClientCredentialsGrantType grantType) {
                setter.set(ExtensionsOAuthUtils.getOAuthStateSetter(target, ExtensionsOAuthUtils.CLIENT_CREDENTIALS_STATE_INTERFACES, (OAuthGrantType)PlatformManagedOAuthConnectionProvider.this.oauthConfig.getGrantType()));
            }

            public void visit(PlatformManagedOAuthGrantType grantType) {
                throw PlatformManagedOAuthConnectionProvider.this.illegalDelegateException();
            }
        });
        return (FieldSetter)setter.get();
    }

    private IllegalConnectionProviderModelDefinitionException illegalDelegateException() {
        return new IllegalConnectionProviderModelDefinitionException(String.format("Configuration '%s' cannot have a platform managed OAuth connection that delegates into itself", this.oauthConfig.getOwnerConfigName()));
    }

    @Override
    public void refreshToken(String resourceOwnerId) {
        this.oauthHandler.refreshToken(this.oauthConfig);
    }

    @Override
    public void invalidate(String resourceOwnerId) {
        this.oauthHandler.invalidate(this.oauthConfig);
    }

    @Override
    public OAuthGrantType getGrantType() {
        return this.oauthConfig.getGrantType();
    }

    private void updateOAuthState() {
        final Consumer<ResourceOwnerOAuthContext> onUpdate = context -> ExtensionsOAuthUtils.updateOAuthParameters(this.delegateForInjection, this.callbackValues, context);
        this.oauthConfig.getDelegateGrantType().accept(new OAuthGrantTypeVisitor(){

            public void visit(AuthorizationCodeGrantType grantType) {
                PlatformManagedOAuthConnectionProvider.this.oauthStateFieldSetter.set(PlatformManagedOAuthConnectionProvider.this.delegateForInjection, new PlatformAuthorizationCodeStateAdapter(PlatformManagedOAuthConnectionProvider.this.dancer, PlatformManagedOAuthConnectionProvider.this.descriptor, onUpdate));
            }

            public void visit(ClientCredentialsGrantType grantType) {
                PlatformManagedOAuthConnectionProvider.this.oauthStateFieldSetter.set(PlatformManagedOAuthConnectionProvider.this.delegateForInjection, new PlatformClientCredentialsOAuthStateAdapter(PlatformManagedOAuthConnectionProvider.this.dancer, onUpdate));
            }

            public void visit(PlatformManagedOAuthGrantType grantType) {
                throw PlatformManagedOAuthConnectionProvider.this.illegalDelegateException();
            }
        });
        onUpdate.accept(this.oauthHandler.getOAuthContext(this.oauthConfig));
    }

    private ResourceOwnerOAuthContext getContext() {
        return this.oauthHandler.getOAuthContext(this.oauthConfig);
    }

    public Optional<PoolingProfile> getPoolingProfile() {
        return Optional.ofNullable(this.poolingProfile);
    }

    public Optional<ReconnectionConfig> getReconnectionConfig() {
        return Optional.ofNullable(this.reconnectionConfig);
    }

    public Optional<String> getOwnerConfigName() {
        return Optional.ofNullable(this.oauthConfig.getOwnerConfigName());
    }

    @Override
    public String getResourceOwnerId() {
        return this.getContext().getResourceOwnerId();
    }

    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return ConnectionUtils.getRetryPolicyTemplate(this.getReconnectionConfig());
    }

    public ConnectionProvider<C> getDelegate() {
        return Objects.requireNonNull(this.delegate, "ConnectionProvider has not been started yet");
    }

    public ConnectionManagementType getConnectionManagementType() {
        return this.oauthConfig.getDelegateConnectionProviderModel().getConnectionManagementType();
    }

    public boolean supportsXa() {
        return this.oauthConfig.getDelegateConnectionProviderModel().supportsXa();
    }

    public void onBorrow(C connection) {
        this.delegatePoolingListener.onBorrow(connection);
    }

    public void onReturn(C connection) {
        this.delegatePoolingListener.onReturn(connection);
    }

    protected PoolingListener<C> getDelegatePoolingListener() {
        if (this.unwrappedDelegate instanceof PoolingListener) {
            return new PoolingListener<C>(){

                public void onBorrow(C connection) {
                    ((PoolingListener)PlatformManagedOAuthConnectionProvider.this.unwrappedDelegate).onBorrow(connection);
                }

                public void onReturn(C connection) {
                    ((PoolingListener)PlatformManagedOAuthConnectionProvider.this.unwrappedDelegate).onReturn(connection);
                }
            };
        }
        return new PoolingListener<C>(){};
    }
}

