/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.mule.oauth.client.api.ClientCredentialsOAuthDancer;
import org.mule.oauth.client.api.listener.ClientCredentialsListener;
import org.mule.oauth.client.api.state.ResourceOwnerOAuthContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsGrantType;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ExtensionsOAuthUtils;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthHandler;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials.ClientCredentialsConfig;
import org.mule.runtime.module.extension.internal.store.LazyObjectStoreToMapAdapter;
import org.mule.runtime.oauth.api.OAuthService;
import org.mule.runtime.oauth.api.builder.OAuthClientCredentialsDancerBuilder;

public class ClientCredentialsOAuthHandler
extends OAuthHandler<ClientCredentialsOAuthDancer> {
    public ClientCredentialsOAuthDancer register(ClientCredentialsConfig config) {
        return this.register(config, Collections.emptyList());
    }

    public ClientCredentialsOAuthDancer register(ClientCredentialsConfig config, List<ClientCredentialsListener> listeners) {
        return (ClientCredentialsOAuthDancer)this.dancers.computeIfAbsent(config.getConfigIdentifier(), k -> this.createDancer(config, listeners));
    }

    public void refreshToken(ClientCredentialsConfig config) {
        ClientCredentialsOAuthDancer dancer = (ClientCredentialsOAuthDancer)this.dancers.get(config.getConfigIdentifier());
        try {
            dancer.refreshToken().get();
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Could not refresh token for config '%s'", config.getOwnerConfigName())), (Throwable)e);
        }
    }

    public ResourceOwnerOAuthContext getOAuthContext(ClientCredentialsConfig config) {
        ClientCredentialsOAuthDancer dancer = (ClientCredentialsOAuthDancer)this.dancers.get(config.getConfigIdentifier());
        if (dancer == null) {
            throw new IllegalStateException(String.format("Client Credentials dancer for config '%s' not yet registered", config.getOwnerConfigName()));
        }
        ResourceOwnerOAuthContext contextForResourceOwner = dancer.getContext();
        if (contextForResourceOwner == null || contextForResourceOwner.getAccessToken() == null) {
            try {
                dancer.accessToken().get();
                contextForResourceOwner = dancer.getContext();
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Could not obtain access token for config '%s'", config.getOwnerConfigName())), (Throwable)e);
            }
        }
        return contextForResourceOwner;
    }

    public void invalidate(ClientCredentialsConfig config) {
        ClientCredentialsOAuthDancer dancer = (ClientCredentialsOAuthDancer)this.dancers.get(config.getConfigIdentifier());
        if (dancer == null) {
            return;
        }
        dancer.invalidateContext();
    }

    private ClientCredentialsOAuthDancer createDancer(ClientCredentialsConfig config, List<ClientCredentialsListener> listeners) throws MuleException {
        Preconditions.checkArgument((listeners != null ? 1 : 0) != 0, (String)"listeners cannot be null");
        OAuthClientCredentialsDancerBuilder dancerBuilder = ((OAuthService)this.getOAuthService().get()).clientCredentialsGrantTypeDancerBuilder(this.lockFactory, new LazyObjectStoreToMapAdapter(() -> this.objectStoreLocator.apply(config)), this.expressionEvaluator);
        ClientCredentialsGrantType grantType = config.getGrantType();
        dancerBuilder.name(config.getOwnerConfigName()).encoding(this.artifactEncoding.getDefaultEncoding()).clientCredentials(config.getClientId(), config.getClientSecret()).responseExpiresInExpr(grantType.getExpirationRegex()).responseAccessTokenExpr(grantType.getAccessTokenExpr()).withClientCredentialsIn(ExtensionsOAuthUtils.toCredentialsLocation(grantType.getCredentialsPlacement())).resourceOwnerIdTransformer(ownerId -> ownerId + "-" + config.getOwnerConfigName() + "-" + this.generateId(config));
        if (config.getTlsContext() == null && config.getProxyConfig() == null) {
            dancerBuilder.tokenUrl(config.getTokenUrl());
        } else if (config.getTlsContext() != null && config.getProxyConfig() != null) {
            dancerBuilder.tokenUrl(config.getTokenUrl(), config.getTlsContext(), config.getProxyConfig());
        } else if (config.getTlsContext() != null) {
            dancerBuilder.tokenUrl(config.getTokenUrl(), config.getTlsContext());
        } else {
            dancerBuilder.tokenUrl(config.getTokenUrl(), config.getProxyConfig());
        }
        String scopes = config.getScope().orElseGet(() -> grantType.getDefaultScopes().orElse(null));
        if (scopes != null) {
            dancerBuilder.scopes(scopes);
        }
        dancerBuilder.customParameters(config.getCustomQueryParameters()).customHeaders(config.getCustomHeaders()).customBodyParameters(config.getCustomBodyParameters()).customParametersExtractorsExprs(this.getParameterExtractors(config));
        listeners.forEach(arg_0 -> ((org.mule.oauth.client.api.builder.OAuthClientCredentialsDancerBuilder)dancerBuilder).addListener(arg_0));
        ClientCredentialsOAuthDancer dancer = (ClientCredentialsOAuthDancer)dancerBuilder.build();
        if (this.started) {
            this.start(dancer);
        }
        return dancer;
    }

    protected Integer generateId(ClientCredentialsConfig config) {
        return Objects.hash(config.getOwnerConfigName(), config.getClientId(), config.getClientSecret(), config.getTokenUrl(), config.getScope(), config.getCustomQueryParameters(), config.getCustomHeaders());
    }

    protected Map<String, ClientCredentialsOAuthDancer> getDancers() {
        return this.dancers;
    }

    protected LazyValue<OAuthService> getOAuthService() {
        return this.oauthService;
    }
}

