/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.utils;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.function.Function;
import org.mule.runtime.extension.api.loader.parser.AttributesResolverModelParser;
import org.mule.runtime.extension.api.loader.parser.metadata.OutputResolverModelParser;
import org.mule.runtime.module.extension.api.loader.java.type.AnnotationValueFetcher;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.api.loader.java.type.WithAnnotations;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaAttributesResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaShortHandOutputResolver;
import org.mule.runtime.module.extension.internal.loader.parser.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.metadata.JavaOutputResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.utils.JavaMetadataTypeResolverUtils;
import org.mule.sdk.api.annotation.metadata.MetadataScope;
import org.mule.sdk.api.annotation.metadata.OutputResolver;

public class JavaOutputResolverModelParserUtils {
    public static Optional<OutputResolverModelParser> parseOutputResolverModelParser(MethodElement<?> methodElement) {
        return JavaOutputResolverModelParserUtils.extractFromAnnotation(methodElement, "operation", methodElement.getName(), org.mule.runtime.extension.api.annotation.metadata.OutputResolver.class, OutputResolver.class, org.mule.runtime.extension.api.annotation.metadata.OutputResolver::output, OutputResolver::output, cls -> JavaOutputResolverModelParserUtils.getResolverModelParserFromType(cls, JavaOutputResolverModelParser::new), JavaShortHandOutputResolver::getOutputResolverModelParser);
    }

    public static Optional<OutputResolverModelParser> parseOutputResolverModelParser(Type extensionType, WithAnnotations annotatedType) {
        return JavaOutputResolverModelParserUtils.parseSourceResolverModelParser(extensionType, annotatedType, org.mule.runtime.extension.api.annotation.metadata.MetadataScope::outputResolver, MetadataScope::outputResolver, cls -> JavaOutputResolverModelParserUtils.getResolverModelParserFromType(cls, JavaOutputResolverModelParser::new));
    }

    public static Optional<AttributesResolverModelParser> parseAttributesResolverModelParser(MethodElement<?> methodElement) {
        return JavaOutputResolverModelParserUtils.extractFromAnnotation(methodElement, "operation", methodElement.getName(), org.mule.runtime.extension.api.annotation.metadata.OutputResolver.class, OutputResolver.class, org.mule.runtime.extension.api.annotation.metadata.OutputResolver::attributes, OutputResolver::attributes, cls -> JavaOutputResolverModelParserUtils.getResolverModelParserFromType(cls, JavaAttributesResolverModelParser::new), JavaShortHandOutputResolver::getAttributesResolverModelParser);
    }

    public static Optional<AttributesResolverModelParser> parseAttributesResolverModelParser(Type extensionType, WithAnnotations annotatedType) {
        return JavaOutputResolverModelParserUtils.parseSourceResolverModelParser(extensionType, annotatedType, org.mule.runtime.extension.api.annotation.metadata.MetadataScope::attributesResolver, MetadataScope::attributesResolver, cls -> JavaOutputResolverModelParserUtils.getResolverModelParserFromType(cls, JavaAttributesResolverModelParser::new));
    }

    private static <T> Optional<T> parseSourceResolverModelParser(Type extensionType, WithAnnotations annotatedType, Function<org.mule.runtime.extension.api.annotation.metadata.MetadataScope, Class> legacyClassValueExtractor, Function<MetadataScope, Class> classValueExtractor, Function<Class<?>, T> mapper) {
        Optional<T> parserFromAnnotatedElement = JavaOutputResolverModelParserUtils.extractFromAnnotation(annotatedType, "source", "", org.mule.runtime.extension.api.annotation.metadata.MetadataScope.class, MetadataScope.class, legacyClassValueExtractor, classValueExtractor, mapper, null);
        if (parserFromAnnotatedElement.isPresent()) {
            return parserFromAnnotatedElement;
        }
        return JavaOutputResolverModelParserUtils.extractFromAnnotation(extensionType, "source", "", org.mule.runtime.extension.api.annotation.metadata.MetadataScope.class, MetadataScope.class, legacyClassValueExtractor, classValueExtractor, mapper, null);
    }

    private static <A extends Annotation, L extends Annotation, T> Optional<T> extractFromAnnotation(WithAnnotations methodElement, String elementType, String elementName, Class<L> legacyAnnotationClass, Class<A> sdkAnnotationClass, Function<L, Class> legacyClassValueExtractor, Function<A, Class> classValueExtractor, Function<Class<?>, T> mapper, Function<JavaShortHandOutputResolver, Optional<T>> shortHandResolverMapper) {
        Optional<T> resolver;
        if (shortHandResolverMapper != null && (resolver = JavaShortHandOutputResolver.findShortHandOutputResolver(methodElement).flatMap(shortHandResolverMapper)).isPresent()) {
            return resolver;
        }
        return MuleExtensionAnnotationParser.mapReduceSingleAnnotation(methodElement, elementType, elementName, legacyAnnotationClass, sdkAnnotationClass, JavaOutputResolverModelParserUtils.getMappingFunction(legacyClassValueExtractor, mapper), JavaOutputResolverModelParserUtils.getMappingFunction(classValueExtractor, mapper));
    }

    private static <A extends Annotation, T> Function<AnnotationValueFetcher<A>, T> getMappingFunction(Function<A, Class> classValueExtractor, Function<Class<?>, T> mapper) {
        return fetcher -> fetcher.getClassValue(classValueExtractor).getDeclaringClass().map(mapper).orElse(null);
    }

    private static <T> T getResolverModelParserFromType(Class<?> clazz, Function<Class<?>, T> resolveModelParserFactory) {
        if (!JavaMetadataTypeResolverUtils.isStaticResolver(clazz)) {
            return resolveModelParserFactory.apply(clazz);
        }
        return null;
    }
}

