/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.properties.views.ui;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.ILayoutPropertiesEditorRequested;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.dialog.IHost;
import org.mule.tooling.messageflow.dialog.IHostAware;
import org.mule.tooling.messageflow.dialog.IMessageDisplay;
import org.mule.tooling.messageflow.dialog.PageHost;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.module.MessageFlowNodeComposite;
import org.mule.tooling.model.messageflow.EndpointDirection;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.module.PropertyPageDefinition;
import org.mule.tooling.properties.editor.IPropertiesTitle;
import org.mule.tooling.properties.views.ui.AbstractPropertiesUIEditor;
import org.mule.tooling.ui.modules.core.widgets.RecalcWhenConfigurerUtils;
import org.mule.tooling.ui.utils.DelayedRunnableScheduler;
import org.mule.tooling.ui.widgets.IItem;
import org.mule.tooling.utils.UtilsPlugin;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class NodePropertiesUIEditor
extends AbstractPropertiesUIEditor<IMessageFlowNode> {
    private EventBusHelper busHelper = new EventBusHelper();
    private DelayedRunnableScheduler relayoutRequestScheduler = new DelayedRunnableScheduler(10);

    public NodePropertiesUIEditor(IMuleProject project, MultiPageMessageFlowEditor multiPageMessageFlowEditor, IMessageFlowNode node, IPropertiesTitle titleHandler) {
        super(project, multiPageMessageFlowEditor, node, titleHandler);
    }

    @Override
    public IHost createPropertiesEditorTabs() {
        PageHost result = new PageHost((IMessageDisplay)this, this.getNode(), this.getTabs(), this.getContributedPages());
        for (PropertyPageDefinition page : this.getPropertyPages(this.getProject())) {
            EndpointDirection direction = this.getEndpointDirection();
            if (page.getDirection() != null && !page.getDirection().equals((Object)direction)) continue;
            this.createAndRegisterPageComposite(result, page, direction);
        }
        RecalcWhenConfigurerUtils.configureRecalcWhenFor(this.getContributedPages());
        return result;
    }

    private EndpointDirection getEndpointDirection() {
        EndpointDirection direction = null;
        if (this.getNode() instanceof EndpointNode) {
            EndpointNode n = (EndpointNode)this.getNode();
            direction = n.getDirection();
        }
        return direction;
    }

    private void createAndRegisterPageComposite(PageHost host, PropertyPageDefinition pageDefinition, EndpointDirection direction) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(this.getTabs().getContentContainer(), 768);
        scrolledComposite.setLayoutDeferred(true);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        try {
            MessageFlowNodeComposite pageComposite = (MessageFlowNodeComposite)pageDefinition.create(direction, (Object)this.getProject(), (Composite)scrolledComposite);
            if (pageComposite instanceof IHostAware) {
                IHostAware hh = (IHostAware)pageComposite;
                hh.setHost((IHost)host);
            }
            scrolledComposite.setContent((Control)pageComposite);
            this.relayout(scrolledComposite, pageComposite);
            this.allowScrollCompositeToResizeOnLayoutChanges(scrolledComposite, pageComposite);
            IItem item = this.getTabs().createNewItem(0);
            item.setText(pageDefinition.getName());
            item.setToolTipText(pageDefinition.getDescription());
            item.setControl((Control)scrolledComposite);
            this.getContributedPages().add(pageComposite);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while creating editor", e);
        }
        scrolledComposite.setLayoutDeferred(false);
    }

    private void allowScrollCompositeToResizeOnLayoutChanges(final ScrolledComposite scrolledComposite, final MessageFlowNodeComposite contributed) {
        this.busHelper.registerListener(UtilsPlugin.getEventBus(), CoreEventTypes.LAYOUT_PROPERTIES_EDITOR_REQUEST, (IEventHandler)new ILayoutPropertiesEditorRequested(){

            public void onLayoutRequested() {
                NodePropertiesUIEditor.this.relayoutRequestScheduler.schedule(() -> {
                    if (!scrolledComposite.isDisposed()) {
                        Point origin = scrolledComposite.getOrigin();
                        NodePropertiesUIEditor.this.relayout(scrolledComposite, contributed);
                        scrolledComposite.layout(true, true);
                        if (origin != null) {
                            scrolledComposite.setOrigin(origin);
                        }
                    }
                });
            }
        });
        this.busHelper.unregisterWith((Widget)scrolledComposite);
    }

    private void relayout(ScrolledComposite scrolledComposite, MessageFlowNodeComposite contributed) {
        Point panelSize = contributed.computeSize(-1, -1);
        scrolledComposite.setMinSize(-1, panelSize.y);
    }
}

