/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.properties.views.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.validation.Message;
import org.mule.tooling.icons.ImagesManager;
import org.mule.tooling.messageflow.dialog.IHost;
import org.mule.tooling.messageflow.dialog.IMessageDisplay;
import org.mule.tooling.messageflow.dialog.PageHost;
import org.mule.tooling.messageflow.editor.CustomPageManager;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.events.EditPartEventTypes;
import org.mule.tooling.messageflow.events.ICustomPageChangedListener;
import org.mule.tooling.messageflow.module.CustomPageComposite;
import org.mule.tooling.messageflow.module.ICustomPage;
import org.mule.tooling.messageflow.module.IMessageFlowNodeAware;
import org.mule.tooling.messageflow.module.MessageFlowNodeComposite;
import org.mule.tooling.messageflow.util.HTMLUtils;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.PropertyPageDefinition;
import org.mule.tooling.properties.Activator;
import org.mule.tooling.properties.editor.IPropertiesTitle;
import org.mule.tooling.properties.views.ui.IMessageFlowEntityUIEditor;
import org.mule.tooling.ui.modules.core.properties.IPropertyValueChangeListener;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.IForceSave;
import org.mule.tooling.ui.modules.core.widgets.editors.ListEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.RadioBooleanEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.propertypage.PageWithControlsProvider;
import org.mule.tooling.ui.modules.core.widgets.utils.ValidationMessageUtils;
import org.mule.tooling.ui.widgets.IItem;
import org.mule.tooling.ui.widgets.IMessageLogger;
import org.mule.tooling.ui.widgets.tab.IItemContainer;
import org.mule.tooling.ui.widgets.tab.VerticalPropertiesTabFolder;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;

public abstract class AbstractPropertiesUIEditor<T extends IMessageFlowNode>
implements IMessageDisplay,
IMessageFlowEntityUIEditor {
    private IMuleProject project;
    protected T node;
    protected PropertyCollectionMap updatedProperties;
    private NodeDefinition template;
    private IItemContainer tabs;
    private List<MessageFlowNodeComposite> contributedPages = new ArrayList<MessageFlowNodeComposite>();
    private IMessageLogger messageLogger;
    private IPropertiesTitle titleHandler;
    private IHost pageHost;
    private MuleConfiguration muleConfiguration;
    private NodeDefinition definition;
    private List<ICustomPage> customPages;
    private EventBus eventBus;
    private EventBusHelper eventBusHelper;
    private MultiPageMessageFlowEditor multiPageMessageFlowEditor;

    public AbstractPropertiesUIEditor(IMuleProject project, MultiPageMessageFlowEditor multiPageMessageFlowEditor, T node, IPropertiesTitle titleHandler) {
        this.multiPageMessageFlowEditor = multiPageMessageFlowEditor;
        this.muleConfiguration = multiPageMessageFlowEditor.getMuleConfiguration();
        this.project = project;
        this.node = node;
        this.eventBus = MuleCorePlugin.getEventBus();
        this.eventBusHelper = new EventBusHelper();
        this.customPages = new ArrayList<ICustomPage>();
        this.setTitleHandler(titleHandler);
        this.definition = node.getDefinition();
        this.setTemplate(this.definition);
    }

    @Override
    public Control createControl(Composite parent) {
        this.configurateTitle();
        Composite nested = new Composite(parent, 0);
        ThemeUtils.setCssClass((Object)nested, (String)"PropertiesEditor");
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        nested.setLayout((Layout)layout);
        nested.setLayoutData((Object)new GridData(1808));
        VerticalPropertiesTabFolder verticalPropertiesTabFolder = this.createTabFolder(nested);
        this.setMessageLogger(verticalPropertiesTabFolder.getMessageLogger());
        this.getMessageLogger().setGoToHandler(location -> {
            if (location.length() > 0) {
                String tabName = location.split("/")[0];
                IItem[] items = this.tabs.getItems();
                int j = 0;
                while (j < items.length) {
                    if (items[j].getText().equals(tabName)) {
                        this.tabs.setSelection(j);
                        return;
                    }
                    ++j;
                }
            }
        });
        this.createAllTabs();
        nested.layout();
        nested.redraw();
        this.addListeners(nested);
        return nested;
    }

    private void addListeners(Composite control) {
        this.eventBusHelper.registerListener(this.eventBus, EditPartEventTypes.CUSTOM_PAGE_CONFIG_CHANGED, (IEventHandler)((ICustomPageChangedListener)() -> this.multiPageMessageFlowEditor.markAsModified()));
        control.addDisposeListener(event -> this.eventBusHelper.unregister());
    }

    @Override
    public IHost getPageHost() {
        return this.pageHost;
    }

    protected VerticalPropertiesTabFolder createTabFolder(Composite parent) {
        VerticalPropertiesTabFolder verticalPropertiesTabFolder = new VerticalPropertiesTabFolder(parent, 0);
        verticalPropertiesTabFolder.setLayoutData((Object)new GridData(1808));
        this.tabs = verticalPropertiesTabFolder;
        return verticalPropertiesTabFolder;
    }

    protected void configurateTitle() {
        NodeDefinition nodeDefinition = this.getTemplate();
        this.getTitleHandler().setDescription(nodeDefinition == null ? "Unknown" : HTMLUtils.removeHtmlTags((String)nodeDefinition.getDescription()));
        this.getTitleHandler().setImage(nodeDefinition == null ? ImagesManager.getInstance().getPaletteUnknown() : nodeDefinition.getIconImage());
    }

    private void createAllTabs() {
        this.pageHost = this.createPropertiesEditorTabs();
        this.createCustomTabs();
        this.getTabs().refreshItems();
        this.getTabs().setSelection(0);
    }

    public abstract IHost createPropertiesEditorTabs();

    protected void hideTabsForVersion(PageHost hst) {
        Composite[] compositeArray = hst.getAllPages();
        int n = compositeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Composite composite = compositeArray[n2];
            MessageFlowNodeComposite page = (MessageFlowNodeComposite)composite;
            if (!page.compliesVersion(this.getProject().getServerDefinition().getVersionWithEESign())) {
                hst.removePage(page);
            }
            ++n2;
        }
    }

    private void createCustomTabs() {
        IItemContainer tabFolder = this.getTabs();
        Composite contentContainer = tabFolder.getContentContainer();
        this.customPages = new CustomPageManager().getCustomPages(this.getNode(), this.getProject());
        this.customPages.sort((o1, o2) -> {
            int order = o1.getPosition().compareTo(o2.getPosition());
            return order != 0 ? order : o1.getTitle().compareTo(o2.getTitle());
        });
        for (ICustomPage customPage : this.customPages) {
            IItem[] items = tabFolder.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].getText().equals(customPage.getTitle())) {
                    if (!(tabFolder instanceof VerticalPropertiesTabFolder)) break;
                    ((VerticalPropertiesTabFolder)tabFolder).removeItem(i);
                    break;
                }
                ++i;
            }
            IItem item = tabFolder.createNewItem(0);
            item.setText(customPage.getTitle());
            item.setToolTipText(customPage.getDescription());
            if (customPage instanceof IMessageFlowNodeAware) {
                ((IMessageFlowNodeAware)customPage).setNode(this.node);
            }
            long start = System.currentTimeMillis();
            CustomPageComposite pageControl = customPage.createControl(contentContainer);
            long end = System.currentTimeMillis();
            Activator.debugTracer().trace(Activator.CREATE_UI_PERFORMANCE_ID, String.format("Custom page [%s] took %s ms to render.", customPage.getClass(), Long.toString(end - start)));
            item.setControl((Control)pageControl);
            customPage.setMessageLogger(this.getMessageLogger());
        }
    }

    public List<PropertyPageDefinition> getPropertyPages(IMuleProject prj) {
        return this.getTemplate().getPropertyPages((Object)prj);
    }

    public PropertyCollectionMap generateUpdatedPropertyCollection() {
        MessageFlowNodeComposite[] contributedPagesArray;
        PropertyCollectionMap updated = new PropertyCollectionMap();
        List<MessageFlowNodeComposite> contributedPagesList = this.getContributedPages();
        MessageFlowNodeComposite[] messageFlowNodeCompositeArray = contributedPagesArray = contributedPagesList.toArray(new MessageFlowNodeComposite[contributedPagesList.size()]);
        int n = contributedPagesArray.length;
        int n2 = 0;
        while (n2 < n) {
            MessageFlowNodeComposite page = messageFlowNodeCompositeArray[n2];
            if (!page.isDisposed()) {
                page.saveTo(this.getNode(), updated);
            }
            ++n2;
        }
        for (ICustomPage customPage : this.customPages) {
            customPage.saveTo(this.getNode(), updated);
        }
        return updated;
    }

    @Override
    public void loadEditorPropertiesInformation() {
        long start = System.currentTimeMillis();
        ArrayList<MessageFlowNodeComposite> contributedPagesCopy = new ArrayList<MessageFlowNodeComposite>(this.getContributedPages());
        PropertyCollectionMap propertiesMap = new PropertyCollectionMap(this.getNode().getProperties());
        for (MessageFlowNodeComposite mc : contributedPagesCopy) {
            mc.loadFrom(this.getNode(), propertiesMap);
        }
        for (ICustomPage customPage : this.customPages) {
            customPage.loadFrom(this.getNode(), new PropertyCollectionMap(this.getNode().getProperties()));
        }
        long end = System.currentTimeMillis();
        Activator.debugTracer().trace(Activator.CREATE_UI_PERFORMANCE_ID, String.format("Editor [%s] took %s ms to load type [%s]", this.getClass().getName(), Long.toString(end - start), this.getNode().getDefinition().getId()));
    }

    @Override
    public void postInit() {
        PropertyCollectionMap propertiesMap = new PropertyCollectionMap(this.getNode().getProperties());
        for (MessageFlowNodeComposite mc : this.getContributedPages()) {
            mc.postInitLoadFrom(this.getNode(), propertiesMap);
        }
    }

    protected IMessageFlowNode getNode() {
        return this.node;
    }

    public ICustomPage getCustomPageWithTitle(String title) {
        for (ICustomPage customPage : this.customPages) {
            if (!customPage.getTitle().equals(title)) continue;
            return customPage;
        }
        return null;
    }

    public void setMessages(List<Message> messages) {
        this.getMessageLogger().setMessages(ValidationMessageUtils.asValidationMessages(messages));
    }

    public IPropertiesTitle getTitleHandler() {
        return this.titleHandler;
    }

    public void setMessageLogger(IMessageLogger messageLogger) {
        this.messageLogger = messageLogger;
    }

    public IMessageLogger getMessageLogger() {
        return this.messageLogger;
    }

    public void setTemplate(NodeDefinition template) {
        this.template = template;
    }

    public NodeDefinition getTemplate() {
        return this.template;
    }

    public void setTitleHandler(IPropertiesTitle titleHandler) {
        this.titleHandler = titleHandler;
    }

    public void setContributedPages(List<MessageFlowNodeComposite> contributedPages) {
        this.contributedPages = contributedPages;
    }

    public List<MessageFlowNodeComposite> getContributedPages() {
        return this.contributedPages;
    }

    public void setTabs(IItemContainer tabs) {
        this.tabs = tabs;
    }

    public IItemContainer getTabs() {
        return this.tabs;
    }

    public void setProject(IMuleProject project) {
        this.project = project;
    }

    public IMuleProject getProject() {
        return this.project;
    }

    public MuleConfiguration getMuleConfiguration() {
        return this.muleConfiguration;
    }

    @Override
    public boolean hasToForceSave() {
        Composite[] allPages;
        Composite[] compositeArray = allPages = this.getPageHost().getAllPages();
        int n = allPages.length;
        int n2 = 0;
        while (n2 < n) {
            Composite composite = compositeArray[n2];
            if (composite instanceof PageWithControlsProvider) {
                LinkedHashMap editors = ((PageWithControlsProvider)composite).getEditors();
                Collection fieldEditors = editors.values();
                for (IFieldEditor fieldEditor : fieldEditors) {
                    if (!(fieldEditor instanceof IForceSave) || !((IForceSave)fieldEditor).hasToForceSave(this.getMuleConfiguration(), this.getProject(), this.getNode())) continue;
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void addPropertyValueChangedListener(IPropertyValueChangeListener propertyListener) {
        Composite[] allPages;
        Composite[] compositeArray = allPages = this.getPageHost().getAllPages();
        int n = allPages.length;
        int n2 = 0;
        while (n2 < n) {
            Composite composite = compositeArray[n2];
            if (composite instanceof PageWithControlsProvider) {
                LinkedHashMap editors = ((PageWithControlsProvider)composite).getEditors();
                Collection fieldEditors = editors.values();
                for (IFieldEditor fieldEditor : fieldEditors) {
                    fieldEditor.addPropertyChangeListener(propertyListener);
                }
            }
            ++n2;
        }
    }

    @Override
    public void removeAllPropertyValueChangeListeners() {
        Composite[] allPages;
        Composite[] compositeArray = allPages = this.getPageHost().getAllPages();
        int n = allPages.length;
        int n2 = 0;
        while (n2 < n) {
            Composite composite = compositeArray[n2];
            if (composite instanceof PageWithControlsProvider) {
                LinkedHashMap editors = ((PageWithControlsProvider)composite).getEditors();
                Collection fieldEditors = editors.values();
                for (IFieldEditor fieldEditor : fieldEditors) {
                    fieldEditor.removeAllPropertyValueChangeListeners();
                }
            }
            ++n2;
        }
    }

    @Override
    public void dispose() {
        this.multiPageMessageFlowEditor = null;
        RadioBooleanEditor.clearCached();
        ListEditor.clearCached();
    }
}

