/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.properties.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.properties.editor.CommentElementPropertiesEditor;
import org.mule.tooling.properties.editor.EntityEditPartPropertiesEditor;
import org.mule.tooling.properties.editor.IPropertiesEditor;
import org.mule.tooling.properties.editor.ReadOnlyElementPropertiesEditor;
import org.mule.tooling.properties.editor.SplitterEditPartPropertiesEditor;
import org.mule.tooling.properties.editor.UnknownElementPropertiesEditor;

public class PropertiesEditorFactoryManager {
    private static final int ENTITY_PRIORITY = Integer.MAX_VALUE;
    private static final int PATTERN_PRIORITY = 0x7FFFFFFE;
    private static final int SPLITTER_PRIORITY = 0x7FFFFFFD;
    private static final int FLOW_PRIORITY = 0x7FFFFFFC;
    private static final int COMMENT_PRIORITY = 0x7FFFFFFB;
    private static final int UNKNOWN_PRIORITY = 0x7FFFFFFA;
    private static PropertiesEditorFactoryManager manager = new PropertiesEditorFactoryManager();
    private static final ReadOnlyElementPropertiesEditor<EntityEditPart<? extends MessageFlowNode>> READ_ONLY_PROPERTIES_EDITOR = new ReadOnlyElementPropertiesEditor();
    private List<PriorityPropertiesEditor> editors;

    public static PropertiesEditorFactoryManager getDefault() {
        return manager;
    }

    public PropertiesEditorFactoryManager() {
        this.init();
    }

    public static <T> IPropertiesEditor<T> getReadOnlylementPropertiesEditor() {
        return READ_ONLY_PROPERTIES_EDITOR;
    }

    private void init() {
        IConfigurationElement[] configurationElementsFor;
        this.editors = new ArrayList<PriorityPropertiesEditor>();
        IConfigurationElement[] iConfigurationElementArray = configurationElementsFor = Platform.getExtensionRegistry().getConfigurationElementsFor("org.mule.tooling.properties.editparteditor");
        int n = configurationElementsFor.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            try {
                IPropertiesEditor editor = (IPropertiesEditor)iConfigurationElement.createExecutableExtension("class");
                String priorityValue = iConfigurationElement.getAttribute("priority");
                PriorityPropertiesEditor priorityPropertiesEditor = new PriorityPropertiesEditor(editor, Integer.parseInt(priorityValue));
                this.editors.add(priorityPropertiesEditor);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        this.editors.add(new PriorityPropertiesEditor(new SplitterEditPartPropertiesEditor(), 0x7FFFFFFD));
        this.editors.add(new PriorityPropertiesEditor(new EntityEditPartPropertiesEditor(), Integer.MAX_VALUE));
        this.editors.add(new PriorityPropertiesEditor(new UnknownElementPropertiesEditor(), 0x7FFFFFFA));
        this.editors.add(new PriorityPropertiesEditor(new CommentElementPropertiesEditor(), 0x7FFFFFFB));
        Collections.sort(this.editors);
    }

    public <T> IPropertiesEditor<T> getFactoryFor(T element) {
        for (PriorityPropertiesEditor factory : this.editors) {
            if (!factory.getEditor().handles(element)) continue;
            return factory.getEditor();
        }
        return null;
    }

    private static class PriorityPropertiesEditor
    implements Comparable<PriorityPropertiesEditor> {
        private IPropertiesEditor<?> editor;
        private int priority;

        public PriorityPropertiesEditor(IPropertiesEditor<?> editor, int priority) {
            this.editor = editor;
            this.priority = priority;
        }

        public IPropertiesEditor<?> getEditor() {
            return this.editor;
        }

        public int getPriority() {
            return this.priority;
        }

        @Override
        public int compareTo(PriorityPropertiesEditor o) {
            Integer priorityValue = this.getPriority();
            return priorityValue.compareTo(o.getPriority());
        }
    }
}

