/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.properties.views;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ViewPart;
import org.mule.tooling.client.ToolingPropagationResult;
import org.mule.tooling.client.api.IComponentPath;
import org.mule.tooling.client.api.PropagationInfo;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.event.ComponentMetadataDefinitionChangedEvent;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IComponentMetadataDefinitionChangedListener;
import org.mule.tooling.core.event.IDataSenseJobListenerAdapter;
import org.mule.tooling.core.event.IDataSenseTypeChangedListener;
import org.mule.tooling.core.event.IEditorPartChangedListener;
import org.mule.tooling.core.event.IMessageFlowEntityDeletedEventListener;
import org.mule.tooling.core.event.IMessageFlowEntityEditedListener;
import org.mule.tooling.core.event.IMetadataDefinitionChangedListener;
import org.mule.tooling.core.event.IMetadataKeyFieldEditorEditedListener;
import org.mule.tooling.core.event.IMuleProjectEventListener;
import org.mule.tooling.core.event.MessageFlowEventTypes;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.editor.IMessageFlowEditorSavedListener;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.editpart.MuleConfigurationEditPart;
import org.mule.tooling.messageflow.events.ChangeEditPartRequestedEventListener;
import org.mule.tooling.messageflow.events.EditPartEventTypes;
import org.mule.tooling.messageflow.events.IEditPartSelectedEventListener;
import org.mule.tooling.messageflow.events.IMetadataPropagationFinishedListener;
import org.mule.tooling.messageflow.events.IMetadataPropagationRefreshRequestedListener;
import org.mule.tooling.messageflow.events.IMetadataPropagationStartedListener;
import org.mule.tooling.messageflow.events.PropagationEventTypes;
import org.mule.tooling.messageflow.metadata.MetadataTreeExplorer;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.metadata.datasense.DataSenseRequest;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.properties.Activator;
import org.mule.tooling.properties.PropertiesImages;
import org.mule.tooling.properties.editor.IPropertiesEditor;
import org.mule.tooling.properties.editor.IPropertiesTitle;
import org.mule.tooling.properties.views.IPropertiesViewDialog;
import org.mule.tooling.properties.views.MulePropertiesInternalDialog;
import org.mule.tooling.properties.views.PropertiesEditorFactoryManager;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.ui.modules.core.metadata.DataSenseInfoProvider;
import org.mule.tooling.ui.modules.core.properties.IPropertyValueChangeListener;
import org.mule.tooling.ui.utils.DelayedRunnableScheduler;
import org.mule.tooling.ui.utils.UiUtils;
import org.mule.tooling.ui.widgets.action.DisposableToolbarManager;
import org.mule.tooling.utils.UtilsPlugin;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class MulePropertiesView
extends ViewPart
implements IPropertiesTitle {
    private static final String MODIFIED_PREFIX = "*";
    private static final String MULE_PROPERTIES_VIEW = "Mule Properties";
    private static final String EDIT_PROPERTIES_MESSAGE = "Select a Mule message processor to edit its properties";
    public static final String ID = "org.mule.tooling.properties.views.MulePropertiesView";
    private Composite container;
    private StackLayout containerStackLayout;
    private Composite text;
    private IPropertiesEditor<GraphicalEditPart> currentEditor;
    private MuleSelectionListener selectionListener;
    private GraphicalEditPart selectedNode;
    private IMessageFlowEditorSavedListener saveListener;
    private FlowEditorPageChangeListener pageChangeListener;
    private MultiPageMessageFlowEditor multiPageMessageFlowEditor;
    private EditorPartListener viewEditorPartListener;
    private Control currentEditorControl;
    private ApplyAction applyAction;
    private MetadataAction metadataAction;
    private Composite view;
    private EventBusHelper eventBusHelper = new EventBusHelper();
    private MetadataTreeExplorer metadataTreeExplorer;
    private MulePropertiesInternalDialog<?> shownDialog;
    private Optional<DataSenseInfoProvider> maybeDataSenseInfoProvider = Optional.empty();
    private DelayedRunnableScheduler selectionRequestScheduler = new DelayedRunnableScheduler(250);
    private boolean isClosing = false;

    public Optional<DataSenseInfoProvider> getDataSenseInfoProvider() {
        return this.maybeDataSenseInfoProvider;
    }

    public void createPartControl(Composite parent) {
        this.applyAction = new ApplyAction();
        this.metadataAction = new MetadataAction();
        this.view = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().margins(2, 2).spacing(1, 0).numColumns(2).applyTo(this.view);
        this.container = new Composite(this.view, 0);
        this.container.setLayoutData((Object)new GridData(1808));
        this.containerStackLayout = new StackLayout();
        this.containerStackLayout.marginHeight = 0;
        this.containerStackLayout.marginWidth = 0;
        this.container.setLayout((Layout)this.containerStackLayout);
        this.text = UiUtils.createDisabledComposite((Composite)this.container, (String)EDIT_PROPERTIES_MESSAGE, (Image)PropertiesImages.get().getImageByPath("icons/disabled-mule-properties.png"));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.text);
        this.containerStackLayout.topControl = this.text;
        this.saveListener = new EditorSaveListener();
        this.pageChangeListener = new FlowEditorPageChangeListener();
        this.registerListener();
    }

    public Action getApplyAction() {
        return this.applyAction;
    }

    public <T extends IPropertiesViewDialog> void showDialog(T dialog, IPropertiesViewDialog.OnPropertiesFinishedCallback<T> callback) {
        Control displayedControl = this.containerStackLayout.topControl;
        boolean isMetadataViewerShown = this.isMetadataViewerOpen();
        if (isMetadataViewerShown && this.metadataAction != null) {
            this.metadataAction.run();
        }
        DialogCloserListener<T> onMinimize = new DialogCloserListener<T>(isMetadataViewerShown, displayedControl, callback);
        this.shownDialog = new MulePropertiesInternalDialog<T>(this.container, 0, dialog, onMinimize);
        this.containerStackLayout.topControl = this.shownDialog;
        this.container.layout();
        Display.getDefault().asyncExec(() -> this.shownDialog.onOpen());
    }

    protected void registerListener() {
        DeleteOrCloseProjectListener listener = new DeleteOrCloseProjectListener(this);
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), CoreEventTypes.ResourceEvents.ON_MULE_PROJECT_EVENT, (IEventHandler)listener);
        this.viewEditorPartListener = new EditorPartListener();
        this.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener2)this.viewEditorPartListener);
        this.selectionListener = new MuleSelectionListener();
        ISelectionService selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        selectionService.addPostSelectionListener((ISelectionListener)this.selectionListener);
        Display.getCurrent().asyncExec(this::showCurrentSelection);
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), MessageFlowEventTypes.ON_MESSAGE_FLOW_ENTITY_DELETED, (IEventHandler)new IMessageFlowEntityDeletedEventListener(){

            public void onNodeDeleted(IMuleProject project, IFile configFile, MuleConfiguration muleConfig, IMessageFlowEntity node) {
                if (MulePropertiesView.this.selectedNode instanceof EntityEditPart && ((EntityEditPart)MulePropertiesView.this.selectedNode).getEntity().equals(node)) {
                    MulePropertiesView.this.doClose(false);
                }
            }
        });
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), EditPartEventTypes.ON_EDIT_PART_SELECTED, (IEventHandler)((IEditPartSelectedEventListener)(configuration, editPart) -> {
            MultiPageMessageFlowEditor currentEditor = MessageFlowUtils.getMultiPageMessageFlowEditor();
            if (currentEditor != null && ((MuleConfiguration)currentEditor.getFlowEditor().getMuleConfigurationDecorator().getEntity()).equals(configuration)) {
                this.showSelectionAsynchronously(currentEditor, (GraphicalEditPart)editPart, () -> editPart.showCollapsed());
            }
        }));
        this.eventBusHelper.registerListener(UtilsPlugin.getEventBus(), CoreEventTypes.ON_CURRENT_EDITOR_PART_CHANGED, (IEventHandler)new IEditorPartChangedListener(){

            public void onCurrentEditorPartChanged(IEditorPart editor) {
                if (MulePropertiesView.this.getCurrentEditor() != null) {
                    MulePropertiesView.this.setCurrentEditor(MulePropertiesView.this.getCurrentEditor());
                }
            }

            public void onCurrentEditorClosed() {
            }
        });
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), EditPartEventTypes.ON_CHANGE_EDIT_PART_REQUESTED, (IEventHandler)((ChangeEditPartRequestedEventListener)newEditPart -> this.multiPageMessageFlowEditor.getFlowEditor().setSelection((ISelection)new StructuredSelection((Object)newEditPart))));
        this.eventBusHelper.registerUIListener(MuleCorePlugin.getEventBus(), MessageFlowEventTypes.ON_METADATA_KEY_FIELD_EDITOR_EDITED, (IEventHandler)((IMetadataKeyFieldEditorEditedListener)(project, node, previousProperties, newProperties) -> this.getDataSenseInfoProvider().ifPresent(pip -> pip.reload(DataSenseRequest.DataSenseRequestType.BOTH, newProperties, true, false))));
        this.eventBusHelper.registerUIListener(MuleCorePlugin.getEventBus(), CoreEventTypes.ON_DATASENSE_TYPE_CHANGE_EVENT, (IEventHandler)((IDataSenseTypeChangedListener)project -> this.reloadPropagationIfNecessary()));
        this.eventBusHelper.registerUIListener(MuleCorePlugin.getEventBus(), CoreEventTypes.ON_DATASENSE_JOB_EVENT, (IEventHandler)new IDataSenseJobListenerAdapter(){

            public void onDataSenseJobSuccessfulCompletion(IMuleProject eventMuleProject, IMessageFlowNode node) {
                MulePropertiesView.this.reloadPropagationIfNecessary();
            }
        });
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), CoreEventTypes.ON_COMPONENT_METADATA_DEFINITION_CHANGED, (IEventHandler)((IComponentMetadataDefinitionChangedListener)(project, type) -> this.getDataSenseInfoProvider().ifPresent(provider -> {
            if (type == ComponentMetadataDefinitionChangedEvent.CompenentMetadataType.OUTPUT) {
                provider.reloadPropagation();
            } else {
                provider.reloadComponentDataSense();
            }
        })));
        this.eventBusHelper.registerUIListener(MuleCorePlugin.getEventBus(), MessageFlowEventTypes.ON_MESSAGE_FLOW_ENTITY_EDITED, (IEventHandler)((IMessageFlowEntityEditedListener)(project, entity, previousProperties) -> this.reloadPropagationIfNecessary()));
        this.eventBusHelper.registerUIListener(MuleCorePlugin.getEventBus(), CoreEventTypes.ON_METADATA_DEFINITION_CHANGED, (IEventHandler)((IMetadataDefinitionChangedListener)project -> this.reloadPropagationIfNecessary()));
        this.eventBusHelper.registerUIListener(MuleCorePlugin.getEventBus(), PropagationEventTypes.ON_METADATA_PROPAGATION_STARTED, (IEventHandler)((IMetadataPropagationStartedListener)entity -> {
            if (this.isMetadataViewerOpen()) {
                this.metadataTreeExplorer.showLoadingIndicator();
            }
        }));
        this.eventBusHelper.registerUIListener(MuleCorePlugin.getEventBus(), PropagationEventTypes.ON_METADATA_PROPAGATION_FINISHED, (IEventHandler)new IMetadataPropagationFinishedListener(){

            public void onMetadataPropagationFinished(PropagationInfo propagationInfo) {
                Optional<MessageFlowEntity> maybeMessageFlowEntity = MulePropertiesView.this.getCurrentMessageFlowEntity();
                if (maybeMessageFlowEntity.isPresent() && MulePropertiesView.this.isMetadataViewerOpen() && (ToolingPropagationResult.PropagationResultBuilder.EMPTY == propagationInfo || this.belongsToMe(maybeMessageFlowEntity.get(), propagationInfo))) {
                    MulePropertiesView.this.metadataTreeExplorer.updateMetadata(propagationInfo);
                }
            }

            private boolean belongsToMe(MessageFlowEntity messageFlowEntity, PropagationInfo propagationInfo) {
                MuleConfiguration muleConfiguration = MulePropertiesView.this.multiPageMessageFlowEditor.getMuleConfiguration();
                boolean belongsToMe = false;
                if (muleConfiguration != null) {
                    Optional<MulePath> maybeCurrentNodePath = Optional.ofNullable(muleConfiguration.getPathFor((IMessageFlowEntity)messageFlowEntity));
                    String currentNodePath = maybeCurrentNodePath.map(Object::toString).orElse("");
                    IComponentPath componentPath = propagationInfo.getComponentPath();
                    String propagationComponentPath = componentPath != null ? componentPath.toPath() : null;
                    belongsToMe = currentNodePath.equals(propagationComponentPath);
                }
                return belongsToMe;
            }
        });
        this.eventBusHelper.registerUIListener(MuleCorePlugin.getEventBus(), PropagationEventTypes.ON_METADATA_PROPAGATION_REQUEST_REQUESTED, (IEventHandler)((IMetadataPropagationRefreshRequestedListener)() -> {
            Optional<MessageFlowEntity> maybeMessageFlowEntity = this.getCurrentMessageFlowEntity();
            maybeMessageFlowEntity.ifPresent(mfw -> {
                if (mfw instanceof IMessageFlowNode && this.getCurrentEditor() != null && this.getCurrentEditor().getPropertiesManager().isPresent()) {
                    List contributedPages = this.getCurrentEditor().getPropertiesManager().get().getContributedPages();
                    IMessageFlowNode updatedCurrentNode = (IMessageFlowNode)MessageFlowUtils.generateNodeToTestSupplier((IMessageFlowNode)((IMessageFlowNode)mfw)).get();
                    Function updatedPropertiesProvider = MessageFlowUtils.updatedPropertiesProvider((List)contributedPages);
                    this.getDataSenseInfoProvider().ifPresent(pip -> pip.reload(DataSenseRequest.DataSenseRequestType.BOTH, ((PropertyCollectionMap)updatedPropertiesProvider.apply(updatedCurrentNode)).asPropertyCollection(), true, true));
                }
            });
        }));
    }

    public void showCurrentSelection() {
        ISelectionService selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        MultiPageMessageFlowEditor activeEditor = MessageFlowUtils.getMultiPageMessageFlowEditor();
        ISelection selection = selectionService.getSelection();
        if (activeEditor != null && selection != null && !selection.isEmpty()) {
            this.selectionListener.selectionChanged((IWorkbenchPart)activeEditor, selection);
        }
    }

    public boolean showSelection(MultiPageMessageFlowEditor sourcepart, ISelection selection) {
        GraphicalEditPart newSelectedNode = this.getSelectedEditPart(selection);
        if (newSelectedNode == null) {
            this.clearSelection();
            return false;
        }
        return this.showSelection(sourcepart, newSelectedNode);
    }

    public void showSelectionAsynchronously(MultiPageMessageFlowEditor sourcePart, ISelection selection, Runnable followUp) {
        GraphicalEditPart newSelectedNode = this.getSelectedEditPart(selection);
        this.showSelectionAsynchronously(sourcePart, newSelectedNode, followUp);
        if (newSelectedNode == null) {
            this.clearSelection();
        }
    }

    public void apply(boolean force) {
        if (this.getCurrentEditor() != null) {
            this.getCurrentEditor().apply(force);
        }
    }

    public boolean showSelection(MultiPageMessageFlowEditor sourcePart, GraphicalEditPart newSelectedNode) {
        return this.doShowSelection(sourcePart, newSelectedNode);
    }

    public void showSelectionAsynchronously(MultiPageMessageFlowEditor sourcePart, GraphicalEditPart newSelectedNode, Runnable followUp) {
        if (!this.prepareDeselection(sourcePart, newSelectedNode)) {
            if (followUp != null) {
                followUp.run();
            }
            return;
        }
        this.selectionRequestScheduler.schedule(() -> {
            if (!sourcePart.isDisposed()) {
                this.doShowSelection(sourcePart, newSelectedNode);
                Optional.ofNullable(followUp).ifPresent(Runnable::run);
            }
        });
    }

    private boolean prepareDeselection(MultiPageMessageFlowEditor sourcepart, GraphicalEditPart newSelectedNode) {
        if (!this.selectionRequestScheduler.hasSchedules() && this.selectedNode != null && newSelectedNode != null && this.selectedNode.getModel().equals(newSelectedNode.getModel())) {
            return false;
        }
        if (this.isEditorOpened()) {
            this.closeCurrentEditor(true);
        }
        return true;
    }

    private boolean doShowSelection(MultiPageMessageFlowEditor sourcepart, GraphicalEditPart newSelectedNode) {
        if (!this.prepareDeselection(sourcepart, newSelectedNode)) {
            return false;
        }
        this.unRegisterMultiPageListener();
        this.multiPageMessageFlowEditor = sourcepart;
        this.selectedNode = newSelectedNode;
        this.initDataSenseInfo(this.multiPageMessageFlowEditor, this.selectedNode);
        if (this.selectedNode != null) {
            if (sourcepart.isReadOnly()) {
                IPropertiesEditor<GraphicalEditPart> editor = PropertiesEditorFactoryManager.getReadOnlylementPropertiesEditor();
                editor.setTitleHandler(this);
                this.open(editor);
                return true;
            }
            IPropertiesEditor<GraphicalEditPart> editor = PropertiesEditorFactoryManager.getDefault().getFactoryFor(this.selectedNode);
            if (editor != null) {
                this.showMulePropertiesView();
                this.multiPageMessageFlowEditor.addSavedListener(this.saveListener);
                this.multiPageMessageFlowEditor.addPageChangedListener((IPageChangedListener)this.pageChangeListener);
                IMuleProject muleProject = sourcepart.getFlowEditor().getMuleProject();
                editor.setMuleProject(muleProject);
                editor.setTitleHandler(this);
                editor.setEditor(sourcepart);
                this.open(editor);
                if (!editor.showDataSense()) {
                    this.hideMetadataViewer();
                } else if (this.metadataAction.isChecked()) {
                    this.showMetadataViewer();
                }
                return true;
            }
        }
        if (this.metadataAction.isDisplayed()) {
            this.showMetadataViewer();
        }
        this.showDefaultMessage();
        return false;
    }

    private void showMulePropertiesView() {
        try {
            IPreferenceStore preferenceStore = MuleUIPlugin.getDefault().getPreferenceStore();
            if (preferenceStore.getBoolean("show_mule_properties_view_on_selection")) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(ID, null, 2);
            }
        }
        catch (Exception ex) {
            MuleCorePlugin.logError((String)"Unexpected error activating view", (Throwable)ex);
        }
    }

    public void close() {
        this.doClose(true);
    }

    protected void doClose(boolean applyChanges) {
        if (this.isEditorOpened()) {
            if (this.isMetadataViewerOpen()) {
                this.metadataTreeExplorer.unregisterFromEvents();
            }
            this.closeCurrentEditor(applyChanges);
            this.showDefaultMessage();
        }
        this.unRegisterMultiPageListener();
        this.clearSelection();
    }

    private void clearSelection() {
        this.selectedNode = null;
        this.currentEditor = null;
        this.multiPageMessageFlowEditor = null;
        this.maybeDataSenseInfoProvider = Optional.empty();
    }

    protected void showDefaultMessage() {
        if (this.container.isDisposed()) {
            return;
        }
        this.containerStackLayout.topControl = this.text;
        this.setPartName(MULE_PROPERTIES_VIEW);
        this.setDescription("");
        this.container.layout();
        this.setImage(PropertiesImages.get().getImageByPath("icons/properties-24x16.png"));
        this.hideMetadataViewer();
        this.view.layout();
    }

    protected void closeCurrentEditor(boolean applyChanges) {
        try {
            block12: {
                this.isClosing = true;
                if (this.shownDialog != null) {
                    this.shownDialog.onClose();
                }
                IActionBars actionBars = this.getViewSite().getActionBars();
                IToolBarManager mgr = actionBars.getToolBarManager();
                IPropertiesEditor<GraphicalEditPart> tmpEditor = this.getCurrentEditor();
                this.setCurrentEditor(null);
                try {
                    try {
                        if (applyChanges) {
                            tmpEditor.apply(false);
                        }
                        tmpEditor.onClose();
                    }
                    catch (Exception e) {
                        Activator.logError("Un expected error while closing editor", e);
                        mgr.removeAll();
                        actionBars.updateActionBars();
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    mgr.removeAll();
                    actionBars.updateActionBars();
                    throw throwable;
                }
                mgr.removeAll();
                actionBars.updateActionBars();
            }
            if (this.currentEditorControl != null) {
                if (!this.currentEditorControl.isDisposed()) {
                    this.currentEditorControl.dispose();
                }
                this.currentEditorControl = null;
            }
        }
        finally {
            this.isClosing = false;
        }
    }

    public void open(IPropertiesEditor<GraphicalEditPart> editor) {
        try {
            IActionBars actionBars = this.getViewSite().getActionBars();
            DisposableToolbarManager mgr = new DisposableToolbarManager(actionBars.getToolBarManager());
            editor.setEditElement(this.selectedNode);
            long start = System.currentTimeMillis();
            Control editorContainer = editor.createControl(this.container);
            editor.onOpen();
            this.setCurrentEditor(editor);
            editor.addActions((IToolBarManager)mgr);
            mgr.add((IAction)this.applyAction);
            if (editor.showDataSense()) {
                mgr.add((IAction)this.metadataAction);
            }
            actionBars.updateActionBars();
            this.containerStackLayout.topControl = editorContainer;
            this.container.layout();
            long end = System.currentTimeMillis();
            long timeInMillis = end - start;
            Activator.debugTracer().trace(Activator.CREATE_UI_PERFORMANCE_ID, String.format("Editor [%s] took %s ms to render type [%s]", editor.getEditorId(), Long.toString(timeInMillis), editor.getContentDescriptor()));
            this.currentEditorControl = editorContainer;
        }
        catch (Exception e) {
            Activator.logError("Unexpected error while opening editor", e);
        }
    }

    protected void showMetadataViewer() {
        if (this.metadataTreeExplorer == null) {
            this.metadataTreeExplorer = new MetadataTreeExplorer(this.view, 0);
            GridData layoutData = new GridData(1040);
            layoutData.widthHint = 300;
            layoutData.minimumWidth = 300;
            this.metadataTreeExplorer.setLayoutData((Object)layoutData);
            this.view.layout();
        }
        if (this.multiPageMessageFlowEditor != null && this.selectedNode instanceof EntityEditPart && this.getCurrentEditor() != null) {
            this.metadataTreeExplorer.showLoadingIndicator();
            this.getDataSenseInfoProvider().ifPresent(dsip -> {
                if (dsip.isPropagationAvailable()) {
                    this.metadataTreeExplorer.updateMetadata(dsip.getPropagationInfo());
                }
            });
        }
    }

    public IMuleProject getMuleProject() {
        if (this.multiPageMessageFlowEditor != null) {
            return this.multiPageMessageFlowEditor.getFlowEditor().getMuleProject();
        }
        return null;
    }

    protected void hideMetadataViewer() {
        if (this.isMetadataViewerOpen()) {
            this.metadataTreeExplorer.dispose();
            this.metadataTreeExplorer = null;
            this.view.layout();
        }
    }

    public boolean isMetadataViewerOpen() {
        return this.metadataTreeExplorer != null;
    }

    private void reloadPropagationIfNecessary() {
        if (this.isMetadataViewerOpen() && !this.isClosing) {
            this.getDataSenseInfoProvider().ifPresent(infoProvider -> {
                if (infoProvider.getEntityMulePath().isPresent()) {
                    infoProvider.reloadPropagation();
                }
            });
        }
    }

    public GraphicalEditPart getSelectedEditPart(ISelection selection) {
        IStructuredSelection muleSelection = (IStructuredSelection)selection;
        Object firstElement = muleSelection.getFirstElement();
        if (firstElement instanceof GraphicalEditPart) {
            return (GraphicalEditPart)firstElement;
        }
        return null;
    }

    public void setFocus() {
        this.container.setFocus();
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener((ISelectionListener)this.selectionListener);
        this.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener2)this.viewEditorPartListener);
        this.eventBusHelper.unregister();
        this.multiPageMessageFlowEditor = null;
        this.currentEditor = null;
        super.dispose();
    }

    private void unRegisterMultiPageListener() {
        if (this.multiPageMessageFlowEditor != null) {
            this.multiPageMessageFlowEditor.removeSavedListener(this.saveListener);
            this.multiPageMessageFlowEditor.removePageChangedListener((IPageChangedListener)this.pageChangeListener);
        }
    }

    @Override
    public void setImage(Image image) {
        this.setTitleImage(image);
    }

    @Override
    public void setTooltip(String tooltip) {
        this.setTitleToolTip(tooltip);
    }

    @Override
    public void setDescription(String description) {
        this.setTitleToolTip(description);
    }

    @Override
    public void setTitleMessage(String title) {
        this.setPartName(StringUtils.abbreviate((String)title, (int)32));
    }

    protected boolean isEditorOpened() {
        return this.getCurrentEditor() != null;
    }

    public IPropertiesEditor<GraphicalEditPart> getCurrentEditor() {
        return this.currentEditor;
    }

    public void setCurrentEditor(IPropertiesEditor<GraphicalEditPart> currentEditor) {
        this.preEditorSet();
        this.currentEditor = currentEditor;
        this.postEditorSet();
    }

    private void preEditorSet() {
        if (this.currentEditor != null) {
            this.currentEditor.removeAllPropertyValueChangeListeners();
        }
    }

    private void postEditorSet() {
        if (this.currentEditor != null) {
            IPropertyValueChangeListener propertyListener = (propertyName, oldValue, newValue) -> {
                if ((propertyName.equals("config-ref") || propertyName.equals("connector-ref")) && this.metadataTreeExplorer != null) {
                    this.metadataTreeExplorer.enableOrDisableRefreshLink();
                }
            };
            this.currentEditor.addPropertyValueChangeListener(propertyListener);
        }
    }

    public MetadataTreeExplorer getMetadataTreeExplorer() {
        return this.metadataTreeExplorer;
    }

    public static MulePropertiesView show() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IViewPart showView = page.showView(ID, null, 2);
            return (MulePropertiesView)showView;
        }
        catch (PartInitException e) {
            Activator.logError("Un expected exception while trying to open properties window", e);
            return null;
        }
    }

    public static MulePropertiesView get() {
        Optional<MulePropertiesView> view = MulePropertiesView.getViewIfPresent();
        if (!view.isPresent()) {
            return MulePropertiesView.show();
        }
        return view.get();
    }

    public static Optional<MulePropertiesView> getViewIfPresent() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewReference[] viewReferences = page.getViewReferences();
        MulePropertiesView view = null;
        IViewReference[] iViewReferenceArray = viewReferences;
        int n = viewReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference viewReference = iViewReferenceArray[n2];
            if (viewReference.getId().equals(ID)) {
                view = (MulePropertiesView)viewReference.getView(false);
                break;
            }
            ++n2;
        }
        return Optional.ofNullable(view);
    }

    @Override
    public void markAsModified() {
        if (!this.getPartName().startsWith(MODIFIED_PREFIX)) {
            this.setPartName(MODIFIED_PREFIX + this.getPartName());
        }
    }

    @Override
    public void markAsSaved() {
        if (this.getPartName().startsWith(MODIFIED_PREFIX)) {
            this.setPartName(this.getPartName().substring(1));
        }
    }

    public Optional<MessageFlowEntity> getCurrentMessageFlowEntity() {
        if (this.selectedNode instanceof EntityEditPart) {
            return Optional.of(((EntityEditPart)this.selectedNode).getEntity());
        }
        return Optional.empty();
    }

    protected void initDataSenseInfo(MultiPageMessageFlowEditor multiPageMessageFlowEditor, GraphicalEditPart selectedNode) {
        if (multiPageMessageFlowEditor != null && selectedNode != null && selectedNode instanceof EntityEditPart) {
            MessageFlowEntity entity;
            MessageFlowEditor flowEditor = multiPageMessageFlowEditor.getFlowEditor();
            IMuleProject project = flowEditor.getMuleProject();
            MuleConfiguration muleConfiguration = multiPageMessageFlowEditor.getMuleConfiguration();
            MulePath mulePath = muleConfiguration.getPathFor((IMessageFlowEntity)(entity = ((EntityEditPart)selectedNode).getEntity()));
            if (mulePath != null) {
                this.maybeDataSenseInfoProvider = Optional.of(new DataSenseInfoProvider(MuleCorePlugin.getEventBus(), project, muleConfiguration, entity));
            }
        }
    }

    private final class ApplyAction
    extends Action {
        private ApplyAction() {
            super("Apply");
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_SAVE_EDIT"));
            this.setTooltip();
        }

        private void setTooltip() {
            this.setToolTipText("Apply Changes");
        }

        public void run() {
            MulePropertiesView.this.getCurrentEditor().apply(true);
            if (MulePropertiesView.this.multiPageMessageFlowEditor != null) {
                MulePropertiesView.this.multiPageMessageFlowEditor.doSave((IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    private static class DeleteOrCloseProjectListener
    implements IMuleProjectEventListener {
        private final MulePropertiesView mulePropertiesView;

        public DeleteOrCloseProjectListener(MulePropertiesView mulePropertiesView) {
            this.mulePropertiesView = mulePropertiesView;
        }

        public void onMuleProjectOpened(IProject project) {
        }

        public void onMuleProjectClosed(IProject project) {
            FileEditorInput editorInput;
            MultiPageMessageFlowEditor multiPageMessageFlowEditor = this.mulePropertiesView.multiPageMessageFlowEditor;
            if (multiPageMessageFlowEditor != null && (editorInput = (FileEditorInput)multiPageMessageFlowEditor.getEditorInput()).getFile().getProject().equals((Object)project)) {
                Display.getDefault().asyncExec(this.mulePropertiesView::close);
            }
        }
    }

    private final class DialogCloserListener<T extends IPropertiesViewDialog>
    implements IPropertiesViewDialog.OnPropertiesFinishedCallback<T> {
        private final boolean wasMetadataViewerShown;
        private final Control displayedControl;
        private final IPropertiesViewDialog.OnPropertiesFinishedCallback<T> callback;

        private DialogCloserListener(boolean wasMetadataViewerShown, Control displayedControl, IPropertiesViewDialog.OnPropertiesFinishedCallback<T> callback) {
            this.wasMetadataViewerShown = wasMetadataViewerShown;
            this.displayedControl = displayedControl;
            this.callback = callback;
        }

        @Override
        public void onFinished(T dialog) {
            try {
                this.callback.onFinished(dialog);
            }
            finally {
                Control oldControl = MulePropertiesView.this.containerStackLayout.topControl;
                MulePropertiesView.this.containerStackLayout.topControl = this.displayedControl;
                MulePropertiesView.this.container.layout();
                oldControl.dispose();
                if (!MulePropertiesView.this.isMetadataViewerOpen() && this.wasMetadataViewerShown && MulePropertiesView.this.metadataAction != null) {
                    MulePropertiesView.this.metadataAction.run();
                }
                MulePropertiesView.this.container.getParent().layout(true);
                MulePropertiesView.this.shownDialog = null;
            }
        }
    }

    private final class EditorPartListener
    implements IPartListener2 {
        private static final String MULE_PROPERTIES_VIEW_ID = "org.mule.tooling.properties.views.MulePropertiesView";
        private static final String MESSAGEFLOW_MESSAGE_FLOW_EDITOR_ID = "org.mule.tooling.messageflow.messageFlowEditor";
        private IContextActivation propertiesContextActivation;

        private EditorPartListener() {
        }

        public void partVisible(IWorkbenchPartReference arg0) {
        }

        public boolean isMessageFlowEditor(IWorkbenchPartReference arg0) {
            return MESSAGEFLOW_MESSAGE_FLOW_EDITOR_ID.equals(arg0.getId());
        }

        public void partOpened(IWorkbenchPartReference arg0) {
        }

        public void partInputChanged(IWorkbenchPartReference arg0) {
        }

        public void partHidden(IWorkbenchPartReference arg0) {
            if (MulePropertiesView.this.isEditorOpened() && this.isMessageFlowEditor(arg0) && !MulePropertiesView.this.getCurrentEditor().requiresMultiPageEditorShown()) {
                MulePropertiesView.this.close();
            }
        }

        public void partDeactivated(IWorkbenchPartReference arg0) {
            if (this.isPartMulePropertiesView(arg0)) {
                Display.getCurrent().asyncExec(() -> {
                    if (MulePropertiesView.this.isEditorOpened()) {
                        try {
                            MulePropertiesView.this.getCurrentEditor().apply(false);
                        }
                        catch (Exception e) {
                            Activator.logError("Un expected error while appling changes", e);
                            MulePropertiesView.this.close();
                        }
                    }
                });
                if (this.propertiesContextActivation != null) {
                    IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
                    contextService.deactivateContext(this.propertiesContextActivation);
                }
            }
        }

        protected boolean isPartMulePropertiesView(IWorkbenchPartReference arg0) {
            return "org.mule.tooling.properties.views.MulePropertiesView".equals(arg0.getId());
        }

        public void partClosed(IWorkbenchPartReference arg0) {
            if (this.isPartMulePropertiesView(arg0)) {
                if (MulePropertiesView.this.isEditorOpened()) {
                    MulePropertiesView.this.close();
                }
            } else if (this.isMessageFlowEditor(arg0)) {
                MulePropertiesView.this.multiPageMessageFlowEditor = null;
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference arg0) {
        }

        public void partActivated(IWorkbenchPartReference arg0) {
            IWorkbenchPart editor;
            if (this.isPartMulePropertiesView(arg0)) {
                IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
                this.propertiesContextActivation = contextService.activateContext("org.mule.tooling.contexts.mulePropertiesEditor");
            } else if (!MulePropertiesView.this.isEditorOpened() && this.isMessageFlowEditor(arg0) && (editor = arg0.getPart(true)) instanceof MultiPageMessageFlowEditor) {
                MultiPageMessageFlowEditor multiPageEditor = (MultiPageMessageFlowEditor)editor;
                MulePropertiesView.this.showSelection(multiPageEditor, (ISelection)StructuredSelection.EMPTY);
            }
        }
    }

    private final class EditorSaveListener
    implements IMessageFlowEditorSavedListener {
        private EditorSaveListener() {
        }

        public void onBeforeSave() {
            if (MulePropertiesView.this.isEditorOpened()) {
                MulePropertiesView.this.getCurrentEditor().onSave();
            }
        }

        public void onAfterSave() {
        }
    }

    private class FlowEditorPageChangeListener
    implements IPageChangedListener {
        private FlowEditorPageChangeListener() {
        }

        public void pageChanged(PageChangedEvent event) {
            Object selectedPage = event.getSelectedPage();
            if (selectedPage instanceof MessageFlowEditor) {
                MulePropertiesView.this.showSelection(MessageFlowUtils.getMultiPageMessageFlowEditor(), ((MessageFlowEditor)selectedPage).getSelection());
            } else if (MulePropertiesView.this.isEditorOpened()) {
                MulePropertiesView.this.close();
            }
        }
    }

    private final class MetadataAction
    extends Action {
        private boolean displayed;

        private MetadataAction() {
            super("Metadata", 8);
            this.setImageDescriptor(PropertiesImages.get().getImageDescriptor("icons/metadata.png"));
            this.displayed = true;
            this.setChecked(true);
        }

        public void run() {
            this.setChecked(!this.displayed);
            this.displayed = this.isChecked();
            if (this.isChecked()) {
                MulePropertiesView.this.showMetadataViewer();
            } else {
                MulePropertiesView.this.hideMetadataViewer();
            }
        }

        public boolean isDisplayed() {
            return this.displayed;
        }
    }

    private class MuleSelectionListener
    implements ISelectionListener {
        private MuleSelectionListener() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (part instanceof MultiPageMessageFlowEditor) {
                MultiPageMessageFlowEditor multiPageFlowEditor = (MultiPageMessageFlowEditor)part;
                if (selection.isEmpty()) {
                    if (MulePropertiesView.this.isEditorOpened()) {
                        MulePropertiesView.this.close();
                    }
                } else if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    Object firstElement = structuredSelection.getFirstElement();
                    if (firstElement instanceof MuleConfigurationEditPart) {
                        ISelection selectedElement = multiPageFlowEditor.getFlowEditor().getSelection();
                        MulePropertiesView.this.showSelectionAsynchronously(multiPageFlowEditor, selectedElement, null);
                    } else {
                        MulePropertiesView.this.showSelectionAsynchronously(multiPageFlowEditor, selection, null);
                    }
                }
            }
        }
    }
}

