/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.properties.views;

import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.mule.tooling.properties.views.IPropertiesViewDialog;
import org.mule.tooling.ui.widgets.SquareButton;
import org.mule.tooling.ui.widgets.script.SharedColors;
import org.mule.tooling.ui.widgets.util.WidgetUtils;

public class MulePropertiesInternalDialog<T extends IPropertiesViewDialog>
extends Composite {
    private static final String DONE = "Done";
    private static final String TITLE_FONT = "org.mule.tooling.properties.views.MulePropertiesInternalDialogTitle";
    private static final SharedColors colors = new SharedColors();
    public static final Color TITLE_COLOR = colors.getColor(new RGB(225, 225, 225));
    public static final Color BACKGROUND_COLOR = colors.getColor(new RGB(248, 248, 248));
    public static final Color ERROR_COLOR = colors.getColor(new RGB(255, 0, 0));
    public static final int TOOLBAR_HEIGHT = 36;
    public static final Color WHITE = Display.getCurrent().getSystemColor(1);
    private T dialog;
    private IPropertiesViewDialog.OnPropertiesFinishedCallback<T> onMinimize;

    public MulePropertiesInternalDialog(Composite parent, int style, T dialog, IPropertiesViewDialog.OnPropertiesFinishedCallback<T> onMinimize) {
        super(parent, style);
        this.dialog = dialog;
        this.onMinimize = onMinimize;
        this.createControl();
    }

    private void createControl() {
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).applyTo((Composite)this);
        Composite toolbarContainer = new Composite((Composite)this, 2048);
        toolbarContainer.setBackground(TITLE_COLOR);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)toolbarContainer);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(3).extendedMargins(0, 5, 4, 0).applyTo(toolbarContainer);
        Label title = new Label(toolbarContainer, 0);
        title.setFont(this.getTitleFont());
        TitleManager titleManager = new TitleManager(title);
        GridDataFactory.fillDefaults().grab(true, false).align(16384, 0x1000000).applyTo((Control)title);
        ToolBar toolBar = new ToolBar(toolbarContainer, 0);
        ToolBarManager toolBarManager = new ToolBarManager(toolBar);
        GridDataFactory.fillDefaults().grab(true, false).align(131072, 0x1000000).applyTo((Control)toolBar);
        Composite windowContainer = new Composite((Composite)this, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)windowContainer);
        windowContainer.setLayout((Layout)new FillLayout());
        this.dialog.create(windowContainer, toolBarManager, titleManager);
        SquareButton button = WidgetUtils.createSquareButton((Composite)toolbarContainer, (String)DONE, this::onClose);
        GridDataFactory.fillDefaults().hint(75, -1).applyTo((Control)button);
        toolBarManager.update(true);
    }

    public Font getTitleFont() {
        if (!JFaceResources.getFontRegistry().hasValueFor(TITLE_FONT)) {
            FontData[] fontData = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont").getFontData();
            JFaceResources.getFontRegistry().put(TITLE_FONT, fontData);
        }
        Font font = JFaceResources.getFont((String)TITLE_FONT);
        return font;
    }

    public void onOpen() {
        this.dialog.onOpen();
    }

    public void onClose() {
        this.onMinimize.onFinished(this.dialog);
        this.dialog.doClose();
    }

    static class TitleManager
    implements IPropertiesViewDialog.ITitleManager {
        private Label label;

        public TitleManager(Label label) {
            this.label = label;
        }

        @Override
        public void setTitle(String title) {
            if (title != null) {
                this.label.setText(title);
                this.label.getParent().layout();
            }
        }

        @Override
        public void setModified() {
            String text = this.label.getText();
            if (!text.startsWith("*")) {
                this.label.setText("*" + this.label.getText());
                this.label.getParent().layout();
            }
        }

        @Override
        public void setUnModified() {
            String text = this.label.getText();
            if (text.startsWith("*")) {
                this.label.setText(this.label.getText().substring(1));
                this.label.getParent().layout();
            }
        }
    }
}

