/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.properties.editor;

import java.util.Optional;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.icons.ImagesManager;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.editpart.UnknownEditPart;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.UnknownNode;
import org.mule.tooling.properties.editor.IPropertiesEditor;
import org.mule.tooling.properties.editor.IPropertiesTitle;
import org.mule.tooling.ui.modules.core.properties.IMessageFlowNodePropertyManager;
import org.mule.tooling.ui.modules.core.properties.IPropertyValueChangeListener;

public class UnknownElementPropertiesEditor
implements IPropertiesEditor<UnknownEditPart> {
    private UnknownEditPart element;
    private IPropertiesTitle titleHandler;
    private Text text;

    @Override
    public boolean handles(Object element) {
        return element instanceof UnknownEditPart;
    }

    @Override
    public boolean showDataSense() {
        return true;
    }

    @Override
    public void setTitleHandler(IPropertiesTitle titleHandler) {
        this.titleHandler = titleHandler;
    }

    @Override
    public void setEditElement(UnknownEditPart element) {
        this.element = element;
    }

    @Override
    public void setMuleProject(IMuleProject project) {
    }

    @Override
    public Control createControl(Composite parent) {
        this.text = new Text(parent, 2050);
        this.text.setEditable(false);
        this.text.setLayoutData((Object)new GridData(1808));
        return this.text;
    }

    @Override
    public void addActions(IToolBarManager toolbar) {
    }

    @Override
    public void setEditor(MultiPageMessageFlowEditor editor) {
    }

    @Override
    public void apply(boolean force) {
        ((UnknownNode)this.element.getEntity()).setContent(this.text.getText());
    }

    @Override
    public void onClose() {
    }

    @Override
    public void onSave() {
    }

    @Override
    public void onOpen() {
        this.text.setText(((UnknownNode)this.element.getEntity()).getContent());
        this.titleHandler.setDescription("Unknown Element");
        this.titleHandler.setTitleMessage(MessageFlowUtils.getUnknownName((UnknownNode)((UnknownNode)this.element.getEntity())));
        this.titleHandler.setImage(ImagesManager.getInstance().getPaletteUnknown());
    }

    @Override
    public boolean requiresMultiPageEditorShown() {
        return false;
    }

    @Override
    public Optional<IMessageFlowNodePropertyManager> getPropertiesManager() {
        return Optional.empty();
    }

    @Override
    public void addPropertyValueChangeListener(IPropertyValueChangeListener propertyListener) {
    }

    @Override
    public void removeAllPropertyValueChangeListeners() {
    }

    @Override
    public String getHelpURL() {
        return "";
    }

    @Override
    public String getContentDescriptor() {
        QName qName = ((UnknownNode)this.element.getEntity()).getElement().getQName();
        String namespaceURI = qName.getNamespaceURI();
        return (StringUtils.isEmpty((String)namespaceURI) ? qName.getPrefix() : namespaceURI) + "/" + qName.getLocalPart();
    }
}

