/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.properties.editor;

import java.util.Optional;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.properties.editor.IPropertiesEditor;
import org.mule.tooling.properties.editor.IPropertiesTitle;
import org.mule.tooling.ui.modules.core.properties.IMessageFlowNodePropertyManager;
import org.mule.tooling.ui.modules.core.properties.IPropertyValueChangeListener;

public class ReadOnlyElementPropertiesEditor<T extends EntityEditPart<? extends IMessageFlowNode>>
implements IPropertiesEditor<T> {
    private IPropertiesTitle titleHandler;
    private T element;
    private Text txtDescription;
    private Group docGroup;

    @Override
    public boolean handles(Object element) {
        return true;
    }

    @Override
    public boolean showDataSense() {
        return false;
    }

    @Override
    public void setTitleHandler(IPropertiesTitle titleHandler) {
        this.titleHandler = titleHandler;
    }

    @Override
    public void setEditElement(T element) {
        this.element = element;
    }

    public IMessageFlowNode getMessageFlowNode() {
        return (IMessageFlowNode)this.element.getEntity();
    }

    @Override
    public void setMuleProject(IMuleProject project) {
    }

    @Override
    public Control createControl(Composite parent) {
        this.docGroup = new Group(parent, 0);
        GridLayout docLayout = new GridLayout(1, false);
        docLayout.horizontalSpacing = 10;
        this.docGroup.setLayout((Layout)docLayout);
        this.docGroup.setLayoutData((Object)new GridData(1808));
        Label descLabel = new Label((Composite)this.docGroup, 0);
        descLabel.setText("Read only content:");
        descLabel.setLayoutData((Object)new GridData(2));
        this.txtDescription = new Text((Composite)this.docGroup, 2114);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        this.txtDescription.setEnabled(false);
        this.txtDescription.setLayoutData((Object)data);
        Composite commentComposite = new Composite((Composite)this.docGroup, 0);
        commentComposite.setLayout((Layout)new GridLayout(3, false));
        return this.docGroup;
    }

    @Override
    public void addActions(IToolBarManager toolbar) {
    }

    @Override
    public void setEditor(MultiPageMessageFlowEditor editor) {
    }

    @Override
    public void apply(boolean force) {
    }

    @Override
    public void onClose() {
    }

    @Override
    public void onSave() {
    }

    @Override
    public void onOpen() {
        this.txtDescription.setText(this.getMessageFlowNode().getElement().asXML());
        this.titleHandler.setTitleMessage(this.getMessageFlowNode().getName());
        this.titleHandler.setImage(this.getMessageFlowNode().getDefinition().getIconImage());
    }

    @Override
    public boolean requiresMultiPageEditorShown() {
        return false;
    }

    @Override
    public Optional<IMessageFlowNodePropertyManager> getPropertiesManager() {
        return Optional.empty();
    }

    @Override
    public void addPropertyValueChangeListener(IPropertyValueChangeListener propertyListener) {
    }

    @Override
    public void removeAllPropertyValueChangeListeners() {
    }

    @Override
    public String getHelpURL() {
        return "";
    }

    @Override
    public String getContentDescriptor() {
        QName qName = this.getMessageFlowNode().getElement().getQName();
        String namespaceURI = qName.getNamespaceURI();
        return (StringUtils.isEmpty((String)namespaceURI) ? qName.getPrefix() : namespaceURI) + "/" + qName.getLocalPart();
    }
}

