/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.properties.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.properties.editor.IPropertiesEditor;
import org.mule.tooling.properties.editor.IPropertiesTitle;
import org.mule.tooling.ui.widgets.action.DropdownAction;
import org.mule.tooling.utils.eventbus.EventBus;

public abstract class MultiPagePropertiesEditor<T>
implements IPropertiesEditor<T> {
    private List<PropertiesEditorDescriptor> editorDescriptors;
    private List<EditorPosition> editorControls;
    private Composite container;
    private StackLayout layout;
    private T element;
    private IToolBarManager toolbar;
    private EditorPosition selectedEditor;
    private EventBus bus;
    private IPropertiesTitle titleHandler;
    private IContributionItem[] defaultToolBarItems;
    private MultiPageMessageFlowEditor editor;
    private IMuleProject project;

    public MultiPagePropertiesEditor() {
        this.setBus(new EventBus(true));
        this.editorControls = new ArrayList<EditorPosition>();
        this.editorDescriptors = new ArrayList<PropertiesEditorDescriptor>();
        this.addPages();
    }

    protected abstract void addPages();

    protected abstract void setup();

    @Override
    public boolean requiresMultiPageEditorShown() {
        return this.getCurrentEditor() != null && this.getCurrentEditor().requiresMultiPageEditorShown();
    }

    public MultiPageMessageFlowEditor getEditor() {
        return this.editor;
    }

    public IMuleProject getProject() {
        return this.project;
    }

    @Override
    public void setTitleHandler(IPropertiesTitle titleHandler) {
        this.titleHandler = titleHandler;
        for (PropertiesEditorDescriptor editorDescriptor : this.editorDescriptors) {
            editorDescriptor.getEditor().setTitleHandler(titleHandler);
        }
    }

    public IPropertiesTitle getTitleHandler() {
        return this.titleHandler;
    }

    public T getElement() {
        return this.element;
    }

    @Override
    public void setEditElement(T element) {
        this.element = element;
        for (PropertiesEditorDescriptor editorDescriptor : this.editorDescriptors) {
            editorDescriptor.getEditor().setEditElement(element);
        }
    }

    @Override
    public void setMuleProject(IMuleProject project) {
        this.project = project;
        for (PropertiesEditorDescriptor editorDescriptor : this.editorDescriptors) {
            editorDescriptor.getEditor().setMuleProject(project);
        }
    }

    @Override
    public Control createControl(Composite parent) {
        this.setup();
        this.container = new Composite(parent, 0);
        this.layout = new StackLayout();
        this.container.setLayout((Layout)this.layout);
        EditorPosition toSelect = null;
        int index = 0;
        for (PropertiesEditorDescriptor editorDescriptor : this.editorDescriptors) {
            Control editorControl = editorDescriptor.getEditor().createControl(this.container);
            EditorPosition e = new EditorPosition(index, editorControl);
            this.editorControls.add(e);
            if (editorDescriptor.getEditor().handles(this.element) && toSelect == null) {
                toSelect = e;
            }
            ++index;
        }
        this.showPage(toSelect);
        return this.container;
    }

    protected Composite getContainer() {
        return this.container;
    }

    protected void updateSelectedEditor() {
        if (this.selectedEditor != null) {
            this.toolbar.removeAll();
            this.editorDescriptors.get(this.selectedEditor.getIndex()).getEditor().addActions(this.toolbar);
            ArrayList<1> viewActions = new ArrayList<1>();
            for (EditorPosition editorPosition : this.editorControls) {
                int hidenEditorIndex;
                PropertiesEditorDescriptor hidenEditorDescriptor;
                if (this.selectedEditor == editorPosition || !(hidenEditorDescriptor = this.editorDescriptors.get(hidenEditorIndex = editorPosition.getIndex())).getEditor().handles(this.element)) continue;
                ImageDescriptor actionImage = hidenEditorDescriptor.getImage();
                String actionDescription = hidenEditorDescriptor.getDescription();
                viewActions.add(new Action(actionDescription, actionImage){

                    public void run() {
                        MultiPagePropertiesEditor.this.showPage(hidenEditorIndex);
                    }
                });
            }
            if (!viewActions.isEmpty()) {
                if (viewActions.size() == 1) {
                    this.toolbar.add((IAction)viewActions.get(0));
                } else {
                    PropertiesEditorDescriptor descriptor = this.editorDescriptors.get(this.selectedEditor.getIndex());
                    DropdownAction switchAction = new DropdownAction(descriptor.getDescription(), descriptor.getImage(), (Control)((ToolBarManager)this.toolbar).getControl());
                    switchAction.addAll(viewActions);
                    this.toolbar.add((IAction)switchAction);
                }
            }
            this.addDefaultItems(this.toolbar);
            this.layout.topControl = this.selectedEditor.getEditorControl();
            this.container.layout();
            this.toolbar.update(true);
        }
    }

    protected void addDefaultItems(IToolBarManager toolbar) {
        IContributionItem[] iContributionItemArray = this.defaultToolBarItems;
        int n = this.defaultToolBarItems.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            toolbar.add(item);
            ++n2;
        }
    }

    public void addPage(IPropertiesEditor<T> editor, ImageDescriptor image, String description) {
        this.editorDescriptors.add(new PropertiesEditorDescriptor(editor, image, description));
    }

    @Override
    public void addActions(IToolBarManager toolbar) {
        this.toolbar = toolbar;
        this.defaultToolBarItems = toolbar.getItems();
    }

    @Override
    public void setEditor(MultiPageMessageFlowEditor multiPage) {
        this.editor = multiPage;
        for (PropertiesEditorDescriptor editorDescriptor : this.editorDescriptors) {
            editorDescriptor.getEditor().setEditor(multiPage);
        }
    }

    @Override
    public void apply(boolean force) {
        if (this.selectedEditor != null) {
            this.editorDescriptors.get(this.selectedEditor.getIndex()).getEditor().apply(force);
            this.updateSelectedEditor();
        }
    }

    @Override
    public void onClose() {
        if (this.selectedEditor != null) {
            this.closeSelectedEditor();
            this.selectedEditor = null;
            this.editorControls.clear();
            this.bus.cleanAllListeners();
        }
    }

    @Override
    public void onSave() {
        this.editorDescriptors.get(this.selectedEditor.getIndex()).getEditor().onSave();
    }

    @Override
    public void onOpen() {
    }

    public EventBus getBus() {
        return this.bus;
    }

    public void setBus(EventBus bus) {
        this.bus = bus;
    }

    protected void showPage(int hideEditorIndex) {
        this.showPage(this.getEditor(hideEditorIndex));
    }

    protected EditorPosition getEditor(int editorIndex) {
        return editorIndex < this.editorControls.size() ? this.editorControls.get(editorIndex) : null;
    }

    protected void showPage(EditorPosition editorPosition) {
        this.applySelectedEditor();
        if (this.editorDescriptors.get(editorPosition.getIndex()).getEditor().handles(this.element)) {
            if (this.selectedEditor != null) {
                this.closeSelectedEditor();
            }
            this.doShowPage(editorPosition);
        }
    }

    protected void applySelectedEditor() {
        if (this.selectedEditor != null) {
            this.editorDescriptors.get(this.selectedEditor.getIndex()).getEditor().apply(false);
        }
    }

    protected void closeSelectedEditor() {
        IPropertiesEditor<T> currentEditor = this.getCurrentEditor();
        if (currentEditor != null) {
            currentEditor.onClose();
        }
    }

    public IPropertiesEditor<T> getCurrentEditor() {
        IPropertiesEditor currentEditor = null;
        if (this.selectedEditor != null) {
            currentEditor = this.editorDescriptors.get(this.selectedEditor.getIndex()).getEditor();
        }
        return currentEditor;
    }

    protected void doShowPage(EditorPosition editorPosition) {
        this.selectedEditor = editorPosition;
        this.updateSelectedEditor();
        if (this.selectedEditor != null) {
            this.editorDescriptors.get(this.selectedEditor.getIndex()).getEditor().onOpen();
        }
    }

    private class EditorPosition {
        private int index;
        private Control editorControl;

        public EditorPosition(int index, Control editorControl) {
            this.index = index;
            this.editorControl = editorControl;
        }

        public int getIndex() {
            return this.index;
        }

        public Control getEditorControl() {
            return this.editorControl;
        }
    }

    private class PropertiesEditorDescriptor {
        private IPropertiesEditor<T> editor;
        private ImageDescriptor image;
        private String description;

        public PropertiesEditorDescriptor(IPropertiesEditor<T> editor, ImageDescriptor image, String description) {
            this.editor = editor;
            this.image = image;
            this.description = description;
        }

        public IPropertiesEditor<T> getEditor() {
            return this.editor;
        }

        public ImageDescriptor getImage() {
            return this.image;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

