/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.properties.editor;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IHelpResource;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.cache.IMuleConfigurationsCache;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.command.AppendChildCommand;
import org.mule.tooling.messageflow.command.RenameContainerRefNameCommand;
import org.mule.tooling.messageflow.command.RenameEntityCommand;
import org.mule.tooling.messageflow.command.RenameErrorHandlerReferencesCommand;
import org.mule.tooling.messageflow.command.RenameFlowReferencesCommand;
import org.mule.tooling.messageflow.command.UpdateEntityDescriptionCommand;
import org.mule.tooling.messageflow.command.UpdateFlowCommand;
import org.mule.tooling.messageflow.command.UpdatePropertiesCommand;
import org.mule.tooling.messageflow.dialog.DialogStack;
import org.mule.tooling.messageflow.dialog.IDialogController;
import org.mule.tooling.messageflow.dialog.ISimpleHost;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.editpart.CollapsibleContainerEditPart;
import org.mule.tooling.messageflow.editpart.ContainerEditPart;
import org.mule.tooling.messageflow.editpart.EndpointEditPart;
import org.mule.tooling.messageflow.editpart.EntityEditPart;
import org.mule.tooling.messageflow.editpart.NestedContainerEditPart;
import org.mule.tooling.messageflow.editpart.PatternEditPart;
import org.mule.tooling.messageflow.editpart.RouteEditPart;
import org.mule.tooling.metadata.custom.metadata.assistant.CustomMetadataAssistantService;
import org.mule.tooling.metadata.datasense.DataSenseJob;
import org.mule.tooling.model.messageflow.ComponentId;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.Event;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IPropertyCollectionReadCapability;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.properties.editor.IPropertiesEditor;
import org.mule.tooling.properties.editor.IPropertiesTitle;
import org.mule.tooling.properties.views.ui.IMessageFlowEntityUIEditor;
import org.mule.tooling.properties.views.ui.NodePropertiesUIEditor;
import org.mule.tooling.ui.modules.core.properties.IMessageFlowNodePropertyManager;
import org.mule.tooling.ui.modules.core.properties.IPropertyValueChangeListener;
import org.mule.tooling.ui.modules.core.widgets.IForceSave;
import org.mule.tooling.ui.widgets.errors.ErrorActionDialog;
import org.mule.tooling.ui.widgets.util.ComparatorUtils;

public class EntityEditPartPropertiesEditor<T extends EntityEditPart<? extends IMessageFlowNode>>
implements IPropertiesEditor<T> {
    private IMessageFlowEntityUIEditor nodePropertiesEditorHandler;
    private IPropertiesTitle titleHandler;
    private T element;
    private IMuleProject project;
    private MultiPageMessageFlowEditor editor;
    private PropertyCollection before;
    private PropertyCollection effectiveOriginal;
    private List<ObserverReference> observers = new ArrayList<ObserverReference>();
    private NodeDefinition definition;
    private String originalDescription;
    private String originalName;
    private PropertyCollectionMap updatedPropertyCollection;
    private static final String DIALOG_TITLE = "Error when propagating metadata";
    private static final String DIALOG_BODY = "There is more than one flow with the name %s, fix that in order to propagate.";

    protected void installObserver() {
        IMessageFlowNode messageFlowNode = this.getMessageFlowNode();
        if (messageFlowNode instanceof Observable) {
            this.createRefAndAddToObservers((Observable)messageFlowNode, new ModelChangedObserver());
            this.createRefAndAddToObservers((Observable)messageFlowNode, new NameChangedObserver(), false);
        }
    }

    @Override
    public void setTitleHandler(IPropertiesTitle titleHandler) {
        this.titleHandler = titleHandler;
    }

    @Override
    public void setEditElement(T element) {
        this.element = element;
    }

    @Override
    public void setMuleProject(IMuleProject project) {
        this.project = project;
    }

    @Override
    public void setEditor(MultiPageMessageFlowEditor editor) {
        this.editor = editor;
    }

    public MultiPageMessageFlowEditor getEditor() {
        return this.editor;
    }

    @Override
    public void apply(boolean force) {
        this.unRegisterObservers(true);
        PropertyCollection updated = this.generateUpdatedProperties(force);
        try {
            CompoundCommand applyCommand = this.createChangeCommands(force, updated);
            this.applyChangesIfAny(applyCommand);
        }
        finally {
            this.registerObservers(true);
            if (this.getBefore() != null && this.getBefore().getProperty("name") != null) {
                IMessageFlowNode entity = (IMessageFlowNode)this.getElement().getEntity();
                this.originalName = this.getEntityName(entity, updated);
                this.titleHandler.setTitleMessage(this.originalName);
            }
            this.titleHandler.markAsSaved();
        }
    }

    private String getEntityName(IMessageFlowNode entity, PropertyCollection updated) {
        String displayNameAttribute = entity.getDefinition().getDisplayNameAtribute();
        String entityName = updated.getProperty(displayNameAttribute) != null ? updated.getProperty(displayNameAttribute).getValue() : entity.getName();
        return entityName;
    }

    protected void unRegisterObservers(boolean isOnApply) {
        ArrayList<ObserverReference> toRemove = new ArrayList<ObserverReference>();
        for (ObserverReference observer : this.observers) {
            if (observer.toDispose()) {
                toRemove.add(observer);
                continue;
            }
            if (isOnApply && !observer.isUnregisterOnApply()) continue;
            observer.unregister();
        }
        this.observers.removeAll(toRemove);
    }

    public PropertyCollection generateUpdatedProperties(boolean force) {
        PropertyCollectionMap updatedProperties = this.generateUpdatedProperties();
        PropertyCollection updated = PropertiesUtils.getEffectivePropertyCollection((PropertyCollection)updatedProperties.asPropertyCollection());
        IDialogController service = (IDialogController)this.definition.getService(IDialogController.class);
        if ((force || !updated.equals((Object)this.getBefore()) || this.getNodePropertiesEditorHandler().hasToForceSave() || service instanceof IForceSave && ((IForceSave)service).hasToForceSave(this.editor.getMuleConfiguration(), this.getProject(), this.getMessageFlowNode())) && service != null) {
            service.doUpdate((ISimpleHost)this.getNodePropertiesEditorHandler().getPageHost(), updatedProperties, this.definition, this.project, this.editor.getMuleConfiguration());
            updated = updatedProperties.asPropertyCollection();
        }
        return updated;
    }

    public CompoundCommand createChangeCommands(boolean force, PropertyCollection updated) {
        CompoundCommand applyCommand = new CompoundCommand("Apply changes to " + this.originalName);
        IMessageFlowNode entity = (IMessageFlowNode)this.getElement().getEntity();
        PropertyCollection effectiveNew = PropertiesUtils.getEffectivePropertyCollection((PropertyCollection)updated);
        if (force || !effectiveNew.equals((Object)this.effectiveOriginal) || this.getNodePropertiesEditorHandler().hasToForceSave()) {
            EntityDecorator entityDecorator = this.element.getEntityDecorator();
            this.setBefore(this.getUpdatedProperties().asPropertyCollection());
            String newName = this.getEntityName(entity, updated);
            if (newName != null && ComparatorUtils.different((Object)this.originalName, (Object)newName)) {
                IMuleConfigurationsCache configurationsCache = this.project.getConfigurationsCache();
                IFile inputXmlConfigFile = this.editor.getFlowEditor().getInputXmlConfigFile();
                configurationsCache.savePreviousRelatedConfigs(inputXmlConfigFile);
                String modelType = entity.getType();
                if (modelType.equals("http://www.mulesoft.org/schema/mule/core/flow-ref") || modelType.equals("http://www.mulesoft.org/schema/mule/batch/execute")) {
                    applyCommand.add((Command)new RenameContainerRefNameCommand(entity, this.originalName, newName, this.effectiveOriginal, effectiveNew));
                } else {
                    applyCommand.add((Command)new RenameEntityCommand(entity, this.originalName, newName));
                }
                if (ModelUtils.isFlowOrSubflow((IMessageFlowEntity)entity)) {
                    applyCommand.add((Command)new RenameFlowReferencesCommand(entity, this.originalName, newName));
                } else if (ModelUtils.isErrorHandler((IMessageFlowEntity)entity)) {
                    applyCommand.add((Command)new RenameErrorHandlerReferencesCommand(entity, this.originalName, newName));
                }
            }
            if (ComparatorUtils.different((Object)this.originalDescription, (Object)entity.getDescription())) {
                applyCommand.add((Command)new UpdateEntityDescriptionCommand(entity, this.originalDescription, entity.getDescription()));
            }
            UpdatePropertiesCommand updateCommand = new UpdatePropertiesCommand(this.project, null, entityDecorator, this.getMessageFlowNode().getProperties(), updated);
            if (((IMessageFlowNode)this.getElement().getEntity()).getDefinition().getId().equals("http://www.mulesoft.org/schema/mule/core/error-handler") && updated.getProperty("ref") != null) {
                CollapsibleContainerEditPart parent = (CollapsibleContainerEditPart)((NestedContainerEditPart)this.getElement()).getParent();
                UpdateFlowCommand compoundCommand = new UpdateFlowCommand(this.editor);
                compoundCommand.add((Command)updateCommand);
                compoundCommand.add((Command)new AppendChildCommand(this.getElement().getEntity(), ((EntityDecorator)parent.getModel()).getEntity().getElement(), this.project, this.editor.getMuleConfiguration(), "error-handler"));
                applyCommand.add((Command)compoundCommand);
            } else {
                applyCommand.add((Command)updateCommand);
            }
        }
        return applyCommand;
    }

    public void applyChangesIfAny(CompoundCommand applyCommand) {
        if (!applyCommand.getCommands().isEmpty()) {
            this.getEditor().getFlowEditor().getEditDomain().getCommandStack().execute((Command)applyCommand);
            if (applyCommand.getLabel() != null && ModelUtils.isFlowRef((IMessageFlowNode)this.getMessageFlowNode())) {
                String newValueStr;
                Optional<Command> optionalUpdateCommand = applyCommand.getCommands().stream().filter(UpdatePropertiesCommand.class::isInstance).findFirst();
                Optional<IReadOnlyProperty> oldValue = optionalUpdateCommand.map(command -> (IReadOnlyProperty)((UpdatePropertiesCommand)command).getBefore().getProperty("name"));
                Optional<IReadOnlyProperty> newValue = optionalUpdateCommand.map(command -> ((UpdatePropertiesCommand)command).getAfter().getProperty("name"));
                String oldValueStr = oldValue.isPresent() ? oldValue.get().getValue() : "";
                String string = newValueStr = newValue.isPresent() ? newValue.get().getValue() : "";
                if (!oldValueStr.equals(newValueStr)) {
                    this.propagateMetadata(newValueStr);
                }
            }
            this.getEditor().markAsModified();
            this.setEffectiveOriginal();
        }
    }

    private void propagateMetadata(String newFlowRefName) {
        boolean moreThanOneFlowInAllConfigs;
        CustomMetadataAssistantService customMetadataAssistantService = (CustomMetadataAssistantService)this.project.getProjectComponent(CustomMetadataAssistantService.class);
        List configs = this.project.getConfigurationsCache().getConfigurations();
        ArrayList<MuleConfiguration> matchingConfigs = new ArrayList<MuleConfiguration>();
        MuleConfiguration targetMuleConfig = null;
        for (MuleConfiguration config : configs) {
            if (!config.getFlows().stream().anyMatch(flow -> flow.getName().equals(newFlowRefName))) continue;
            matchingConfigs.add(config);
            if (matchingConfigs.size() > 1) break;
            targetMuleConfig = config;
        }
        boolean hasRepeatedFlowNameInsideConfig = !matchingConfigs.isEmpty() && ((MuleConfiguration)matchingConfigs.get(0)).getFlows().stream().filter(flow -> flow.getName().equals(newFlowRefName)).count() > 1L;
        boolean bl = moreThanOneFlowInAllConfigs = matchingConfigs.size() > 1;
        if (targetMuleConfig != null && !hasRepeatedFlowNameInsideConfig && !moreThanOneFlowInAllConfigs) {
            MuleConfiguration originMuleConfig = this.getElement().getMuleConfiguration();
            MulePath originPath = originMuleConfig.getPathFor((IMessageFlowEntity)this.getElement().getEntity());
            Container targetFlowToRef = targetMuleConfig.getFlow(newFlowRefName).orElseGet(() -> null);
            DataSenseJob propagationJob = customMetadataAssistantService.getMetadataPropagationJob(originMuleConfig, originPath);
            IElementWrapper originFlowRefElement = this.getElement().getEntity().getElement();
            customMetadataAssistantService.resolveTranslatePersistAndAssignMetadata(propagationJob, propagationJob, originFlowRefElement, (MessageFlowNode)targetFlowToRef, false);
            AnalyticsRecordsFactory.single((String)Events.PROPAGATE_METADATA_SET_FLOW_TARGET_AUTOMATIC_PROPAGATION, (IMuleProject)this.getProject()).track();
        } else if (moreThanOneFlowInAllConfigs || hasRepeatedFlowNameInsideConfig) {
            new ErrorActionDialog(Display.getCurrent().getActiveShell(), DIALOG_TITLE, String.format(DIALOG_BODY, newFlowRefName)).open();
        }
    }

    protected void registerObservers(boolean isOnApply) {
        for (ObserverReference observer : this.observers) {
            if (isOnApply && !observer.isUnregisterOnApply()) continue;
            this.registerObserver(observer);
        }
    }

    protected void createRefAndAddToObservers(Observable observable, Observer observer) {
        this.createRefAndAddToObservers(observable, observer, true);
    }

    protected void createRefAndAddToObservers(Observable observable, Observer observer, boolean unRegisterOnApply) {
        this.observers.add(new ObserverReference(observer, observable, unRegisterOnApply));
    }

    protected void registerObserver(ObserverReference observerRef) {
        observerRef.register();
    }

    protected NodeDefinition getNodeDefinition() {
        return this.definition;
    }

    public PropertyCollectionMap getUpdatedProperties() {
        if (this.updatedPropertyCollection == null) {
            this.generateUpdatedProperties();
        }
        return this.updatedPropertyCollection;
    }

    public PropertyCollectionMap generateUpdatedProperties() {
        this.updatedPropertyCollection = this.getNodePropertiesEditorHandler().generateUpdatedPropertyCollection();
        ComponentId.copyComponentId((PropertyCollectionMap)this.getBefore().toPropertyCollectionMap(), (PropertyCollectionMap)this.updatedPropertyCollection);
        return this.updatedPropertyCollection;
    }

    @Override
    public void onClose() {
        DialogStack.unregister((ISimpleHost)this.getNodePropertiesEditorHandler().getPageHost());
        this.unRegisterObservers(false);
        this.observers.clear();
        this.nodePropertiesEditorHandler.dispose();
        this.editor = null;
        this.nodePropertiesEditorHandler = null;
    }

    @Override
    public void onOpen() {
        DialogStack.register((ISimpleHost)this.getNodePropertiesEditorHandler().getPageHost());
        this.definition = this.getMessageFlowNode().getDefinition();
        this.installObserver();
        this.registerObservers(false);
        this.getNodePropertiesEditorHandler().loadEditorPropertiesInformation();
        IMessageFlowNode entity = (IMessageFlowNode)this.getElement().getEntity();
        String name = entity.getName();
        this.titleHandler.setTitleMessage(name);
        PropertyCollectionMap propertyCollectionMap = entity.getProperties().toPropertyCollectionMap();
        this.setBefore(propertyCollectionMap.asPropertyCollection());
        this.updatedPropertyCollection = propertyCollectionMap;
        this.setEffectiveOriginal();
        this.originalName = name;
        this.originalDescription = entity.getDescription();
        this.getNodePropertiesEditorHandler().postInit();
    }

    @Override
    public void addActions(IToolBarManager toolbar) {
    }

    @Override
    public boolean handles(Object element) {
        return element instanceof PatternEditPart || element instanceof EndpointEditPart || element instanceof ContainerEditPart || element instanceof RouteEditPart || this.isErrorHandler(element);
    }

    private boolean isErrorHandler(Object element) {
        if (element instanceof NestedContainerEditPart) {
            NestedContainerEditPart nestedContainerEditPart = (NestedContainerEditPart)element;
            return "http://www.mulesoft.org/schema/mule/core/error-handler".equals(((NestedContainer)nestedContainerEditPart.getEntity()).getType());
        }
        return false;
    }

    @Override
    public Control createControl(Composite parent) {
        this.setNodePropertiesEditorHandler(new NodePropertiesUIEditor(this.getProject(), this.getEditor(), this.getMessageFlowNode(), this.getTitleHandler()));
        return this.getNodePropertiesEditorHandler().createControl(parent);
    }

    public IPropertiesTitle getTitleHandler() {
        return this.titleHandler;
    }

    public IMuleProject getProject() {
        return this.project;
    }

    public void setProject(IMuleProject project) {
        this.project = project;
    }

    public IMessageFlowNode getMessageFlowNode() {
        return (IMessageFlowNode)this.element.getEntity();
    }

    @Override
    public void onSave() {
        this.apply(false);
    }

    public T getElement() {
        return this.element;
    }

    public IMessageFlowEntityUIEditor getNodePropertiesEditorHandler() {
        return this.nodePropertiesEditorHandler;
    }

    @Override
    public boolean showDataSense() {
        return !ModelUtils.isRoute((IMessageFlowEntity)this.getMessageFlowNode());
    }

    public void setNodePropertiesEditorHandler(IMessageFlowEntityUIEditor nodePropertiesEditorHandler) {
        this.nodePropertiesEditorHandler = nodePropertiesEditorHandler;
    }

    @Override
    public boolean requiresMultiPageEditorShown() {
        return false;
    }

    @Override
    public String getHelpURL() {
        String type = this.getEntityType();
        if (type == null) {
            return null;
        }
        String helpLink = this.buildHelpLink(type);
        IContext context = HelpSystem.getContext((String)helpLink);
        if (context != null) {
            IHelpResource[] relatedTopics = context.getRelatedTopics();
            return relatedTopics[0].getHref();
        }
        return null;
    }

    private String buildHelpLink(String type) {
        String defaultHelpLink = "org.mule.tooling.ui.modules.core./" + type.replace('.', '_');
        String elementId = this.getCurrentElementId();
        if (!StringUtils.isEmpty((String)elementId)) {
            defaultHelpLink = defaultHelpLink + "?operation=" + elementId.substring(elementId.lastIndexOf(47) + 1);
        }
        return defaultHelpLink;
    }

    private String getCurrentElementId() {
        String elementId = "";
        if (this.getNodePropertiesEditorHandler() != null) {
            PropertyCollectionMap updatedProperties = this.getUpdatedProperties();
            PropertyCollection updated = updatedProperties.asPropertyCollection();
            elementId = PropertiesUtils.getPropertyValue((IPropertyCollectionReadCapability)updated, (String)"org.mule.tooling.ui.modules.core.widgets.meta.ModeAttribute");
        }
        return elementId;
    }

    protected String getEntityType() {
        return ((IMessageFlowNode)this.getElement().getEntity()).getType();
    }

    @Override
    public Optional<IMessageFlowNodePropertyManager> getPropertiesManager() {
        return Optional.ofNullable(this.getNodePropertiesEditorHandler());
    }

    @Override
    public void addPropertyValueChangeListener(IPropertyValueChangeListener propertyListener) {
        this.getNodePropertiesEditorHandler().addPropertyValueChangedListener(propertyListener);
    }

    @Override
    public void removeAllPropertyValueChangeListeners() {
        this.getNodePropertiesEditorHandler().removeAllPropertyValueChangeListeners();
    }

    public PropertyCollection getBefore() {
        return this.before;
    }

    public void setBefore(PropertyCollection before) {
        this.before = before;
    }

    private void setEffectiveOriginal() {
        this.effectiveOriginal = PropertiesUtils.getEffectivePropertyCollection((PropertyCollection)this.generateUpdatedProperties(false));
        this.removePropertiesNotMatchingXML(this.effectiveOriginal);
    }

    private void removePropertiesNotMatchingXML(PropertyCollection collection) {
        List toRemove = collection.getProperties().stream().filter(p -> {
            boolean valueInUIDifferentThanXML;
            Property originalValueInXml = this.before.getProperty(p.getName());
            String effectivePropertyValue = p.getValue();
            boolean valueFromUINotInXML = originalValueInXml == null && effectivePropertyValue != null;
            boolean bl = valueInUIDifferentThanXML = originalValueInXml != null && effectivePropertyValue != null && !effectivePropertyValue.equals(originalValueInXml.getValue());
            return valueFromUINotInXML || valueInUIDifferentThanXML;
        }).collect(Collectors.toList());
        toRemove.stream().forEach(arg_0 -> ((PropertyCollection)collection).removeProperty(arg_0));
    }

    public PropertyCollection getEffectiveOriginal() {
        return this.effectiveOriginal;
    }

    @Override
    public String getContentDescriptor() {
        return this.getMessageFlowNode().getType();
    }

    protected class ModelChangedObserver
    implements Observer {
        protected ModelChangedObserver() {
        }

        @Override
        public void update(Observable o, Object arg) {
            Event event;
            if (arg instanceof Event && "description".equalsIgnoreCase((event = (Event)arg).getEventType())) {
                return;
            }
            EntityEditPartPropertiesEditor.this.getNodePropertiesEditorHandler().loadEditorPropertiesInformation();
        }
    }

    protected class NameChangedObserver
    implements Observer {
        protected NameChangedObserver() {
        }

        @Override
        public void update(Observable o, Object arg) {
            if (arg.equals("name")) {
                EntityEditPartPropertiesEditor.this.titleHandler.setTitleMessage(((IMessageFlowNode)EntityEditPartPropertiesEditor.this.element.getEntity()).getName());
            }
        }
    }

    private class ObserverReference {
        private Observer observer;
        private WeakReference<Observable> observableRef;
        private boolean unregisterOnApply;

        public ObserverReference(Observer observer, Observable observable, boolean unregisterOnApply) {
            this.observer = observer;
            this.observableRef = new WeakReference<Observable>(observable);
            this.unregisterOnApply = unregisterOnApply;
        }

        public boolean toDispose() {
            return this.observableRef.get() == null;
        }

        public void unregister() {
            Observable observable = (Observable)this.observableRef.get();
            if (observable != null) {
                observable.deleteObserver(this.observer);
            }
        }

        public void register() {
            Observable observable = (Observable)this.observableRef.get();
            if (observable != null) {
                observable.addObserver(this.observer);
            }
        }

        public boolean isUnregisterOnApply() {
            return this.unregisterOnApply;
        }
    }
}

