/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.properties.editor;

import java.util.Optional;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.icons.ImagesManager;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.editpart.CommentEditPart;
import org.mule.tooling.model.messageflow.CommentContainer;
import org.mule.tooling.properties.editor.IPropertiesEditor;
import org.mule.tooling.properties.editor.IPropertiesTitle;
import org.mule.tooling.ui.modules.core.properties.IMessageFlowNodePropertyManager;
import org.mule.tooling.ui.modules.core.properties.IPropertyValueChangeListener;

public class CommentElementPropertiesEditor
implements IPropertiesEditor<CommentEditPart> {
    private CommentEditPart element;
    private IPropertiesTitle titleHandler;
    private Text txtDescription;
    private Group docGroup;

    @Override
    public boolean handles(Object element) {
        return element instanceof CommentEditPart;
    }

    @Override
    public boolean showDataSense() {
        return false;
    }

    @Override
    public void setTitleHandler(IPropertiesTitle titleHandler) {
        this.titleHandler = titleHandler;
    }

    @Override
    public void setEditElement(CommentEditPart element) {
        this.element = element;
    }

    @Override
    public void setMuleProject(IMuleProject project) {
    }

    @Override
    public Control createControl(Composite parent) {
        this.docGroup = new Group(parent, 0);
        GridLayout docLayout = new GridLayout(1, false);
        docLayout.horizontalSpacing = 10;
        this.docGroup.setLayout((Layout)docLayout);
        this.docGroup.setLayoutData((Object)new GridData(1808));
        Label descLabel = new Label((Composite)this.docGroup, 0);
        descLabel.setText("Comment:");
        descLabel.setLayoutData((Object)new GridData(2));
        this.txtDescription = new Text((Composite)this.docGroup, 2114);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        this.txtDescription.setEnabled(false);
        this.txtDescription.setLayoutData((Object)data);
        Composite commentComposite = new Composite((Composite)this.docGroup, 0);
        commentComposite.setLayout((Layout)new GridLayout(3, false));
        Button editButton = this.createButton(commentComposite, "Edit");
        Button applyButton = this.createButton(commentComposite, "Apply");
        applyButton.setEnabled(false);
        Button cancelButton = this.createButton(commentComposite, "Cancel");
        cancelButton.setEnabled(false);
        this.addListener(editButton, () -> {
            this.txtDescription.setEnabled(true);
            applyButton.setEnabled(true);
            cancelButton.setEnabled(true);
            editButton.setEnabled(false);
        });
        this.addListener(applyButton, () -> {
            this.txtDescription.setEnabled(false);
            ((CommentContainer)this.element.getEntity()).updateComment(this.txtDescription.getText());
            applyButton.setEnabled(false);
            cancelButton.setEnabled(false);
            editButton.setEnabled(true);
        });
        this.addListener(cancelButton, () -> {
            this.txtDescription.setText(((CommentContainer)this.element.getEntity()).getComment());
            this.txtDescription.setEnabled(false);
            applyButton.setEnabled(false);
            cancelButton.setEnabled(false);
            editButton.setEnabled(true);
        });
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)editButton);
        GridDataFactory.fillDefaults().indent(10, 0).align(0x1000008, 0x1000000).grab(true, false).applyTo((Control)applyButton);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(false, false).applyTo((Control)cancelButton);
        return this.docGroup;
    }

    private void addListener(Button button, final Runnable runnabble) {
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                runnabble.run();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private Button createButton(Composite parent, String Label2) {
        Button button = new Button(parent, 8);
        button.setText(Label2);
        return button;
    }

    @Override
    public void addActions(IToolBarManager toolbar) {
    }

    @Override
    public void setEditor(MultiPageMessageFlowEditor editor) {
    }

    @Override
    public void apply(boolean force) {
    }

    @Override
    public void onClose() {
    }

    @Override
    public void onSave() {
    }

    @Override
    public void onOpen() {
        this.txtDescription.setText(((CommentContainer)this.element.getEntity()).getComment());
        this.titleHandler.setTitleMessage("Comment");
        this.titleHandler.setImage(ImagesManager.getInstance().getPaletteUnknown());
    }

    @Override
    public boolean requiresMultiPageEditorShown() {
        return false;
    }

    @Override
    public Optional<IMessageFlowNodePropertyManager> getPropertiesManager() {
        return Optional.empty();
    }

    @Override
    public void addPropertyValueChangeListener(IPropertyValueChangeListener propertyListener) {
    }

    @Override
    public void removeAllPropertyValueChangeListeners() {
    }

    @Override
    public String getHelpURL() {
        return "";
    }

    @Override
    public String getContentDescriptor() {
        QName qName = ((CommentContainer)this.element.getEntity()).getElement().getQName();
        String namespaceURI = qName.getNamespaceURI();
        return (StringUtils.isEmpty((String)namespaceURI) ? qName.getPrefix() : namespaceURI) + "/" + qName.getLocalPart();
    }
}

