/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.properties;

import java.util.Optional;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.mule.tooling.platform.debug.DebugTraceProvider;
import org.mule.tooling.properties.views.MulePropertiesView;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.mule.tooling.properties";
    private static Activator plugin;
    private DebugTraceProvider debugTraceProvider;
    public static final String CREATE_UI_PERFORMANCE_ID;

    static {
        CREATE_UI_PERFORMANCE_ID = DebugTraceProvider.createDebugOptions((String)"create-ui-perf");
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.debugTraceProvider = DebugTraceProvider.newRegisterdInstance((BundleContext)context, (String)PLUGIN_ID);
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
        if (commandService != null) {
            commandService.addExecutionListener((IExecutionListener)new CommandListener());
        }
    }

    public static DebugTrace debugTracer() {
        return Activator.plugin.debugTraceProvider.debugTrace();
    }

    public void stop(BundleContext context) throws Exception {
        this.debugTraceProvider.unregister();
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static void logError(String message, Throwable t) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, message, t));
    }

    public static void logWarning(String message, Throwable t) {
        Activator.getDefault().getLog().log((IStatus)new Status(2, PLUGIN_ID, message, t));
    }

    public static void logWarning(String message) {
        Activator.getDefault().getLog().log((IStatus)new Status(2, PLUGIN_ID, message));
    }

    private static final class CommandListener
    implements IExecutionListener {
        private static final String COMMAND_SAVE_ID = "org.eclipse.ui.file.save";

        private CommandListener() {
        }

        public void notHandled(String commandId, NotHandledException exception) {
        }

        public void postExecuteFailure(String commandId, ExecutionException exception) {
        }

        public void postExecuteSuccess(String commandId, Object returnValue) {
        }

        public void preExecute(String commandId, ExecutionEvent event) {
            Optional<MulePropertiesView> viewIfPresent;
            if (COMMAND_SAVE_ID.endsWith(commandId) && (viewIfPresent = MulePropertiesView.getViewIfPresent()).isPresent()) {
                viewIfPresent.get().apply(false);
            }
        }
    }
}

