/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.debugger.view.impl;

import com.mulesoft.mule.debugger.client.IDebuggerClient;
import com.mulesoft.mule.debugger.dto.ObjectFieldDefinition;
import com.mulesoft.mule.debugger.exception.RemoteDebugException;
import com.mulesoft.mule.debugger.response.callback.DefaultDebuggerResponseCallback;
import com.mulesoft.mule.debugger.response.callback.IDebuggerResponseCallback;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.DebugEvents;
import org.mule.tooling.ui.contribution.debugger.controller.ObjectTreeNodeBuilder;
import org.mule.tooling.ui.contribution.debugger.controller.TreeNodeLabelProvider;
import org.mule.tooling.ui.contribution.debugger.service.MuleDebuggerService;
import org.mule.tooling.ui.contribution.debugger.view.impl.DebuggerWidgetsBuilder;
import org.mule.tooling.ui.contribution.debugger.view.impl.UpdateExpressionEditor;
import org.mule.tooling.ui.widgets.dialog.ISimpleDialogEditorPresenter;
import org.mule.tooling.ui.widgets.util.WidgetUtils;
import org.mule.tooling.utils.SilentRunner;

public class UpdateExpressionController
implements ISimpleDialogEditorPresenter<UpdateExpressionEditor> {
    private final ObjectFieldDefinition definition;
    private final TreeNode treeNode;
    private final Viewer viewer;
    private UpdateExpressionEditor editor;

    public UpdateExpressionController(ObjectFieldDefinition definition, TreeNode treeNode, ColumnViewer viewer) {
        this.definition = definition;
        this.treeNode = treeNode;
        this.viewer = viewer;
    }

    public void handle(UpdateExpressionEditor editor) {
        this.editor = editor;
        editor.getLabel().setText("Editing field '" + this.definition.getName() + "':");
        editor.getEditor().setTextDocument(this.getInitialValueForEditing());
    }

    private String getInitialValueForEditing() {
        return TreeNodeLabelProvider.PRIMITIVE_JDK_CLASSES_TO_BE_SHOWN.contains(this.definition.getClassName()) ? DebuggerWidgetsBuilder.getQuotedString(this.definition, (Boolean)true) : "";
    }

    public boolean onSave() {
        boolean canBeClosed = false;
        MuleDebuggerService debuggerService = MuleDebuggerService.getDefault();
        if (debuggerService.isDebugging()) {
            AnalyticsRecordsFactory.withCurrentMuleProject((String)DebugEvents.UPDATE_VALUE).addMetadata("variableName", this.definition.getName()).track();
            IDebuggerClient debuggerClient = debuggerService.getDebuggerClient();
            String textDocument = this.editor.getEditor().getTextDocument();
            UpdateExpressionCallback updateExpressionCallback = new UpdateExpressionCallback();
            debuggerClient.updateField(this.definition.getPath(), textDocument, debuggerService.getCurrentMuleMessageInfoId(), (IDebuggerResponseCallback)updateExpressionCallback);
            if (updateExpressionCallback.getUpdatedDefinition().isPresent()) {
                this.updateValue(this.treeNode, updateExpressionCallback.getUpdatedDefinition().get(), this.viewer);
                canBeClosed = true;
            }
        }
        return canBeClosed;
    }

    public boolean onCancel() {
        return true;
    }

    private void updateValue(TreeNode treeNode, ObjectFieldDefinition exceptionThrown, final Viewer viewer) {
        this.updateInput(treeNode, exceptionThrown, viewer);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                viewer.refresh();
            }
        });
    }

    private void updateInput(TreeNode treeNode, ObjectFieldDefinition def, Viewer viewer) {
        TreeNode parentTreeNode = treeNode.getParent();
        if (parentTreeNode != null) {
            TreeNode[] children = parentTreeNode.getChildren();
            this.replaceChild(children, treeNode, def);
        } else {
            TreeNode[] input = (TreeNode[])viewer.getInput();
            this.replaceChild(input, treeNode, def);
        }
    }

    private void replaceChild(TreeNode[] children, TreeNode treeNodeToReplace, ObjectFieldDefinition def) {
        int i = 0;
        while (i < children.length) {
            if (children[i].equals((Object)treeNodeToReplace)) {
                ObjectFieldDefinition newDef = this.createDefinitionWithOldName(treeNodeToReplace, def);
                children[i] = ObjectTreeNodeBuilder.createTreeNode(newDef);
                children[i].setParent(treeNodeToReplace.getParent());
                break;
            }
            ++i;
        }
    }

    private ObjectFieldDefinition createDefinitionWithOldName(TreeNode treeNodeToReplace, ObjectFieldDefinition def) {
        ObjectFieldDefinition defToReplace = (ObjectFieldDefinition)treeNodeToReplace.getValue();
        return new ObjectFieldDefinition(defToReplace.getName(), def.getClassName(), def.getValue(), def.getInnerElements(), def.getModifiers(), def.getPath(), def.getDwAccessor());
    }

    private static class UpdateExpressionCallback
    extends DefaultDebuggerResponseCallback {
        private Optional<ObjectFieldDefinition> updatedDefinition = Optional.empty();
        private CountDownLatch latch = new CountDownLatch(1);

        public void onScriptEvaluationException(RemoteDebugException exception) {
            this.latch.countDown();
            Display.getDefault().asyncExec(() -> WidgetUtils.showException((String)"Error while evaulating", (String)exception.getMessage()));
        }

        public void onFieldUpdated(ObjectFieldDefinition def) {
            this.updatedDefinition = Optional.ofNullable(def);
            this.latch.countDown();
        }

        public Optional<ObjectFieldDefinition> getUpdatedDefinition() {
            SilentRunner.run(() -> this.latch.await(10L, TimeUnit.SECONDS));
            return this.updatedDefinition;
        }
    }
}

